/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.tml.data.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTDeserializer
implements JsonDeserializer<NBTTagCompound> {
    public NBTTagCompound deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry elementEntry : json.getAsJsonObject().entrySet()) {
            String key = (String)elementEntry.getKey();
            JsonElement element = (JsonElement)elementEntry.getValue();
            this.parseJSONElement(nbt, key, element);
        }
        return nbt;
    }

    public void parseJSONElement(NBTTagCompound nbt, String key, JsonElement element) {
        if (element.isJsonPrimitive()) {
            if (key.contains(":")) {
                String type = key.substring(0, key.indexOf(":"));
                String name = key.substring(key.indexOf(":") + 1, key.length());
                nbt.func_74782_a(name, this.getForcedTagFromElement(type, element));
            } else {
                nbt.func_74782_a(key, this.getTagFromPrimitive(element.getAsJsonPrimitive()));
            }
        } else if (element.isJsonArray()) {
            if (key.contains(":")) {
                String type = key.substring(0, key.indexOf(":"));
                String name = key.substring(key.indexOf(":") + 1, key.length());
                nbt.func_74782_a(name, this.getArrayFromElement(type, element.getAsJsonArray()));
            }
        } else if (element.isJsonObject()) {
            NBTTagCompound tag = new NBTTagCompound();
            for (Map.Entry elementEntry : element.getAsJsonObject().entrySet()) {
                this.parseJSONElement(tag, (String)elementEntry.getKey(), (JsonElement)elementEntry.getValue());
            }
            nbt.func_74782_a(key, (NBTBase)tag);
        }
    }

    public NBTBase getTagFromPrimitive(JsonPrimitive primitive) {
        if (primitive.isBoolean()) {
            return new NBTTagByte((byte)(primitive.getAsBoolean() ? 1 : 0));
        }
        if (primitive.isNumber()) {
            return new NBTTagInt(primitive.getAsNumber().intValue());
        }
        if (primitive.isString()) {
            return new NBTTagString(primitive.getAsString());
        }
        throw new JsonParseException("Failed to retrieve NBT tag from non-primitive element!");
    }

    public NBTBase getArrayFromElement(String type, JsonArray array) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < array.size(); ++i) {
            list.func_74742_a(this.getForcedTagFromElement(type, array.get(i)));
        }
        return list;
    }

    public NBTBase getForcedTagFromElement(String type, JsonElement element) {
        if (type.equalsIgnoreCase("string")) {
            return new NBTTagString(element.getAsString());
        }
        if (type.equalsIgnoreCase("byte")) {
            return new NBTTagByte(element.getAsByte());
        }
        if (type.equalsIgnoreCase("bool") || type.equalsIgnoreCase("boolean")) {
            return new NBTTagByte((byte)(element.getAsBoolean() ? 1 : 0));
        }
        if (type.equalsIgnoreCase("short")) {
            return new NBTTagShort(element.getAsShort());
        }
        if (type.equalsIgnoreCase("int") || type.equalsIgnoreCase("integer")) {
            return new NBTTagInt(element.getAsInt());
        }
        if (type.equalsIgnoreCase("float")) {
            return new NBTTagFloat(element.getAsFloat());
        }
        if (type.equalsIgnoreCase("double")) {
            return new NBTTagDouble(element.getAsDouble());
        }
        if (type.equalsIgnoreCase("long")) {
            return new NBTTagLong(element.getAsLong());
        }
        return null;
    }
}

