/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.tml.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cpw.mods.fml.common.registry.GameData;
import dmillerw.tml.data.json.LootArrayDeserializer;
import dmillerw.tml.data.json.NBTDeserializer;
import dmillerw.tml.helper.LogHelper;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class LootLoader {
    private static Gson gson;

    public static LootArrayWrapper loadFile(File file) {
        try {
            return (LootArrayWrapper)gson.fromJson((Reader)new FileReader(file), LootArrayWrapper.class);
        }
        catch (Exception ex) {
            LogHelper.warn(String.format("Failed to parse %s! Reason: %s", file.getName(), LogHelper.interpretReason(ex.getMessage())), false);
            return null;
        }
    }

    public static void loadLoot(SerializedLoot loot) {
        if (loot == null) {
            return;
        }
        ItemStack stack = new ItemStack((Item)GameData.getItemRegistry().func_82594_a(loot.item), 1, loot.damage);
        if (stack.func_77973_b() == null) {
            LogHelper.warn(String.format("Tried to add %s to the %s category, but couldn't find the item!", loot.item, loot.category), false);
            return;
        }
        if (!loot.nbt.func_82582_d()) {
            stack.func_77982_d(loot.nbt);
        }
        for (String category : loot.category) {
            LogHelper.logAddition(category, stack.func_82833_r());
            ChestGenHooks.getInfo((String)category).addItem(new WeightedRandomChestContent(stack, loot.min_count, loot.max_count, loot.weight));
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(LootArrayWrapper.class, (Object)new LootArrayDeserializer());
        builder.registerTypeAdapter(NBTTagCompound.class, (Object)new NBTDeserializer());
        gson = builder.create();
    }

    public static class SerializedLoot {
        public String[] category;
        public String item;
        public int damage = 0;
        public NBTTagCompound nbt = new NBTTagCompound();
        public int weight;
        public int min_count;
        public int max_count;
    }

    public static class LootArrayWrapper {
        public SerializedLoot[] loot;
    }
}

