/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.tml;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import dmillerw.tml.config.ConfigHandler;
import dmillerw.tml.data.LootLoader;
import dmillerw.tml.helper.LogHelper;
import java.io.File;
import java.lang.reflect.Field;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ChestGenHooks;

@Mod(modid="TML", name="TooMuchLoot", version="3.0.1", dependencies="required-after:Forge@[10.13.0.1180,)", guiFactory="dmillerw.tml.client.config.ConfigGUIFactory")
public class TooMuchLoot {
    public static final String CONFIG_FOLDER = "TooMuchLoot";
    public static final String CONFIG_FILE = "MainConfig.cfg";
    public static final String GEN_FOLDER = "gen";
    public static final String LOOT_FOLDER = "loot";
    public static String[] CHEST_GEN_KEYS = new String[]{"mineshaftCorridor", "pyramidDesertyChest", "pyramidJungleChest", "pyramidJungleDispenser", "strongholdCorridor", "strongholdLibrary", "strongholdCrossing", "villageBlacksmith", "bonusChest", "dungeonChest"};
    @Mod.Instance(value="TML")
    public static TooMuchLoot instance;
    public static File configFolder;
    public static File lootFolder;
    public static Field contents;
    public static boolean failed;

    public static String getFormattedStackString(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return "null";
        }
        return stack.func_77977_a() + ";" + stack.func_77960_j();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configFolder = new File(event.getModConfigurationDirectory(), CONFIG_FOLDER);
        lootFolder = new File(configFolder, LOOT_FOLDER);
        ConfigHandler.configFile = new File(configFolder, CONFIG_FILE);
        ConfigHandler.initializeMain();
        ConfigHandler.syncMain();
        try {
            contents = ChestGenHooks.class.getDeclaredField("contents");
            contents.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            failed = true;
            LogHelper.warn("Failed to obtain contents field. This mod will now cease to function.", true);
            e.printStackTrace();
        }
        FMLCommonHandler.instance().bus().register((Object)instance);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        File lootFolder = new File(configFolder, LOOT_FOLDER);
        if (!lootFolder.exists()) {
            lootFolder.mkdir();
        }
        for (File file : lootFolder.listFiles()) {
            String name = file.getName();
            if (!name.substring(name.lastIndexOf(".") + 1, name.length()).equalsIgnoreCase("json")) continue;
            LogHelper.logParse(name);
            LootLoader.LootArrayWrapper wrapper = LootLoader.loadFile(file);
            if (wrapper == null) continue;
            for (LootLoader.SerializedLoot loot : wrapper.loot) {
                LootLoader.loadLoot(loot);
            }
        }
        ConfigHandler.initializeLoot();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerAboutToStartEvent event) {
        if (failed) {
            return;
        }
        ConfigHandler.syncLoot();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("TML")) {
            ConfigHandler.syncMain();
            ConfigHandler.syncLoot();
        }
    }

    static {
        failed = false;
    }
}

