/*
 * Decompiled with CFR 0.152.
 */
package talonos.blightbuster.tileentity;

import cofh.api.energy.IEnergyReceiver;
import cofh.api.energy.IEnergyStorage;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import talonos.blightbuster.BlightBuster;
import talonos.blightbuster.network.BlightbusterNetwork;
import talonos.blightbuster.network.packets.SpawnCleanseParticlesPacket;
import talonos.blightbuster.tileentity.dawnmachine.DawnMachineResource;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.common.blocks.BlockFluxGoo;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.entities.EntityFallingTaint;
import thaumcraft.common.entities.monster.EntityTaintChicken;
import thaumcraft.common.entities.monster.EntityTaintCow;
import thaumcraft.common.entities.monster.EntityTaintCreeper;
import thaumcraft.common.entities.monster.EntityTaintPig;
import thaumcraft.common.entities.monster.EntityTaintSheep;
import thaumcraft.common.entities.monster.EntityTaintSporeSwarmer;
import thaumcraft.common.entities.monster.EntityTaintVillager;
import thaumcraft.common.tiles.TileNode;

public class DawnMachineTileEntity
extends TileEntity
implements IAspectSource,
IAspectContainer,
IEnergyReceiver,
IEnergyStorage {
    private int currentRf = 0;
    public static final int MAX_RF = 128000;
    protected static final int FULLGREEN_RF = 80000;
    protected static final int FULLYELLOW_RF = 40000;
    protected static final int FULLRED_RF = 20000;
    public static final int DEAD_RF = 150;
    protected static final Vec3 COLOR_GREEN = Vec3.func_72443_a((double)0.0, (double)0.9, (double)0.0);
    protected static final Vec3 COLOR_YELLOW = Vec3.func_72443_a((double)0.9, (double)0.9, (double)0.0);
    protected static final Vec3 COLOR_RED = Vec3.func_72443_a((double)0.9, (double)0.0, (double)0.0);
    private boolean aerIsActive = false;
    private int aerCooldownRemaining = 0;
    public static final int AER_COOLDOWN = 600;
    private boolean spendAer = false;
    private int ticksSinceLastCleanse = 0;
    private int lastCleanseX = Integer.MAX_VALUE;
    private int lastCleanseZ = Integer.MAX_VALUE;
    private double blinkProgress = 0.0;
    private AspectList internalAspectList = new AspectList();
    private boolean hasInitializedChunkloading = false;

    public void func_145845_h() {
        if (this.func_145831_w().func_72878_l(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1) > 0) {
            return;
        }
        if (this.func_145831_w().field_72995_K) {
            if (this.currentRf <= 20000) {
                this.blinkProgress += 1.0;
            }
            return;
        }
        if (!this.hasInitializedChunkloading) {
            BlightBuster.instance.chunkLoader.newDawnMachine(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.hasInitializedChunkloading = true;
        }
        if (this.aerCooldownRemaining > 0) {
            --this.aerCooldownRemaining;
        }
        int cleanseLength = this.haveEnoughFor(DawnMachineResource.MACHINA) ? 4 : 12;
        this.ticksSinceLastCleanse %= cleanseLength;
        if (this.ticksSinceLastCleanse == 0) {
            this.setUpAerRange();
            for (int i = 0; i < 5; ++i) {
                int secondaryBlocks = this.getNewCleanseCoords();
                boolean anythingToDo = this.hasAnythingToCleanseHere(secondaryBlocks);
                if (anythingToDo || !this.haveEnoughFor(DawnMachineResource.COGNITIO)) {
                    if (cleanseLength == 4) {
                        this.spend(DawnMachineResource.MACHINA);
                    }
                    this.executeCleanse(secondaryBlocks);
                    ++this.ticksSinceLastCleanse;
                    break;
                }
                this.spend(DawnMachineResource.COGNITIO);
            }
        } else {
            ++this.ticksSinceLastCleanse;
        }
    }

    protected void executeCleanse(int secondaryBlocks) {
        Entity entity;
        if (this.spendAer) {
            this.spendAer = false;
            this.spend(DawnMachineResource.AER);
        }
        for (Object entityObj : this.func_145831_w().func_72872_a(EntityTaintSporeSwarmer.class, AxisAlignedBB.func_72330_a((double)this.lastCleanseX, (double)0.0, (double)this.lastCleanseZ, (double)(this.lastCleanseX + 2), (double)255.0, (double)(this.lastCleanseZ + 2)))) {
            entity = (Entity)entityObj;
            if (!this.haveEnoughFor(DawnMachineResource.IGNIS)) continue;
            this.spend(DawnMachineResource.IGNIS);
            if (this.haveEnoughFor(DawnMachineResource.VACUOS)) {
                this.spend(DawnMachineResource.VACUOS);
            } else {
                this.func_145831_w().func_147465_d((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, ConfigBlocks.blockFluxGoo, ((BlockFluxGoo)ConfigBlocks.blockFluxGoo).getQuanta(), 3);
            }
            entity.func_70106_y();
        }
        for (Object entityObj : this.func_145831_w().func_72872_a(EntityFallingTaint.class, AxisAlignedBB.func_72330_a((double)this.lastCleanseX, (double)0.0, (double)this.lastCleanseZ, (double)(this.lastCleanseX + 2), (double)255.0, (double)(this.lastCleanseZ + 2)))) {
            if (!this.haveEnoughFor(DawnMachineResource.IGNIS)) continue;
            entity = (Entity)entityObj;
            this.spend(DawnMachineResource.IGNIS);
            if (this.haveEnoughFor(DawnMachineResource.VACUOS)) {
                this.spend(DawnMachineResource.VACUOS);
            } else {
                this.func_145831_w().func_147465_d((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, ConfigBlocks.blockFluxGoo, ((BlockFluxGoo)ConfigBlocks.blockFluxGoo).getQuanta(), 3);
            }
            entity.func_70106_y();
        }
        this.cleanseBiome(secondaryBlocks);
        boolean didUseIgnis = this.cleanseBlocks();
        if (this.haveEnoughFor(DawnMachineResource.SANO)) {
            this.cleanseMobs();
        }
        BlightbusterNetwork.sendToNearbyPlayers(new SpawnCleanseParticlesPacket(this.lastCleanseX, this.lastCleanseZ, didUseIgnis, true), this.field_145850_b.field_73011_w.field_76574_g, this.lastCleanseX, 128.0f, this.lastCleanseZ, 150.0f);
    }

    protected boolean hasAnythingToCleanseHere(int secondaryBlocks) {
        int x;
        int z;
        for (z = -1; z <= 2; ++z) {
            for (x = -1; x <= 2; ++x) {
                if (z < 0 && (secondaryBlocks & 4) == 0 || z > 1 && (secondaryBlocks & 8) == 0 || x < 0 && (secondaryBlocks & 1) == 0 || x > 1 && (secondaryBlocks & 2) == 0) continue;
                BiomeGenBase biome = this.func_145831_w().func_72807_a(this.lastCleanseX + x, this.lastCleanseZ + z);
                if (biome.field_76756_M != Config.biomeTaintID && biome.field_76756_M != Config.biomeEerieID && biome.field_76756_M != Config.biomeMagicalForestID) continue;
                return true;
            }
        }
        if (this.haveEnoughFor(DawnMachineResource.SANO) && this.func_145831_w().func_72872_a(ITaintedMob.class, AxisAlignedBB.func_72330_a((double)this.lastCleanseX, (double)0.0, (double)this.lastCleanseZ, (double)(this.lastCleanseX + 2), (double)255.0, (double)(this.lastCleanseZ + 2))).size() > 0) {
            return true;
        }
        for (z = 0; z <= 1; ++z) {
            for (x = 0; x <= 1; ++x) {
                int herbaTopBlock = -1;
                boolean canHerba = this.haveEnoughFor(DawnMachineResource.HERBA);
                if (canHerba) {
                    herbaTopBlock = this.func_145831_w().func_72825_h(this.lastCleanseX + x, this.lastCleanseZ + z);
                }
                boolean canIgnis = this.haveEnoughFor(DawnMachineResource.IGNIS);
                boolean canVacuos = this.haveEnoughFor(DawnMachineResource.VACUOS);
                boolean canAura = this.haveEnoughFor(DawnMachineResource.AURAM);
                if (!canIgnis && !canVacuos && !canHerba && !canAura) continue;
                for (int i = 0; i < 256; ++i) {
                    TileNode node;
                    Block block = this.func_145831_w().func_147439_a(this.lastCleanseX + x, i, this.lastCleanseZ + z);
                    int meta = this.func_145831_w().func_72805_g(this.lastCleanseX + x, i, this.lastCleanseZ + z);
                    if (canIgnis && block == ConfigBlocks.blockTaintFibres) {
                        return true;
                    }
                    if (canIgnis && block == ConfigBlocks.blockTaint && meta != 2) {
                        return true;
                    }
                    if (canVacuos && block == ConfigBlocks.blockFluxGoo) {
                        return true;
                    }
                    if (canHerba && i == herbaTopBlock && block == Blocks.field_150346_d) {
                        return true;
                    }
                    if (!canAura || block != ConfigBlocks.blockAiry || meta != 0 || (node = (TileNode)this.func_145831_w().func_147438_o(this.lastCleanseX + x, i, this.lastCleanseZ + z)) == null || node.getNodeType() != NodeType.TAINTED) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void cleanseBiome(int secondaryBlocks) {
        boolean canVacuos = this.haveEnoughFor(DawnMachineResource.VACUOS);
        for (int z = -1; z <= 2; ++z) {
            block1: for (int x = -1; x <= 2; ++x) {
                if (z < 0 && (secondaryBlocks & 4) == 0 || z > 1 && (secondaryBlocks & 8) == 0 || x < 0 && (secondaryBlocks & 1) == 0 || x > 1 && (secondaryBlocks & 2) == 0) continue;
                BiomeGenBase biome = this.func_145831_w().func_72807_a(this.lastCleanseX + x, this.lastCleanseZ + z);
                if (biome.field_76756_M == Config.biomeTaintID || biome.field_76756_M == Config.biomeEerieID || biome.field_76756_M == Config.biomeMagicalForestID) {
                    BiomeGenBase[] genBiomes = null;
                    genBiomes = this.func_145831_w().func_72959_q().func_76933_b(genBiomes, this.lastCleanseX + x, this.lastCleanseZ + z, 1, 1);
                    if (genBiomes != null && genBiomes.length > 0 && genBiomes[0] != null) {
                        BlightbusterNetwork.setBiomeAt(this.func_145831_w(), this.lastCleanseX + x, this.lastCleanseZ + z, genBiomes[0]);
                    }
                }
                if (!canVacuos || x >= 0 && z >= 0 && x <= 1 && z <= 1) continue;
                for (int y = 0; y < 255; ++y) {
                    Block block = this.func_145831_w().func_147439_a(this.lastCleanseX + x, y, this.lastCleanseZ + z);
                    if (block != ConfigBlocks.blockFluxGoo) continue;
                    this.func_145831_w().func_147449_b(this.lastCleanseX + x, y, this.lastCleanseZ + z, Blocks.field_150350_a);
                    this.spend(DawnMachineResource.VACUOS);
                    canVacuos = this.haveEnoughFor(DawnMachineResource.VACUOS);
                    if (!canVacuos) continue block1;
                }
            }
        }
    }

    protected boolean cleanseBlocks() {
        boolean haveUsedIgnis = false;
        for (int x = 0; x <= 1; ++x) {
            for (int z = 0; z <= 1; ++z) {
                boolean canArbor = this.haveEnoughFor(DawnMachineResource.ARBOR);
                boolean canHerba = this.haveEnoughFor(DawnMachineResource.HERBA);
                boolean foundTopBlock = false;
                int topBlock = -1;
                int columnCrustedTaint = 0;
                for (int y = 255; y >= 0; --y) {
                    boolean thisIsCrustedTaint;
                    Block block = this.func_145831_w().func_147439_a(this.lastCleanseX + x, y, this.lastCleanseZ + z);
                    int meta = this.func_145831_w().func_72805_g(this.lastCleanseX + x, y, this.lastCleanseZ + z);
                    boolean bl = thisIsCrustedTaint = block == ConfigBlocks.blockTaint && meta == 0;
                    if (thisIsCrustedTaint && this.haveEnoughFor(DawnMachineResource.IGNIS) && this.haveEnoughFor(DawnMachineResource.VACUOS)) {
                        ++columnCrustedTaint;
                    }
                    if (!foundTopBlock && (canHerba || canArbor) && block.func_149662_c()) {
                        foundTopBlock = true;
                        topBlock = y;
                    }
                    boolean didUseIgnis = this.cleanseSingleBlock(this.lastCleanseX + x, y, this.lastCleanseZ + z, block, meta, canHerba && foundTopBlock && y == topBlock);
                    boolean bl2 = haveUsedIgnis = didUseIgnis || haveUsedIgnis;
                    if (!didUseIgnis || this.func_145831_w().func_147439_a(this.lastCleanseX + x, y, this.lastCleanseZ + z) == Blocks.field_150346_d) continue;
                    foundTopBlock = false;
                }
                if (columnCrustedTaint < 3 || !foundTopBlock) continue;
                BiomeGenBase biome = this.func_145831_w().func_72807_a(this.lastCleanseX + x, this.lastCleanseZ + z);
                String biomeName = biome.field_76791_y.toLowerCase(Locale.ENGLISH);
                int treeType = 0;
                if (biomeName.contains("jungle")) {
                    treeType = 3;
                } else if (biomeName.contains("taiga") || biomeName.contains("tundra")) {
                    treeType = 2;
                } else if (biomeName.contains("birch")) {
                    treeType = 1;
                } else if (biomeName.contains("savanna")) {
                    treeType = 4;
                } else if (biomeName.contains("roof")) {
                    treeType = 5;
                }
                this.func_145831_w().func_147465_d(this.lastCleanseX + x, topBlock + 1, this.lastCleanseZ + z, Blocks.field_150345_g, treeType, 3);
                this.spend(DawnMachineResource.ARBOR);
            }
        }
        return haveUsedIgnis;
    }

    private boolean cleanseSingleBlock(int x, int y, int z, Block block, int meta, boolean doHerbaCheck) {
        boolean canIgnis = this.haveEnoughFor(DawnMachineResource.IGNIS);
        boolean canVacuos = this.haveEnoughFor(DawnMachineResource.VACUOS);
        if (canIgnis && block == ConfigBlocks.blockTaint && meta == 0) {
            this.spend(DawnMachineResource.IGNIS);
            Block replaceBlock = ConfigBlocks.blockFluxGoo;
            int replaceMeta = ((BlockFluxGoo)ConfigBlocks.blockFluxGoo).getQuanta();
            if (this.haveEnoughFor(DawnMachineResource.VACUOS)) {
                this.spend(DawnMachineResource.VACUOS);
                replaceBlock = Blocks.field_150350_a;
                replaceMeta = 0;
            }
            this.func_145831_w().func_147465_d(x, y, z, replaceBlock, replaceMeta, 3);
            return true;
        }
        if (canIgnis && block == ConfigBlocks.blockTaint && meta == 1) {
            this.spend(DawnMachineResource.IGNIS);
            Block replaceBlock = Blocks.field_150346_d;
            if (doHerbaCheck) {
                this.spend(DawnMachineResource.HERBA);
                replaceBlock = Blocks.field_150349_c;
            }
            this.func_145831_w().func_147449_b(x, y, z, replaceBlock);
            return true;
        }
        if (canIgnis && block == ConfigBlocks.blockTaintFibres) {
            this.spend(DawnMachineResource.IGNIS);
            this.func_145831_w().func_147449_b(x, y, z, Blocks.field_150350_a);
            return true;
        }
        if (canVacuos && block == ConfigBlocks.blockFluxGoo) {
            this.spend(DawnMachineResource.VACUOS);
            this.func_145831_w().func_147449_b(x, y, z, Blocks.field_150350_a);
            return false;
        }
        if (doHerbaCheck && block == Blocks.field_150346_d) {
            this.spend(DawnMachineResource.HERBA);
            this.func_145831_w().func_147449_b(x, y, z, (Block)Blocks.field_150349_c);
            return false;
        }
        if (this.haveEnoughFor(DawnMachineResource.AURAM) && GameRegistry.findUniqueIdentifierFor((Block)block).modId.equals("Thaumcraft")) {
            TileNode node;
            TileEntity tile = this.func_145831_w().func_147438_o(x, y, z);
            if (tile != null && tile instanceof TileNode && (node = (TileNode)tile) != null && node.getNodeType() == NodeType.TAINTED) {
                this.spend(DawnMachineResource.AURAM);
                node.setNodeType(NodeType.NORMAL);
                node.func_70296_d();
                this.func_145831_w().func_147471_g(x, y, z);
            }
            return false;
        }
        return false;
    }

    protected void cleanseMobs() {
        List entities = this.func_145831_w().func_72872_a(ITaintedMob.class, AxisAlignedBB.func_72330_a((double)this.lastCleanseX, (double)0.0, (double)this.lastCleanseZ, (double)(this.lastCleanseX + 2), (double)256.0, (double)(this.lastCleanseZ + 2)));
        for (Object entityObj : entities) {
            if (entityObj instanceof EntityTaintSheep) {
                this.spend(DawnMachineResource.SANO);
                this.cleanseSingleMob((Entity)entityObj, (EntityLivingBase)new EntitySheep(this.func_145831_w()));
            } else if (entityObj instanceof EntityTaintChicken) {
                this.spend(DawnMachineResource.SANO);
                this.cleanseSingleMob((Entity)entityObj, (EntityLivingBase)new EntityChicken(this.func_145831_w()));
            } else if (entityObj instanceof EntityTaintCow) {
                this.spend(DawnMachineResource.SANO);
                this.cleanseSingleMob((Entity)entityObj, (EntityLivingBase)new EntityCow(this.func_145831_w()));
            } else if (entityObj instanceof EntityTaintPig) {
                this.spend(DawnMachineResource.SANO);
                this.cleanseSingleMob((Entity)entityObj, (EntityLivingBase)new EntityPig(this.func_145831_w()));
            } else if (entityObj instanceof EntityTaintVillager) {
                this.spend(DawnMachineResource.SANO);
                this.cleanseSingleMob((Entity)entityObj, (EntityLivingBase)new EntityVillager(this.func_145831_w()));
            } else if (entityObj instanceof EntityTaintCreeper) {
                this.spend(DawnMachineResource.SANO);
                this.cleanseSingleMob((Entity)entityObj, (EntityLivingBase)new EntityCreeper(this.func_145831_w()));
            }
            if (this.haveEnoughFor(DawnMachineResource.SANO)) continue;
            return;
        }
    }

    private void cleanseSingleMob(Entity tainted, EntityLivingBase cleansed) {
        cleansed.func_82149_j(tainted);
        tainted.field_70170_p.func_72838_d((Entity)cleansed);
        cleansed.field_70170_p.func_72900_e(tainted);
    }

    public boolean spendAndCheck(DawnMachineResource resource) {
        this.spend(resource);
        return this.haveEnoughFor(resource);
    }

    public boolean haveEnoughFor(DawnMachineResource resource) {
        int energyCost = resource.getEnergyCost();
        boolean halfEssentia = false;
        if (this.currentRf >= energyCost) {
            halfEssentia = true;
        }
        int cost = resource.getAspectCost();
        if (halfEssentia) {
            cost /= 2;
        }
        return this.internalAspectList.getAmount(resource.getAspect()) >= cost;
    }

    public void spend(DawnMachineResource resource) {
        if (!this.haveEnoughFor(resource)) {
            return;
        }
        int energyCost = resource.getEnergyCost();
        boolean halfEssentia = false;
        if (this.currentRf >= energyCost) {
            halfEssentia = true;
            this.currentRf -= energyCost;
        }
        int cost = resource.getAspectCost();
        if (halfEssentia) {
            cost /= 2;
        }
        this.internalAspectList.remove(resource.getAspect(), cost);
        this.signalUpdate();
    }

    private void setUpAerRange() {
        boolean aerChunkLoadingActive = BlightBuster.instance.chunkLoader.getAerStatus(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean canAffordAer = this.haveEnoughFor(DawnMachineResource.AER);
        if (!(canAffordAer == this.aerIsActive || canAffordAer && this.aerCooldownRemaining > 0)) {
            this.aerIsActive = canAffordAer;
            if (!canAffordAer) {
                this.aerCooldownRemaining = 600;
            }
        }
        if (this.aerIsActive != aerChunkLoadingActive) {
            BlightBuster.instance.chunkLoader.changeAerStatus(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.aerIsActive);
        }
    }

    private int getNewCleanseCoords() {
        int chunkX = this.field_145851_c / 16;
        int chunkZ = this.field_145849_e / 16;
        int xInChunk = this.field_145851_c % 16;
        int zInChunk = this.field_145849_e % 16;
        int minChunkX = chunkX - 1;
        int minChunkZ = chunkZ - 1;
        int maxChunkX = chunkX + 2;
        int maxChunkZ = chunkZ + 2;
        int freeMinChunkX = minChunkX;
        int freeMinChunkZ = minChunkZ;
        int freeMaxChunkX = maxChunkX;
        int freeMaxChunkZ = maxChunkZ;
        if (this.haveEnoughFor(DawnMachineResource.AER)) {
            minChunkX -= 2;
            minChunkZ -= 2;
            maxChunkX += 2;
            maxChunkZ += 2;
        }
        if (xInChunk < 8) {
            --minChunkX;
            --maxChunkX;
        }
        if (zInChunk < 8) {
            --minChunkZ;
            --maxChunkZ;
        }
        int minBlockX = minChunkX * 16;
        int minBlockZ = minChunkZ * 16;
        int maxBlockX = maxChunkX * 16 + 15;
        int maxBlockZ = maxChunkZ * 16 + 15;
        if (this.haveEnoughFor(DawnMachineResource.ORDO)) {
            this.spend(DawnMachineResource.ORDO);
            this.generateScanlineCoords(minBlockX, minBlockZ, maxBlockX, maxBlockZ);
        } else {
            this.generateRandomCoords(minBlockX, minBlockZ, maxBlockX, maxBlockZ);
        }
        int cleanseChunkX = this.lastCleanseX / 16;
        int cleanseChunkZ = this.lastCleanseZ / 16;
        if (cleanseChunkX < freeMinChunkX || cleanseChunkZ < freeMinChunkZ || cleanseChunkX > freeMaxChunkX || cleanseChunkZ > freeMaxChunkZ) {
            this.spendAer = true;
        }
        int secondaryBlocks = 15;
        if (this.lastCleanseX == minBlockX) {
            secondaryBlocks &= 0xE;
        } else if (this.lastCleanseX == maxBlockX) {
            secondaryBlocks &= 0xD;
        }
        if (this.lastCleanseZ == minBlockZ) {
            secondaryBlocks &= 0xB;
        } else if (this.lastCleanseZ == maxBlockZ) {
            secondaryBlocks &= 7;
        }
        return secondaryBlocks;
    }

    private void generateScanlineCoords(int minX, int minZ, int maxX, int maxZ) {
        if (this.lastCleanseX == Integer.MAX_VALUE || this.lastCleanseX < minX) {
            this.lastCleanseX = minX - 2;
        }
        if (this.lastCleanseZ == Integer.MAX_VALUE || this.lastCleanseZ < minZ) {
            this.lastCleanseZ = minZ;
        }
        this.lastCleanseX -= this.lastCleanseX % 2;
        this.lastCleanseZ -= this.lastCleanseZ % 2;
        this.lastCleanseX += 2;
        if (this.lastCleanseX > maxX) {
            this.lastCleanseX = minX;
            this.lastCleanseZ += 2;
        }
        if (this.lastCleanseZ > maxZ) {
            this.lastCleanseZ = minZ;
        }
    }

    private void generateRandomCoords(int minX, int minZ, int maxX, int maxZ) {
        int diffX = maxX - minX + 1;
        int diffZ = maxZ - minZ + 1;
        this.lastCleanseX = this.func_145831_w().field_73012_v.nextInt(diffX) + minX;
        this.lastCleanseZ = this.func_145831_w().field_73012_v.nextInt(diffZ) + minZ;
        this.lastCleanseX -= this.lastCleanseX % 2;
        this.lastCleanseZ -= this.lastCleanseZ % 2;
    }

    public AspectList getAspects() {
        AspectList aspectList = new AspectList();
        for (DawnMachineResource resource : DawnMachineResource.values()) {
            int value = this.internalAspectList.getAmount(resource.getAspect());
            aspectList.add(resource.getAspect(), value /= resource.getValueMultiplier());
        }
        return aspectList;
    }

    public void setAspects(AspectList aspectList) {
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return DawnMachineResource.getResourceFromAspect(aspect) != null;
    }

    public int addToContainer(Aspect aspect, int i) {
        DawnMachineResource relevantResource = DawnMachineResource.getResourceFromAspect(aspect);
        if (relevantResource == null) {
            return i;
        }
        int currentValue = this.internalAspectList.getAmount(aspect);
        int remainingRoom = relevantResource.getMaximumValue() - currentValue;
        int essentiaRemaining = remainingRoom / relevantResource.getValueMultiplier();
        if (essentiaRemaining > 0) {
            int essentiaToMove = Math.min(i, essentiaRemaining);
            i -= essentiaToMove;
            this.internalAspectList.add(aspect, essentiaToMove * relevantResource.getValueMultiplier());
            this.signalUpdate();
        }
        return i;
    }

    public boolean takeFromContainer(Aspect aspect, int i) {
        return false;
    }

    public boolean takeFromContainer(AspectList aspectList) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int i) {
        if (i == 0) {
            return true;
        }
        DawnMachineResource relevantResource = DawnMachineResource.getResourceFromAspect(aspect);
        if (relevantResource == null) {
            return false;
        }
        int currentValue = this.internalAspectList.getAmount(aspect) / relevantResource.getValueMultiplier();
        return currentValue >= i;
    }

    public boolean doesContainerContain(AspectList aspectList) {
        boolean successful = true;
        for (Aspect aspect : aspectList.getAspects()) {
            successful = this.doesContainerContainAmount(aspect, aspectList.getAmount(aspect)) && successful;
        }
        return successful;
    }

    public int containerContains(Aspect aspect) {
        DawnMachineResource relevantResource = DawnMachineResource.getResourceFromAspect(aspect);
        if (relevantResource == null) {
            return 0;
        }
        return this.internalAspectList.getAmount(aspect) / relevantResource.getValueMultiplier();
    }

    public boolean needsMore(Aspect aspect) {
        DawnMachineResource relevantResource = DawnMachineResource.getResourceFromAspect(aspect);
        if (relevantResource == null) {
            return false;
        }
        return relevantResource.getMaximumValue() - this.internalAspectList.getAmount(aspect) >= relevantResource.getValueMultiplier();
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (from != ForgeDirection.DOWN) {
            return 0;
        }
        int room = 128000 - this.currentRf;
        int actualReceive = Math.min(maxReceive, room);
        if (!simulate) {
            this.currentRf += actualReceive;
        }
        this.signalUpdate();
        return actualReceive;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (from != ForgeDirection.DOWN) {
            return 0;
        }
        return this.currentRf;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (from != ForgeDirection.DOWN) {
            return 0;
        }
        return 128000;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.DOWN;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.receiveEnergy(ForgeDirection.DOWN, maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.currentRf;
    }

    public int getMaxEnergyStored() {
        return 128000;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readCustomNBT(tag);
    }

    private void readCustomNBT(NBTTagCompound tag) {
        this.internalAspectList.readFromNBT(tag.func_74775_l("Essentia"));
        this.currentRf = tag.func_74762_e("CurrentRF");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.writeCustomNBT(tag);
    }

    private void writeCustomNBT(NBTTagCompound tag) {
        NBTTagCompound essentia = new NBTTagCompound();
        this.internalAspectList.writeToNBT(essentia);
        tag.func_74782_a("Essentia", (NBTBase)essentia);
        tag.func_74768_a("CurrentRF", this.currentRf);
    }

    protected void signalUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeCustomNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.readCustomNBT(pkt.func_148857_g());
    }

    public Vec3 getGlowColor(double partialTicks) {
        if (this.currentRf >= 80000) {
            return COLOR_GREEN;
        }
        if (this.currentRf >= 40000) {
            double progress = (double)(this.currentRf - 40000) / 40000.0;
            return this.interpColor(COLOR_GREEN, COLOR_YELLOW, progress);
        }
        if (this.currentRf >= 20000) {
            double progress = (double)(this.currentRf - 20000) / 20000.0;
            return this.interpColor(COLOR_YELLOW, COLOR_RED, progress);
        }
        if (this.currentRf > 150) {
            return COLOR_RED;
        }
        return null;
    }

    protected Vec3 interpColor(Vec3 left, Vec3 right, double progress) {
        double red = (left.field_72450_a - right.field_72450_a) * progress;
        double green = (left.field_72448_b - right.field_72448_b) * progress;
        double blue = (left.field_72449_c - right.field_72449_c) * progress;
        return Vec3.func_72443_a((double)(right.field_72450_a + red), (double)(right.field_72448_b + green), (double)(right.field_72449_c + blue));
    }
}

