/*
 * Decompiled with CFR 0.152.
 */
package talonos.blightbuster.handlers;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import talonos.blightbuster.blocks.BBBlock;
import talonos.blightbuster.handlers.BlockTransportManager;
import talonos.blightbuster.multiblock.BlockMultiblock;
import talonos.blightbuster.multiblock.entries.MultiblockEntry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.IWandTriggerManager;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.research.ResearchManager;

public class TalonosWandTriggerManager
implements IWandTriggerManager {
    private BlockTransportManager blockTransportManager = new BlockTransportManager();

    public boolean performTrigger(World world, ItemStack wand, EntityPlayer player, int x, int y, int z, int side, int event) {
        switch (event) {
            case 0: {
                if (!ResearchManager.isResearchComplete((String)player.func_70005_c_(), (String)"DAWNMACHINE")) break;
                boolean success = this.createDawnMachine(wand, player, world, x, y, z);
                if (success) {
                    TileEntity controller;
                    Block convertedBlock = world.func_147439_a(x, y, z);
                    if (convertedBlock instanceof BlockMultiblock && (controller = ((BlockMultiblock)convertedBlock).getMultiblockController(world, x, y, z)) != null) {
                        this.pairDawnMachineToWand(wand, controller.func_145831_w().field_73011_w.field_76574_g, controller.field_145851_c, controller.field_145848_d, controller.field_145849_e);
                        return true;
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.offering.pairFailed", new Object[0]));
                }
                return success;
            }
            case 1: {
                TileEntity controller;
                Block convertedBlock = world.func_147439_a(x, y, z);
                if (!(convertedBlock instanceof BlockMultiblock) || (controller = ((BlockMultiblock)convertedBlock).getMultiblockController(world, x, y, z)) == null) break;
                if (world.field_72995_K) {
                    return false;
                }
                if (!this.isWandPaired(wand, controller.func_145831_w().field_73011_w.field_76574_g, controller.field_145851_c, controller.field_145848_d, controller.field_145849_e)) {
                    this.pairDawnMachineToWand(wand, controller.func_145831_w().field_73011_w.field_76574_g, controller.field_145851_c, controller.field_145848_d, controller.field_145849_e);
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.offering.pairSucceeded", new Object[0]));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.offering.pairAlreadyExists", new Object[0]));
                }
                return true;
            }
            case 2: {
                int dawnMachineZ;
                int dawnMachineY;
                if (world.field_72995_K) {
                    return false;
                }
                NBTTagCompound wandTag = wand.func_77978_p();
                if (wandTag == null) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.offering.noPairing", new Object[0]));
                    return false;
                }
                if (!wandTag.func_150297_b("DawnMachine", 10)) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.offering.noPairing", new Object[0]));
                    return false;
                }
                NBTTagCompound pairingTag = wandTag.func_74775_l("DawnMachine");
                if (pairingTag.func_74762_e("Dimension") != world.field_73011_w.field_76574_g) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.offering.wrongDimension", new Object[0]));
                    return false;
                }
                int dawnMachineX = pairingTag.func_74762_e("X");
                if (world.func_147439_a(dawnMachineX, dawnMachineY = pairingTag.func_74762_e("Y"), dawnMachineZ = pairingTag.func_74762_e("Z")) != BBBlock.dawnMachine) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.offering.pairingDestroyed", new Object[0]));
                    return false;
                }
                for (int clearY = 0; clearY < 5; ++clearY) {
                    for (int clearX = -2; clearX <= 2; ++clearX) {
                        for (int clearZ = -2; clearZ <= 2; ++clearZ) {
                            Block clearBlock;
                            if (clearY == 0 && clearX == 0 && clearZ == 0 || world.func_147437_c(x + clearX, y + clearY, z + clearZ) || (clearBlock = world.func_147439_a(x + clearX, y + clearY, z + clearZ)).func_149688_o().func_76222_j()) continue;
                            player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.offering.clearArea", new Object[0]));
                            return false;
                        }
                    }
                }
                boolean result = this.blockTransportManager.transport(world, dawnMachineX, dawnMachineY + 1, dawnMachineZ, x, y + 2, z);
                if (!result) break;
                TileEntity controller = world.func_147438_o(x, y + 1, z);
                this.pairDawnMachineToWand(wand, controller.func_145831_w().field_73011_w.field_76574_g, controller.field_145851_c, controller.field_145848_d, controller.field_145849_e);
            }
        }
        return false;
    }

    private boolean isWandPaired(ItemStack wand, int dimension, int x, int y, int z) {
        if (wand.func_77978_p() == null) {
            return false;
        }
        NBTTagCompound wandTag = wand.func_77978_p();
        if (!wandTag.func_150297_b("DawnMachine", 10)) {
            return false;
        }
        NBTTagCompound dawnMachineTag = wandTag.func_74775_l("DawnMachine");
        if (dawnMachineTag.func_74762_e("Dimension") != dimension) {
            return false;
        }
        if (dawnMachineTag.func_74762_e("X") != x) {
            return false;
        }
        if (dawnMachineTag.func_74762_e("Y") != y) {
            return false;
        }
        return dawnMachineTag.func_74762_e("Z") == z;
    }

    private void pairDawnMachineToWand(ItemStack wand, int dimension, int x, int y, int z) {
        NBTTagCompound wandTag = wand.func_77978_p();
        if (wandTag == null) {
            wandTag = new NBTTagCompound();
            wand.func_77982_d(wandTag);
        }
        NBTTagCompound dawnMachineTag = wandTag.func_74775_l("DawnMachine");
        dawnMachineTag.func_74768_a("Dimension", dimension);
        dawnMachineTag.func_74768_a("X", x);
        dawnMachineTag.func_74768_a("Y", y);
        dawnMachineTag.func_74768_a("Z", z);
        wandTag.func_74782_a("DawnMachine", (NBTBase)dawnMachineTag);
    }

    private boolean createDawnMachine(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        int meta;
        if (world.field_72995_K) {
            return false;
        }
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        Block block = world.func_147439_a(x, y, z);
        Pair<MultiblockEntry, Integer> entry = BBBlock.dawnMachineMultiblock.getEntry(world, x, y, z, -1, block, meta = world.func_72805_g(x, y, z));
        if (entry != null && wand.consumeAllVisCrafting(stack, player, new AspectList().add(Aspect.ORDER, 20), true)) {
            if (!world.field_72995_K) {
                BBBlock.dawnMachineMultiblock.convertMultiblockWithOrientationFromSideBlock(world, x, y, z, (Integer)entry.getValue(), false, (MultiblockEntry)entry.getKey());
                return true;
            }
            return false;
        }
        return false;
    }
}

