/*
 * Decompiled with CFR 0.152.
 */
package talonos.blightbuster.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.util.ForgeDirection;
import talonos.blightbuster.blocks.BBBlock;
import talonos.blightbuster.multiblock.BlockMultiblock;
import talonos.blightbuster.tileentity.DawnMachineSpoutTileEntity;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.config.ConfigBlocks;

public class BlockDawnMachineInput
extends BlockMultiblock {
    private IIcon backgroundTop;
    private IIcon backgroundSide;
    private IIcon[] topLeftIcons = new IIcon[6];
    private IIcon[] topRightIcons = new IIcon[6];
    private IIcon[] bottomLeftIcons = new IIcon[6];
    private IIcon[] bottomRightIcons = new IIcon[6];

    public BlockDawnMachineInput() {
        super(Material.field_151575_d, BBBlock.dawnMachineMultiblock);
        this.func_149663_c("blightbuster_dawnMachineInput");
        this.func_149672_a(field_149766_f);
        this.func_149715_a(0.875f);
        this.func_149658_d("dawnMachineBuffer");
        this.func_149711_c(10.0f);
        this.func_149752_b(500.0f);
        GameRegistry.registerBlock((Block)this, (String)this.func_149739_a());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister registry) {
        IIcon blankDummy;
        this.backgroundTop = registry.func_94245_a("thaumcraft:silverwoodtop");
        this.backgroundSide = registry.func_94245_a("thaumcraft:silverwoodside");
        IIcon frontLeftA = registry.func_94245_a("blightbuster:limb-front-left-a");
        IIcon frontLeftB = registry.func_94245_a("blightbuster:limb-front-left-b");
        IIcon frontRightA = registry.func_94245_a("blightbuster:limb-front-right-a");
        IIcon frontRightB = registry.func_94245_a("blightbuster:limb-front-right-b");
        IIcon outsideLeftA = registry.func_94245_a("blightbuster:limb-left-outside-a");
        IIcon outsideLeftB = registry.func_94245_a("blightbuster:limb-left-outside-b");
        IIcon outsideRightA = registry.func_94245_a("blightbuster:limb-right-outside-a");
        IIcon outsideRightB = registry.func_94245_a("blightbuster:limb-right-outside-b");
        this.topLeftIcons[0] = blankDummy = registry.func_94245_a("blightbuster:blankDummy");
        this.topLeftIcons[1] = blankDummy;
        this.topLeftIcons[2] = frontRightA;
        this.topLeftIcons[3] = frontLeftA;
        this.topLeftIcons[4] = outsideLeftA;
        this.topLeftIcons[5] = blankDummy;
        this.topRightIcons[0] = blankDummy;
        this.topRightIcons[1] = blankDummy;
        this.topRightIcons[2] = frontLeftA;
        this.topRightIcons[3] = frontRightA;
        this.topRightIcons[4] = blankDummy;
        this.topRightIcons[5] = outsideRightA;
        this.bottomLeftIcons[0] = blankDummy;
        this.bottomLeftIcons[1] = blankDummy;
        this.bottomLeftIcons[2] = frontRightB;
        this.bottomLeftIcons[3] = frontLeftB;
        this.bottomLeftIcons[4] = outsideLeftB;
        this.bottomLeftIcons[5] = blankDummy;
        this.bottomRightIcons[0] = blankDummy;
        this.bottomRightIcons[1] = blankDummy;
        this.bottomRightIcons[2] = frontLeftB;
        this.bottomRightIcons[3] = frontRightB;
        this.bottomRightIcons[4] = blankDummy;
        this.bottomRightIcons[5] = outsideRightB;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (ForgeHooksClient.getWorldRenderPass() == 1) {
            return this.getInputIcon(this.transformSide(side, meta), meta);
        }
        if (side == 0 || side == 1) {
            return this.backgroundTop;
        }
        return this.backgroundSide;
    }

    public Item func_149650_a(int meta, Random par2Random, int par3) {
        return Item.func_150898_a((Block)ConfigBlocks.blockMagicalLog);
    }

    public int func_149692_a(int p_149692_1_) {
        return 1;
    }

    private IIcon getInputIcon(int side, int meta) {
        int block = meta / 4;
        switch (block) {
            case 1: {
                return this.bottomRightIcons[side];
            }
            case 2: {
                return this.topLeftIcons[side];
            }
            case 3: {
                return this.topRightIcons[side];
            }
        }
        return this.bottomLeftIcons[side];
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new DawnMachineSpoutTileEntity();
    }

    public Aspect getSpoutAspect(int side, int meta) {
        ForgeDirection sideDir = ForgeDirection.VALID_DIRECTIONS[this.transformSide(side, meta)];
        int inputBlockIndex = meta / 4;
        switch (inputBlockIndex) {
            case 0: {
                if (sideDir == ForgeDirection.NORTH) {
                    return Aspect.PLANT;
                }
                if (sideDir == ForgeDirection.SOUTH) {
                    return Aspect.AURA;
                }
                return null;
            }
            case 1: {
                if (sideDir == ForgeDirection.NORTH) {
                    return Aspect.HEAL;
                }
                if (sideDir == ForgeDirection.SOUTH) {
                    return Aspect.MECHANISM;
                }
                return null;
            }
            case 2: {
                if (sideDir == ForgeDirection.SOUTH) {
                    return Aspect.VOID;
                }
                if (sideDir == ForgeDirection.NORTH) {
                    return Aspect.TREE;
                }
                if (sideDir == ForgeDirection.WEST) {
                    return Aspect.ORDER;
                }
                return null;
            }
        }
        if (sideDir == ForgeDirection.NORTH) {
            return Aspect.FIRE;
        }
        if (sideDir == ForgeDirection.SOUTH) {
            return Aspect.MIND;
        }
        if (sideDir == ForgeDirection.EAST) {
            return Aspect.AIR;
        }
        return null;
    }
}

