/*
 * Decompiled with CFR 0.152.
 */
package talonos.biomescanner;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import talonos.biomescanner.BSItems;
import talonos.biomescanner.CommonProxy;
import talonos.biomescanner.block.BSBlock;
import talonos.biomescanner.command.ResetBaselineCommand;
import talonos.biomescanner.gui.GuiHandlerBadgePrinter;
import talonos.biomescanner.map.BiomeMapColors;
import talonos.biomescanner.map.MapScanner;
import talonos.biomescanner.map.Zone;

@Mod(modid="biomescanner", name="Biome Scanner", version="1.2.19", dependencies="before:UndergroundBiomes;after:ThermalFoundation;after:appliedenergistics2;after:Thaumcraft")
public class BiomeScanner {
    public static final String MODID = "biomescanner";
    public static final String MODNAME = "Biome Scanner";
    public static final String VERSION = "1.2.19";
    public static final String DEPS = "before:UndergroundBiomes;after:ThermalFoundation;after:appliedenergistics2;after:Thaumcraft";
    public static final String COMMONPROXYLOCATION = "talonos.biomescanner.CommonProxy";
    public static final String CLIENTPROXYLOCATION = "talonos.biomescanner.ClientProxy";
    public static File baselineFile;
    public static final CreativeTabs badgesTab;
    @SidedProxy(clientSide="talonos.biomescanner.ClientProxy", serverSide="talonos.biomescanner.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="biomescanner")
    public static BiomeScanner instance;
    public static Integer[] zoneBaselines;
    public static boolean disableEverything;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        BSBlock.init();
        BSItems.init();
        proxy.registerTileEntities();
        File configFile = event.getSuggestedConfigurationFile();
        Configuration config = new Configuration(configFile);
        boolean useBaselineFile = config.get("general", "useBaselineFile", false).getBoolean();
        String baselineFileName = config.get("general", "baselineFileName", "baseline.dat").getString();
        disableEverything = config.get("general", "disableEverything", false).getBoolean();
        config.save();
        for (int i = 0; i < zoneBaselines.length; ++i) {
            BiomeScanner.zoneBaselines[i] = null;
        }
        if (useBaselineFile && (baselineFile = new File(configFile.getParent(), baselineFileName)).exists()) {
            try {
                NBTTagCompound loadedData = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(baselineFile));
                BiomeScanner.loadBaselineData(loadedData);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void loadBaselineData(NBTTagCompound loadedData) {
        NBTTagCompound regionMap = loadedData.func_74775_l("RegionMap");
        NBTTagCompound baseline = regionMap.func_74775_l("BaselineBlocks");
        for (int i = 0; i < zoneBaselines.length; ++i) {
            BiomeScanner.zoneBaselines[i] = baseline.func_74764_b(Integer.toString(i)) ? Integer.valueOf(baseline.func_74762_e(Integer.toString(i))) : null;
        }
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)MapScanner.instance);
        MinecraftForge.EVENT_BUS.register((Object)MapScanner.instance);
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        BiomeMapColors.initColors();
        proxy.registerRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandlerBadgePrinter());
    }

    @Mod.EventHandler
    public static void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new ResetBaselineCommand());
    }

    static {
        badgesTab = new CreativeTabs("badges"){
            private static final String __OBFID = "CL_00000011";

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return BSItems.badge;
            }
        };
        zoneBaselines = new Integer[Zone.values().length];
        disableEverything = false;
    }
}

