/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.tileentities;

import appeng.api.implementations.tiles.ICrankable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.blocks.BlockGolemGearBox;
import thaumicenergistics.util.EffectiveSide;

public class TileGearBox
extends TileEntity {
    private static final int BASE_POWER = 6;
    private static final int REQUIRED_POWER = 18;
    private static final int SIDE_COUNT = ForgeDirection.VALID_DIRECTIONS.length;
    private static final int MIN_TICKS_PER_SYNC = 6;
    private static final float FULL_ROTATION = (float)Math.PI;
    private static final String NBT_KEY_CRANKABLES = "crankables";
    private static final String NBT_KEY_ROTATION = "shaftrotation";
    private static final String NBT_KEY_ISTHAUMBOX = "isthaumbox";
    private int[] shafts = new int[SIDE_COUNT];
    private ICrankable[] crankables = new ICrankable[SIDE_COUNT];
    private boolean[] canTurn = new boolean[SIDE_COUNT];
    private int crankableCount = -1;
    private boolean isThaumiumGearbox = false;
    private boolean isReady = false;
    private boolean hasNewCranks = false;
    private int syncTickCount = 0;
    public boolean[] sideIsFacingCrankable = new boolean[SIDE_COUNT];
    public float shaftRotation = 0.0f;

    public TileGearBox() {
    }

    public TileGearBox(boolean isThaumium) {
        this.isThaumiumGearbox = isThaumium;
    }

    private int calculateTransferPower() {
        int powerDivisor = 0;
        for (int sideIndex = 0; sideIndex < SIDE_COUNT; ++sideIndex) {
            ICrankable c = this.crankables[sideIndex];
            if (c == null || !c.canTurn()) continue;
            this.canTurn[sideIndex] = true;
            ++powerDivisor;
        }
        if (powerDivisor == 0) {
            return 0;
        }
        return 6 / powerDivisor;
    }

    private void onReady() {
        this.updateCrankables();
        this.isThaumiumGearbox = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof BlockGolemGearBox;
        this.isReady = true;
    }

    private void readSyncData(NBTTagCompound data) {
        if (data.func_74764_b(NBT_KEY_CRANKABLES)) {
            byte crankableFlags = data.func_74771_c(NBT_KEY_CRANKABLES);
            for (int i = 0; i < SIDE_COUNT; ++i) {
                this.sideIsFacingCrankable[i] = (crankableFlags & (int)Math.pow(2.0, i)) != 0;
            }
        }
        if (data.func_74764_b(NBT_KEY_ROTATION) && this.shaftRotation < 1.0f) {
            this.shaftRotation += (float)Math.PI * 2;
        }
        if (data.func_74764_b(NBT_KEY_ISTHAUMBOX)) {
            this.isThaumiumGearbox = data.func_74767_n(NBT_KEY_ISTHAUMBOX);
        }
    }

    private void updateShafts(int powerTransfered) {
        for (int sideIndex = 0; sideIndex < SIDE_COUNT; ++sideIndex) {
            if (this.canTurn[sideIndex] && this.crankables[sideIndex] != null) {
                int n = sideIndex;
                this.shafts[n] = this.shafts[n] + powerTransfered;
                if (this.shafts[n] < 18) continue;
                this.shafts[sideIndex] = 0;
                this.crankables[sideIndex].applyTurn();
                continue;
            }
            this.shafts[sideIndex] = 0;
        }
    }

    private void writeSyncDataToNBT(NBTTagCompound data) {
        if (!this.isReady) {
            this.onReady();
        }
        byte crankableFlags = 0;
        for (int i = 0; i < SIDE_COUNT; ++i) {
            if (!this.sideIsFacingCrankable[i]) continue;
            crankableFlags = (byte)(crankableFlags | (int)Math.pow(2.0, i));
        }
        data.func_74774_a(NBT_KEY_CRANKABLES, crankableFlags);
        if (this.hasNewCranks) {
            data.func_74757_a(NBT_KEY_ROTATION, true);
            this.hasNewCranks = false;
        }
        data.func_74757_a(NBT_KEY_ISTHAUMBOX, this.isThaumiumGearbox);
    }

    public boolean canUpdate() {
        return true;
    }

    public boolean crankGearbox() {
        if (EffectiveSide.isClientSide()) {
            return true;
        }
        if (this.crankableCount <= 0) {
            return false;
        }
        int powerTransfered = this.calculateTransferPower();
        if (powerTransfered == 0) {
            return false;
        }
        this.updateShafts(powerTransfered);
        this.hasNewCranks = true;
        return true;
    }

    public Packet func_145844_m() {
        NBTTagCompound data = new NBTTagCompound();
        this.writeSyncDataToNBT(data);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, data);
    }

    public boolean isThaumiumGearbox() {
        return this.isThaumiumGearbox;
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readSyncData(packet.func_148857_g());
    }

    public void updateCrankables() {
        this.crankableCount = 0;
        for (int sideIndex = 0; sideIndex < SIDE_COUNT; ++sideIndex) {
            ICrankable crank;
            ForgeDirection side = ForgeDirection.VALID_DIRECTIONS[sideIndex];
            this.crankables[sideIndex] = null;
            this.sideIsFacingCrankable[sideIndex] = false;
            TileEntity tile = this.field_145850_b.func_147438_o(side.offsetX + this.field_145851_c, side.offsetY + this.field_145848_d, side.offsetZ + this.field_145849_e);
            if (!(tile instanceof ICrankable) || !(crank = (ICrankable)tile).canCrankAttach(side.getOpposite())) continue;
            ++this.crankableCount;
            this.crankables[sideIndex] = crank;
            this.sideIsFacingCrankable[sideIndex] = true;
        }
    }

    public void func_145845_h() {
        if (EffectiveSide.isServerSide()) {
            ++this.syncTickCount;
            if (this.syncTickCount >= 6) {
                --this.syncTickCount;
                if (this.hasNewCranks) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.syncTickCount = 0;
                }
            }
        } else if (this.shaftRotation != 0.0f) {
            this.shaftRotation -= 0.2f;
            if (this.shaftRotation < 0.001f) {
                this.shaftRotation = 0.0f;
            }
        }
    }
}

