/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.parts;

import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AEColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.container.AbstractContainerCellTerminalBase;
import thaumicenergistics.container.ContainerEssentiaTerminal;
import thaumicenergistics.gui.GuiEssentiaCellTerminal;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.parts.AbstractAEPartRotateable;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.texture.BlockTextureManager;
import thaumicenergistics.util.PrivateInventory;

public class AEPartEssentiaTerminal
extends AbstractAEPartRotateable {
    private static final double IDLE_POWER_DRAIN = 0.5;
    private static final String SORT_MODE_NBT_KEY = "sortMode";
    private static final String INVENTORY_NBT_KEY = "slots";
    private static final AspectStackComparator.ComparatorMode DEFAULT_SORT_MODE = AspectStackComparator.ComparatorMode.MODE_ALPHABETIC;
    private List<ContainerEssentiaTerminal> listeners = new ArrayList<ContainerEssentiaTerminal>();
    private boolean inventoryLocked = false;
    private AspectStackComparator.ComparatorMode sortMode = DEFAULT_SORT_MODE;
    private PrivateInventory inventory = new PrivateInventory("thaumicenergistics.part.aspect.terminal", 2, 64){

        @Override
        public boolean func_94041_b(int slotId, ItemStack itemStack) {
            EssentiaItemContainerHelper.AspectItemType iType = EssentiaItemContainerHelper.INSTANCE.getItemType(itemStack);
            return iType == EssentiaItemContainerHelper.AspectItemType.EssentiaContainer || iType == EssentiaItemContainerHelper.AspectItemType.JarLabel;
        }
    };

    public AEPartEssentiaTerminal() {
        super(AEPartsEnum.EssentiaTerminal);
    }

    public void addListener(AbstractContainerCellTerminalBase container) {
        if (container instanceof ContainerEssentiaTerminal) {
            this.listeners.add((ContainerEssentiaTerminal)container);
        }
    }

    @Override
    public int cableConnectionRenderTo() {
        return 1;
    }

    @Override
    public boolean doesPlayerHavePermissionToOpenGui(EntityPlayer player) {
        return true;
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
        helper.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        helper.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        helper.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[3];
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return GuiEssentiaCellTerminal.NewEssentiaTerminalGui(this, player);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        if (wrenched) {
            return;
        }
        for (int slotIndex = 0; slotIndex < 2; ++slotIndex) {
            ItemStack slotStack = this.inventory.func_70301_a(slotIndex);
            if (slotStack == null) continue;
            drops.add(slotStack);
        }
    }

    @Override
    public double getIdlePowerUsage() {
        return 0.5;
    }

    public PrivateInventory getInventory() {
        return this.inventory;
    }

    @Override
    public int getLightLevel() {
        return this.isActive() ? 9 : 0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerEssentiaTerminal(this, player);
    }

    public AspectStackComparator.ComparatorMode getSortingMode() {
        return this.sortMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean lockInventoryForWork() {
        boolean gotLock = false;
        PrivateInventory privateInventory = this.inventory;
        synchronized (privateInventory) {
            if (!this.inventoryLocked) {
                this.inventoryLocked = true;
                gotLock = true;
            }
        }
        return gotLock;
    }

    public void notifyListenersSortingModeChanged() {
        for (ContainerEssentiaTerminal listener : this.listeners) {
            listener.onSortingModeChanged(this.sortMode);
        }
    }

    public void onClientRequestSortingModeChange(AspectStackComparator.ComparatorMode sortMode) {
        this.sortMode = sortMode;
        this.notifyListenersSortingModeChanged();
        this.markForSave();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(SORT_MODE_NBT_KEY)) {
            this.sortMode = AspectStackComparator.ComparatorMode.VALUES[data.func_74762_e(SORT_MODE_NBT_KEY)];
        }
        if (data.func_74764_b(INVENTORY_NBT_KEY)) {
            this.inventory.loadFromNBT(data, INVENTORY_NBT_KEY);
        }
    }

    public void removeListener(ContainerEssentiaTerminal containerAspectTerminal) {
        this.listeners.remove(containerAspectTerminal);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[3];
        helper.setTexture(side);
        helper.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        helper.renderInventoryBox(renderer);
        helper.setTexture(side, side, side, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[4], side, side);
        helper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        helper.renderInventoryBox(renderer);
        ts.func_78380_c(0xD000D0);
        helper.setInvColor(0xFFFFFF);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[4], ForgeDirection.SOUTH, renderer);
        helper.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        helper.setInvColor(AEColor.Transparent.blackVariant);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[0], ForgeDirection.SOUTH, renderer);
        helper.setInvColor(AEColor.Transparent.mediumVariant);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[1], ForgeDirection.SOUTH, renderer);
        helper.setInvColor(AEColor.Transparent.whiteVariant);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[2], ForgeDirection.SOUTH, renderer);
        helper.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        this.renderInventoryBusLights(helper, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[3];
        helper.setTexture(side);
        helper.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        helper.renderBlock(x, y, z, renderer);
        helper.setTexture(side, side, side, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[4], side, side);
        helper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        helper.renderBlock(x, y, z, renderer);
        if (this.isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
        }
        this.rotateRenderer(renderer, false);
        ts.func_78378_d(0xFFFFFF);
        helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[4], ForgeDirection.SOUTH, renderer);
        helper.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        ts.func_78378_d(this.getHost().getColor().blackVariant);
        helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[0], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(this.getHost().getColor().mediumVariant);
        helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[1], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(this.getHost().getColor().whiteVariant);
        helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[2], ForgeDirection.SOUTH, renderer);
        this.rotateRenderer(renderer, true);
        helper.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        this.renderStaticBusLights(x, y, z, helper, renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void unlockInventory() {
        PrivateInventory privateInventory = this.inventory;
        synchronized (privateInventory) {
            this.inventoryLocked = false;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        super.writeToNBT(data, saveType);
        if (this.sortMode != DEFAULT_SORT_MODE) {
            data.func_74768_a(SORT_MODE_NBT_KEY, this.sortMode.ordinal());
        }
        if (!this.inventory.isEmpty()) {
            this.inventory.saveToNBT(data, INVENTORY_NBT_KEY);
        }
    }
}

