/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.parts;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.tiles.TileJarFillableVoid;
import thaumicenergistics.grid.IMEEssentiaMonitor;
import thaumicenergistics.integration.tc.EssentiaTileContainerHelper;
import thaumicenergistics.network.packet.client.PacketClientEssentiaIOBus;
import thaumicenergistics.parts.AbstractAEPartBase;
import thaumicenergistics.parts.AbstractAEPartEssentiaIOBus;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.texture.BlockTextureManager;

public class AEPartEssentiaExportBus
extends AbstractAEPartEssentiaIOBus {
    private static final String NBT_KEY_VOID = "IsVoidAllowed";
    private boolean isVoidAllowed = false;

    public AEPartEssentiaExportBus() {
        super(AEPartsEnum.EssentiaExportBus);
    }

    private void sendVoidModeToClient(EntityPlayer player) {
        new PacketClientEssentiaIOBus().createVoidModeUpdate(player, this.isVoidAllowed).sendPacketToPlayer();
    }

    @Override
    public boolean aspectTransferAllowed(Aspect aspect) {
        return true;
    }

    @Override
    public int cableConnectionRenderTo() {
        return 5;
    }

    @Override
    public boolean doesPlayerHavePermissionToOpenGui(EntityPlayer player) {
        return this.doesPlayerHavePermission(player, SecurityPermissions.EXTRACT);
    }

    @Override
    public boolean doWork(int amountToFillContainer) {
        if (this.facingContainer == null) {
            return false;
        }
        for (Aspect filterAspect : this.filteredAspects) {
            if (filterAspect == null || EssentiaTileContainerHelper.INSTANCE.injectEssentiaIntoContainer(this.facingContainer, 1, filterAspect, Actionable.SIMULATE) <= 0L && (!this.isVoidAllowed || EssentiaTileContainerHelper.INSTANCE.getAspectInContainer(this.facingContainer) != filterAspect)) continue;
            IMEEssentiaMonitor essMonitor = this.getGridBlock().getEssentiaMonitor();
            if (essMonitor == null) {
                return false;
            }
            long extractedAmount = essMonitor.extractEssentia(filterAspect, amountToFillContainer, Actionable.SIMULATE, (BaseActionSource)this.asMachineSource, true);
            if (extractedAmount <= 0L) continue;
            long filledAmount = 0L;
            filledAmount = this.isVoidAllowed && this.facingContainer instanceof TileJarFillableVoid ? extractedAmount : EssentiaTileContainerHelper.INSTANCE.injectEssentiaIntoContainer(this.facingContainer, (int)extractedAmount, filterAspect, Actionable.SIMULATE);
            if (filledAmount <= 0L) continue;
            EssentiaTileContainerHelper.INSTANCE.injectEssentiaIntoContainer(this.facingContainer, (int)filledAmount, filterAspect, Actionable.MODULATE);
            essMonitor.extractEssentia(filterAspect, filledAmount, Actionable.MODULATE, (BaseActionSource)this.asMachineSource, true);
            return true;
        }
        return false;
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
        helper.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 13.5);
        helper.addBox(5.0, 5.0, 13.5, 11.0, 11.0, 15.0);
        helper.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[2];
    }

    public void onClientRequestChangeVoidMode(EntityPlayer player) {
        this.isVoidAllowed = !this.isVoidAllowed;
        this.sendVoidModeToClient(player);
    }

    @Override
    public void onClientRequestFullUpdate(EntityPlayer player) {
        super.onClientRequestFullUpdate(player);
        this.sendVoidModeToClient(player);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(NBT_KEY_VOID)) {
            this.isVoidAllowed = data.func_74767_n(NBT_KEY_VOID);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon busSideTexture = BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[3];
        helper.setTexture(busSideTexture);
        helper.setBounds(4.0f, 4.0f, 12.0f, 12.0f, 12.0f, 12.5f);
        helper.renderInventoryBox(renderer);
        helper.setTexture(BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[2]);
        helper.setBounds(4.0f, 4.0f, 12.5f, 12.0f, 12.0f, 13.5f);
        helper.renderInventoryBox(renderer);
        helper.setBounds(5.0f, 5.0f, 13.5f, 11.0f, 11.0f, 14.5f);
        helper.renderInventoryBox(renderer);
        helper.setTexture(busSideTexture);
        helper.setBounds(5.0f, 5.0f, 14.5f, 11.0f, 11.0f, 15.0f);
        helper.renderInventoryBox(renderer);
        helper.setTexture(busSideTexture, busSideTexture, busSideTexture, BlockTextureManager.ESSENTIA_EXPORT_BUS.getTexture(), busSideTexture, busSideTexture);
        helper.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        helper.renderInventoryBox(renderer);
        helper.setInvColor(AbstractAEPartBase.INVENTORY_OVERLAY_COLOR);
        ts.func_78380_c(0xF000F0);
        IIcon faceOverlayTexture = BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[1];
        helper.renderInventoryFace(faceOverlayTexture, ForgeDirection.UP, renderer);
        helper.renderInventoryFace(faceOverlayTexture, ForgeDirection.DOWN, renderer);
        helper.renderInventoryFace(faceOverlayTexture, ForgeDirection.EAST, renderer);
        helper.renderInventoryFace(faceOverlayTexture, ForgeDirection.WEST, renderer);
        helper.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        this.renderInventoryBusLights(helper, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon busSideTexture = BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[3];
        helper.setTexture(busSideTexture);
        helper.setBounds(4.0f, 4.0f, 12.0f, 12.0f, 12.0f, 12.5f);
        helper.renderBlock(x, y, z, renderer);
        helper.renderForPass(1);
        helper.setTexture(BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[2]);
        helper.setBounds(4.0f, 4.0f, 12.5f, 12.0f, 12.0f, 13.5f);
        helper.renderBlock(x, y, z, renderer);
        helper.setBounds(5.0f, 5.0f, 13.5f, 11.0f, 11.0f, 14.5f);
        helper.renderBlock(x, y, z, renderer);
        helper.renderForPass(0);
        helper.setTexture(busSideTexture);
        helper.setBounds(5.0f, 5.0f, 14.5f, 11.0f, 11.0f, 15.0f);
        helper.renderBlock(x, y, z, renderer);
        helper.setTexture(busSideTexture, busSideTexture, busSideTexture, BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[0], busSideTexture, busSideTexture);
        helper.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        helper.renderBlock(x, y, z, renderer);
        ts.func_78378_d(this.getHost().getColor().blackVariant);
        if (this.isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
        }
        IIcon faceOverlayTexture = BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[1];
        helper.renderFace(x, y, z, faceOverlayTexture, ForgeDirection.UP, renderer);
        helper.renderFace(x, y, z, faceOverlayTexture, ForgeDirection.DOWN, renderer);
        helper.renderFace(x, y, z, faceOverlayTexture, ForgeDirection.EAST, renderer);
        helper.renderFace(x, y, z, faceOverlayTexture, ForgeDirection.WEST, renderer);
        helper.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        this.renderStaticBusLights(x, y, z, helper, renderer);
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        super.writeToNBT(data, saveType);
        if (this.isVoidAllowed) {
            data.func_74757_a(NBT_KEY_VOID, this.isVoidAllowed);
        }
    }
}

