/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.server;

import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import thaumicenergistics.items.ItemFocusAEWrench;
import thaumicenergistics.network.packet.AbstractServerPacket;

public class PacketServerWrenchFocus
extends AbstractServerPacket {
    private static final byte MODE_FOCUSWRENCH = 1;
    private float eyeHeight;
    private int x;
    private int y;
    private int z;
    private int side;

    @Override
    protected void readData(ByteBuf stream) {
        if (this.mode == 1) {
            this.eyeHeight = stream.readFloat();
            this.x = stream.readInt();
            this.y = stream.readInt();
            this.z = stream.readInt();
            this.side = stream.readInt();
        }
    }

    @Override
    protected void writeData(ByteBuf stream) {
        stream.writeFloat(this.eyeHeight);
        stream.writeInt(this.x).writeInt(this.y).writeInt(this.z);
        stream.writeInt(this.side);
    }

    public PacketServerWrenchFocus createWrenchFocusRequest(EntityPlayer player, MovingObjectPosition position) {
        this.player = player;
        this.mode = 1;
        this.eyeHeight = Platform.getEyeOffset((EntityPlayer)player);
        this.x = position.field_72311_b;
        this.y = position.field_72312_c;
        this.z = position.field_72309_d;
        this.side = position.field_72310_e;
        return this;
    }

    @Override
    public void execute() {
        if (this.mode == 1) {
            MovingObjectPosition position = new MovingObjectPosition(this.x, this.y, this.z, this.side, Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), true);
            ItemFocusAEWrench.performDismantleOnPartHost(this.player, this.eyeHeight, position);
        }
    }
}

