/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.client;

import appeng.api.AEApi;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.gui.GuiArcaneCraftingTerminal;
import thaumicenergistics.network.packet.AbstractClientPacket;
import thaumicenergistics.network.packet.AbstractPacket;
import thaumicenergistics.registries.EnumCache;

public class PacketClientArcaneCraftingTerminal
extends AbstractClientPacket {
    private static final byte MODE_RECEIVE_CHANGE = 0;
    private static final byte MODE_RECEIVE_FULL_LIST = 1;
    private static final byte MODE_RECEIVE_PLAYER_HOLDING = 2;
    private static final byte MODE_RECEIVE_SORTS = 3;
    private static final byte MODE_UPDATE_COSTS = 4;
    private IAEItemStack changedStack;
    private IItemList<IAEItemStack> fullList;
    private boolean isHeldEmpty;
    private SortOrder sortingOrder;
    private SortDir sortingDirection;
    private ViewItems viewMode;

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void wrappedExecute() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiArcaneCraftingTerminal) {
            switch (this.mode) {
                case 1: {
                    ((GuiArcaneCraftingTerminal)gui).onReceiveFullList(this.fullList);
                    break;
                }
                case 0: {
                    ((GuiArcaneCraftingTerminal)gui).onReceiveChange(this.changedStack);
                    break;
                }
                case 2: {
                    ((GuiArcaneCraftingTerminal)gui).onReceivePlayerHeld(this.changedStack);
                    break;
                }
                case 3: {
                    ((GuiArcaneCraftingTerminal)gui).onReceiveSorting(this.sortingOrder, this.sortingDirection, this.viewMode);
                    break;
                }
                case 4: {
                    ((GuiArcaneCraftingTerminal)gui).onServerSendForceUpdateCost();
                }
            }
        }
    }

    public PacketClientArcaneCraftingTerminal createChangeUpdate(EntityPlayer player, IAEItemStack change) {
        this.player = player;
        this.mode = 0;
        this.changedStack = change;
        return this;
    }

    public PacketClientArcaneCraftingTerminal createFullListUpdate(EntityPlayer player, IItemList<IAEItemStack> fullList) {
        this.player = player;
        this.mode = 1;
        this.useCompression = true;
        this.fullList = fullList;
        return this;
    }

    public PacketClientArcaneCraftingTerminal createPlayerHoldingUpdate(EntityPlayer player, IAEItemStack heldItem) {
        this.player = player;
        this.mode = (byte)2;
        this.changedStack = heldItem;
        this.isHeldEmpty = heldItem == null;
        return this;
    }

    public PacketClientArcaneCraftingTerminal createSortingUpdate(EntityPlayer player, SortOrder order, SortDir direction, ViewItems viewMode) {
        this.player = player;
        this.mode = (byte)3;
        this.sortingDirection = direction;
        this.sortingOrder = order;
        this.viewMode = viewMode;
        return this;
    }

    public PacketClientArcaneCraftingTerminal createUpdateAspectCost(EntityPlayer player) {
        this.player = player;
        this.mode = (byte)4;
        return this;
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 1: {
                this.fullList = AEApi.instance().storage().createItemList();
                int count = stream.readInt();
                for (int i = 0; i < count && stream.readableBytes() > 0; ++i) {
                    IAEItemStack itemStack = AbstractPacket.readAEItemStack(stream);
                    if (itemStack == null) continue;
                    this.fullList.add((IAEStack)itemStack);
                }
                break;
            }
            case 0: {
                int changeAmount = stream.readInt();
                this.changedStack = AbstractPacket.readAEItemStack(stream);
                this.changedStack.setStackSize((long)changeAmount);
                break;
            }
            case 2: {
                this.isHeldEmpty = stream.readBoolean();
                if (!this.isHeldEmpty) {
                    this.changedStack = AbstractPacket.readAEItemStack(stream);
                    break;
                }
                this.changedStack = null;
                break;
            }
            case 3: {
                this.sortingDirection = EnumCache.AE_SORT_DIRECTIONS[stream.readInt()];
                this.sortingOrder = EnumCache.AE_SORT_ORDERS[stream.readInt()];
                this.viewMode = EnumCache.AE_VIEW_ITEMS[stream.readInt()];
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 1: {
                if (this.fullList == null) {
                    stream.writeInt(0);
                    return;
                }
                stream.writeInt(this.fullList.size());
                Iterator listIterator = this.fullList.iterator();
                while (listIterator.hasNext()) {
                    AbstractPacket.writeAEItemStack((IAEItemStack)listIterator.next(), stream);
                }
                break;
            }
            case 0: {
                stream.writeInt((int)this.changedStack.getStackSize());
                AbstractPacket.writeAEItemStack(this.changedStack, stream);
                break;
            }
            case 2: {
                stream.writeBoolean(this.isHeldEmpty);
                if (this.isHeldEmpty) break;
                AbstractPacket.writeAEItemStack(this.changedStack, stream);
                break;
            }
            case 3: {
                stream.writeInt(this.sortingDirection.ordinal());
                stream.writeInt(this.sortingOrder.ordinal());
                stream.writeInt(this.viewMode.ordinal());
            }
        }
    }
}

