/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet;

import appeng.api.parts.IPartHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import com.google.common.base.Charsets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.parts.AbstractAEPartBase;

public abstract class AbstractPacket
implements IMessage {
    private static final int COMPRESSED_BUFFER_SIZE = 0x100000;
    public EntityPlayer player = null;
    protected byte mode = (byte)-1;
    protected boolean useCompression = false;

    @SideOnly(value=Side.CLIENT)
    private static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    protected static IAEItemStack readAEItemStack(ByteBuf stream) {
        try {
            IAEItemStack itemStack = AEItemStack.loadItemStackFromPacket((ByteBuf)stream);
            return itemStack;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static ItemStack readItemstack(ByteBuf stream) {
        return ByteBufUtils.readItemStack((ByteBuf)stream);
    }

    protected static AbstractAEPartBase readPart(ByteBuf stream) {
        ForgeDirection side = ForgeDirection.getOrientation((int)stream.readInt());
        IPartHost host = (IPartHost)AbstractPacket.readTileEntity(stream);
        return (AbstractAEPartBase)host.getPart(side);
    }

    protected static EntityPlayer readPlayer(ByteBuf stream) {
        EntityPlayer player = null;
        if (stream.readBoolean()) {
            World playerWorld = AbstractPacket.readWorld(stream);
            player = playerWorld.func_72924_a(AbstractPacket.readString(stream));
        }
        return player;
    }

    protected static String readString(ByteBuf stream) {
        byte[] stringBytes = new byte[stream.readInt()];
        stream.readBytes(stringBytes);
        return new String(stringBytes, Charsets.UTF_8);
    }

    protected static TileEntity readTileEntity(ByteBuf stream) {
        World world = AbstractPacket.readWorld(stream);
        return world.func_147438_o(stream.readInt(), stream.readInt(), stream.readInt());
    }

    protected static World readWorld(ByteBuf stream) {
        WorldServer world = DimensionManager.getWorld((int)stream.readInt());
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && world == null) {
            world = AbstractPacket.getClientWorld();
        }
        return world;
    }

    protected static void writeAEItemStack(IAEItemStack itemStack, ByteBuf stream) {
        if (itemStack != null) {
            try {
                itemStack.writeToPacket(stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static void writeItemstack(ItemStack stack, ByteBuf stream) {
        ByteBufUtils.writeItemStack((ByteBuf)stream, (ItemStack)stack);
    }

    protected static void writePart(AbstractAEPartBase part, ByteBuf stream) {
        stream.writeInt(part.getSide().ordinal());
        AbstractPacket.writeTileEntity(part.getHost().getTile(), stream);
    }

    protected static void writePlayer(EntityPlayer player, ByteBuf stream) {
        boolean validPlayer = player != null;
        stream.writeBoolean(validPlayer);
        if (validPlayer) {
            AbstractPacket.writeWorld(player.field_70170_p, stream);
            AbstractPacket.writeString(player.func_70005_c_(), stream);
        }
    }

    protected static void writeString(String string, ByteBuf stream) {
        byte[] stringBytes = string.getBytes(Charsets.UTF_8);
        stream.writeInt(stringBytes.length);
        stream.writeBytes(stringBytes);
    }

    protected static void writeTileEntity(TileEntity entity, ByteBuf stream) {
        AbstractPacket.writeWorld(entity.func_145831_w(), stream);
        stream.writeInt(entity.field_145851_c);
        stream.writeInt(entity.field_145848_d);
        stream.writeInt(entity.field_145849_e);
    }

    protected static void writeWorld(World world, ByteBuf stream) {
        stream.writeInt(world.field_73011_w.field_76574_g);
    }

    public static Aspect readAspect(ByteBuf stream) {
        return (Aspect)Aspect.aspects.get(AbstractPacket.readString(stream));
    }

    public static void writeAspect(Aspect aspect, ByteBuf stream) {
        String aspectName = "";
        if (aspect != null) {
            aspectName = aspect.getTag();
        }
        AbstractPacket.writeString(aspectName, stream);
    }

    private void fromCompressedBytes(final ByteBuf packetStream) {
        block5: {
            ByteBuf decompressedStream = Unpooled.buffer((int)0x100000);
            GZIPInputStream decompressor = null;
            try {
                decompressor = new GZIPInputStream(new InputStream(){

                    @Override
                    public int read() throws IOException {
                        if (packetStream.readableBytes() <= 0) {
                            return -1;
                        }
                        return packetStream.readByte() & 0xFF;
                    }
                });
                byte[] holding = new byte[512];
                while (decompressor.available() != 0) {
                    int bytesRead = decompressor.read(holding);
                    if (bytesRead <= 0) continue;
                    decompressedStream.writeBytes(holding, 0, bytesRead);
                }
                decompressor.close();
                decompressedStream.readerIndex(0);
                this.readData(decompressedStream);
            }
            catch (IOException e) {
                if (decompressor == null) break block5;
                try {
                    decompressor.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void toCompressedBytes(final ByteBuf packetStream) {
        block4: {
            ByteBuf streamToCompress = Unpooled.buffer((int)0x100000);
            this.writeData(streamToCompress);
            DeflaterOutputStream compressor = null;
            try {
                compressor = new GZIPOutputStream(new OutputStream(){

                    @Override
                    public void write(int byteToWrite) throws IOException {
                        packetStream.writeByte(byteToWrite & 0xFF);
                    }
                }){
                    {
                        this.def.setLevel(9);
                    }
                };
                ((GZIPOutputStream)compressor).write(streamToCompress.array(), 0, streamToCompress.writerIndex());
                compressor.close();
            }
            catch (IOException e) {
                if (compressor == null) break block4;
                try {
                    compressor.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected abstract void readData(ByteBuf var1);

    protected abstract void writeData(ByteBuf var1);

    public abstract void execute();

    public void fromBytes(ByteBuf stream) {
        this.mode = stream.readByte();
        this.player = AbstractPacket.readPlayer(stream);
        this.useCompression = stream.readBoolean();
        if (this.useCompression) {
            this.fromCompressedBytes(stream);
        } else {
            this.readData(stream);
        }
    }

    public void toBytes(ByteBuf stream) {
        stream.writeByte((int)this.mode);
        AbstractPacket.writePlayer(this.player, stream);
        stream.writeBoolean(this.useCompression);
        if (this.useCompression) {
            this.toCompressedBytes(stream);
        } else {
            this.writeData(stream);
        }
    }
}

