/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEItemStack;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.IRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.container.ContainerPartArcaneCraftingTerminal;
import thaumicenergistics.gui.GuiArcaneCraftingTerminal;
import thaumicenergistics.network.packet.server.PacketServerArcaneCraftingTerminal;

public class ModuleNEI {
    static final int NEI_REGULAR_SLOT_OFFSET_X = 25;
    static final int NEI_REGULAR_SLOT_OFFSET_Y = 6;

    public ModuleNEI() throws Exception {
        API.registerGuiOverlay(GuiArcaneCraftingTerminal.class, (String)"crafting", (IStackPositioner)new ACTSlotPositioner());
        ACTOverlayHandler craftingOverlayHandler = new ACTOverlayHandler(false);
        ACTOverlayHandler arcaneOverlayHandler = new ACTOverlayHandler(true);
        API.registerGuiOverlayHandler(GuiArcaneCraftingTerminal.class, (IOverlayHandler)craftingOverlayHandler, (String)"crafting");
        API.registerGuiOverlayHandler(GuiArcaneCraftingTerminal.class, (IOverlayHandler)arcaneOverlayHandler, (String)"arcaneshapedrecipes");
        API.registerGuiOverlayHandler(GuiArcaneCraftingTerminal.class, (IOverlayHandler)arcaneOverlayHandler, (String)"arcaneshapelessrecipes");
    }

    abstract class AbstractBaseOverlayHandler
    implements IOverlayHandler {
        AbstractBaseOverlayHandler() {
        }

        protected abstract boolean addIngredientToItems(PositionedStack var1, IAEItemStack[] var2);

        protected abstract void addItemsToGUI(IAEItemStack[] var1);

        protected abstract boolean isCorrectGUI(GuiContainer var1);

        public final void overlayRecipe(GuiContainer gui, IRecipeHandler recipeHandler, int recipeIndex, boolean shift) {
            try {
                if (this.isCorrectGUI(gui)) {
                    IAEItemStack[] overlayItems = new IAEItemStack[9];
                    boolean hasItems = false;
                    List ingredients = recipeHandler.getIngredientStacks(recipeIndex);
                    for (PositionedStack ingredient : ingredients) {
                        if (ingredient == null || ingredient.item == null || ingredient.item.func_77973_b() == null) continue;
                        hasItems |= this.addIngredientToItems(ingredient, overlayItems);
                    }
                    if (hasItems) {
                        this.addItemsToGUI(overlayItems);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class ACTSlotPositioner
    implements IStackPositioner {
        public ArrayList<PositionedStack> positionStacks(ArrayList<PositionedStack> stacks) {
            for (PositionedStack ps : stacks) {
                if (ps == null) continue;
                ps.relx += ContainerPartArcaneCraftingTerminal.CRAFTING_SLOT_X_POS - 25;
                ps.rely += ContainerPartArcaneCraftingTerminal.CRAFTING_SLOT_Y_POS - 6;
            }
            return stacks;
        }
    }

    public class ACTOverlayHandler
    extends AbstractBaseOverlayHandler {
        private static final int REGULAR_SLOT_INDEX_DIVISOR = 18;
        private static final int ARCANE_SLOTY_INDEX_DIVISOR = 20;
        private final boolean isArcaneHandler;

        public ACTOverlayHandler(boolean isArcane) {
            this.isArcaneHandler = isArcane;
        }

        private boolean addArcaneCraftingItems(PositionedStack ingredient, IAEItemStack[] overlayItems) {
            int slotIndex;
            int slotX = (int)Math.round((double)ingredient.relx / 18.0) - 3;
            int slotY = (int)Math.round((double)ingredient.rely / 20.0) - 2;
            if (slotY >= 3) {
                return false;
            }
            if (slotX == 3) {
                slotX = 2;
            }
            if ((slotIndex = slotX + slotY * 3) < 0 || slotIndex > 9) {
                return false;
            }
            overlayItems[slotIndex] = AEApi.instance().storage().createItemStack(ingredient.item);
            return true;
        }

        private boolean addRegularCraftingItems(PositionedStack ingredient, IAEItemStack[] overlayItems) {
            int slotX = (ingredient.relx - 25) / 18;
            int slotY = (ingredient.rely - 6) / 18;
            int slotIndex = slotX + slotY * 3;
            overlayItems[slotIndex] = AEApi.instance().storage().createItemStack(ingredient.item);
            return true;
        }

        @Override
        protected boolean addIngredientToItems(PositionedStack ingredient, IAEItemStack[] overlayItems) {
            if (this.isArcaneHandler) {
                return this.addArcaneCraftingItems(ingredient, overlayItems);
            }
            return this.addRegularCraftingItems(ingredient, overlayItems);
        }

        @Override
        protected void addItemsToGUI(IAEItemStack[] overlayItems) {
            new PacketServerArcaneCraftingTerminal().createNEIRequestSetCraftingGrid((EntityPlayer)Minecraft.func_71410_x().field_71439_g, overlayItems).sendPacketToServer();
        }

        @Override
        protected boolean isCorrectGUI(GuiContainer gui) {
            return gui instanceof GuiArcaneCraftingTerminal;
        }
    }
}

