/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.implementaion;

import appeng.api.AEApi;
import appeng.api.features.ILocatable;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.localization.PlayerMessages;
import appeng.tile.misc.TileSecurity;
import appeng.tile.networking.TileWireless;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.api.IThEInteractionHelper;
import thaumicenergistics.api.IThEWirelessEssentiaTerminal;
import thaumicenergistics.gui.GuiArcaneCraftingTerminal;
import thaumicenergistics.gui.ThEGuiHandler;
import thaumicenergistics.integration.tc.EssentiaConversionHelper;
import thaumicenergistics.inventory.HandlerWirelessEssentiaTerminal;
import thaumicenergistics.network.packet.server.PacketServerArcaneCraftingTerminal;

public class ThEInteractionHelper
implements IThEInteractionHelper {
    @Override
    public long convertEssentiaAmountToFluidAmount(long essentiaAmount) {
        return EssentiaConversionHelper.INSTANCE.convertEssentiaAmountToFluidAmount(essentiaAmount);
    }

    @Override
    public long convertFluidAmountToEssentiaAmount(long milibuckets) {
        return EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(milibuckets);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Class getArcaneCraftingTerminalGUIClass() {
        return GuiArcaneCraftingTerminal.class;
    }

    @Override
    public void openWirelessTerminalGui(EntityPlayer player, IThEWirelessEssentiaTerminal terminalInterface) {
        IGrid hostGrid;
        long encryptionKey;
        if (player == null || player instanceof FakePlayer) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack wirelessTerminal = player.func_70694_bm();
        if (wirelessTerminal == null) {
            return;
        }
        if (terminalInterface.getAECurrentPower(wirelessTerminal) == 0.0) {
            player.func_145747_a(PlayerMessages.DeviceNotPowered.get());
            return;
        }
        if (!HandlerWirelessEssentiaTerminal.isTerminalLinked(terminalInterface, wirelessTerminal)) {
            player.func_145747_a(PlayerMessages.CommunicationError.get());
            return;
        }
        try {
            encryptionKey = Long.parseLong(terminalInterface.getEncryptionKey(wirelessTerminal));
        }
        catch (NumberFormatException e) {
            player.func_145747_a(PlayerMessages.CommunicationError.get());
            return;
        }
        ILocatable source = AEApi.instance().registries().locatable().getLocatableBy(encryptionKey);
        if (!(source instanceof TileSecurity)) {
            player.func_145747_a(PlayerMessages.CommunicationError.get());
            return;
        }
        TileSecurity securityHost = (TileSecurity)source;
        try {
            hostGrid = securityHost.getGridNode(ForgeDirection.UNKNOWN).getGrid();
        }
        catch (Exception e) {
            player.func_145747_a(PlayerMessages.CommunicationError.get());
            return;
        }
        IMachineSet accessPoints = hostGrid.getMachines(TileWireless.class);
        for (IGridNode APNode : accessPoints) {
            IWirelessAccessPoint AP = (IWirelessAccessPoint)APNode.getMachine();
            if (!AP.isActive() || !HandlerWirelessEssentiaTerminal.isAPInRangeOfPlayer(AP.getLocation(), AP.getRange(), player)) continue;
            ThEGuiHandler.launchGui(40, player, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, new Object[]{new HandlerWirelessEssentiaTerminal(player, AP, terminalInterface, wirelessTerminal)});
            return;
        }
        if (accessPoints.isEmpty()) {
            player.func_145747_a(PlayerMessages.CommunicationError.get());
        } else {
            player.func_145747_a(PlayerMessages.OutOfRange.get());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setArcaneCraftingTerminalRecipe(ItemStack[] itemsVanilla) {
        try {
            boolean hasItems = false;
            if (itemsVanilla == null || itemsVanilla.length != 9) {
                return;
            }
            IAEItemStack[] items = new IAEItemStack[9];
            for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
                if (itemsVanilla[slotIndex] == null) continue;
                items[slotIndex] = AEApi.instance().storage().createItemStack(itemsVanilla[slotIndex]);
                hasItems = true;
            }
            if (hasItems) {
                new PacketServerArcaneCraftingTerminal().createNEIRequestSetCraftingGrid((EntityPlayer)Minecraft.func_71410_x().field_71439_g, items).sendPacketToServer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

