/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.implementaion;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.LoaderState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.ThaumicEnergistics;
import thaumicenergistics.api.IThEBlocks;
import thaumicenergistics.api.IThEConfig;
import thaumicenergistics.api.IThEEssentiaGas;
import thaumicenergistics.api.IThEInteractionHelper;
import thaumicenergistics.api.IThEItems;
import thaumicenergistics.api.IThEParts;
import thaumicenergistics.api.IThETransportPermissions;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.fluids.GaseousEssentia;
import thaumicenergistics.implementaion.ThEBlocks;
import thaumicenergistics.implementaion.ThEInteractionHelper;
import thaumicenergistics.implementaion.ThEItems;
import thaumicenergistics.implementaion.ThEParts;
import thaumicenergistics.implementaion.ThETransportPermissions;
import thaumicenergistics.util.ThELog;

public class ThEAPIImplementation
extends ThEApi {
    private final ThEBlocks blocks = new ThEBlocks();
    private final ThEItems items = new ThEItems();
    private final ThEParts parts = new ThEParts();
    private final List<IThEEssentiaGas> essentiaGases = new ArrayList<IThEEssentiaGas>();
    private final ThETransportPermissions transportPermissions = new ThETransportPermissions();
    private final ThEInteractionHelper interactionHelper = new ThEInteractionHelper();
    private static ThEAPIImplementation INSTANCE = null;

    private ThEAPIImplementation() {
    }

    protected static boolean hasFinishedPreInit() {
        if (ThaumicEnergistics.getLoaderState() == LoaderState.NOINIT) {
            ThELog.warning("API is not available until ThE finishes the PreInit phase.", new Object[0]);
            return false;
        }
        return true;
    }

    public static ThEAPIImplementation instance() {
        if (INSTANCE == null) {
            if (!ThEAPIImplementation.hasFinishedPreInit()) {
                return null;
            }
            INSTANCE = new ThEAPIImplementation();
        }
        return INSTANCE;
    }

    @Override
    public IThEBlocks blocks() {
        return this.blocks;
    }

    @Override
    public IThEConfig config() {
        return ThaumicEnergistics.config;
    }

    @Override
    public ImmutableList<List<IThEEssentiaGas>> essentiaGases() {
        if (this.essentiaGases.size() != GaseousEssentia.gasList.size()) {
            this.essentiaGases.clear();
            Iterator<Map.Entry<Aspect, GaseousEssentia>> iterator = GaseousEssentia.gasList.entrySet().iterator();
            while (iterator.hasNext()) {
                this.essentiaGases.add(iterator.next().getValue());
            }
        }
        return ImmutableList.of(this.essentiaGases);
    }

    @Override
    public IThEInteractionHelper interact() {
        return this.interactionHelper;
    }

    @Override
    public IThEItems items() {
        return this.items;
    }

    @Override
    public IThEParts parts() {
        return this.parts;
    }

    @Override
    public IThETransportPermissions transportPermissions() {
        return this.transportPermissions;
    }
}

