/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.container.AbstractContainerCellTerminalBase;
import thaumicenergistics.container.ContainerEssentiaCell;
import thaumicenergistics.container.ContainerEssentiaTerminal;
import thaumicenergistics.container.ContainerWirelessEssentiaTerminal;
import thaumicenergistics.container.IAspectSelectorContainer;
import thaumicenergistics.gui.abstraction.AbstractGuiWithScrollbar;
import thaumicenergistics.gui.buttons.GuiButtonSortingMode;
import thaumicenergistics.gui.widget.AbstractWidget;
import thaumicenergistics.gui.widget.IAspectSelectorGui;
import thaumicenergistics.gui.widget.WidgetAspectSelector;
import thaumicenergistics.gui.widget.WidgetAspectSelectorComparator;
import thaumicenergistics.network.packet.server.PacketServerEssentiaCellTerminal;
import thaumicenergistics.parts.AEPartEssentiaTerminal;
import thaumicenergistics.registries.ThEStrings;
import thaumicenergistics.texture.GuiTextureManager;
import thaumicenergistics.util.GuiHelper;

@SideOnly(value=Side.CLIENT)
public class GuiEssentiaCellTerminal
extends AbstractGuiWithScrollbar
implements IAspectSelectorGui {
    protected static final int WIDGETS_PER_ROW = 9;
    protected static final int ROWS_PER_PAGE = 4;
    protected static final int WIDGETS_PER_PAGE = 36;
    private static final int GUI_SIZE_X = 195;
    private static final int GUI_SIZE_Y = 204;
    private static final int GUI_OFFSET_Y = 18;
    private static final int TITLE_POS_X = 7;
    private static final int TITLE_POS_Y = -12;
    private static final int SELECTED_INFO_POS_X = 45;
    private static final int SELECTED_INFO_NAME_POS_Y = 73;
    private static final int SELECTED_INFO_AMOUNT_POS_Y = 83;
    private static final int WIDGET_OFFSET_X = 7;
    private static final int WIDGET_OFFSET_Y = -1;
    private static final int SEARCH_X_OFFSET = 98;
    private static final int SEARCH_Y_OFFSET = -12;
    private static final int SEARCH_WIDTH = 69;
    private static final int SEARCH_HEIGHT = 10;
    private static final int SEARCH_MAX_CHARS = 14;
    private static final int SORT_MODE_BUTTON_POS_X = -18;
    private static final int SORT_MODE_BUTTON_POS_Y = -15;
    private static final int SORT_MODE_BUTTON_SIZE = 16;
    private static final int SORT_MODE_BUTTON_ID = 0;
    private static final int SCROLLBAR_POS_X = 175;
    private static final int SCROLLBAR_POS_Y = 0;
    private static final int SCROLLBAR_HEIGHT = 70;
    private final String guiTitle;
    private final String selectedInfoNamePrefix;
    private final String selectedInfoAmountPrefix;
    protected EntityPlayer player;
    protected int currentScroll = 0;
    protected GuiTextField searchBar;
    protected List<WidgetAspectSelector> aspectWidgets = new ArrayList<WidgetAspectSelector>();
    protected List<WidgetAspectSelector> matchingSearchWidgets = new ArrayList<WidgetAspectSelector>();
    protected String searchTerm = "";
    protected AbstractContainerCellTerminalBase baseContainer;
    protected AspectStackComparator.ComparatorMode sortMode = AspectStackComparator.ComparatorMode.MODE_ALPHABETIC;
    private long cacheAmountSelected = -1L;
    private String cacheAmountDisplay = "0";
    public AspectStack selectedAspectStack;

    private GuiEssentiaCellTerminal(EntityPlayer player, AbstractContainerCellTerminalBase container, String title) {
        super(container);
        this.baseContainer = container;
        this.player = player;
        this.field_146999_f = 195;
        this.field_147000_g = 204;
        this.guiTitle = title;
        this.selectedInfoNamePrefix = ThEStrings.Gui_SelectedAspect.getLocalized() + ": ";
        this.selectedInfoAmountPrefix = ThEStrings.Gui_SelectedAmount.getLocalized() + ": ";
    }

    public static GuiEssentiaCellTerminal NewEssentiaCellGui(EntityPlayer player, World world, int x, int y, int z) {
        return new GuiEssentiaCellTerminal(player, new ContainerEssentiaCell(player, world, x, y, z), ThEStrings.Gui_TitleEssentiaCell.getLocalized());
    }

    public static GuiEssentiaCellTerminal NewEssentiaTerminalGui(AEPartEssentiaTerminal terminal, EntityPlayer player) {
        return new GuiEssentiaCellTerminal(player, new ContainerEssentiaTerminal(terminal, player), ThEStrings.Part_EssentiaTerminal.getLocalized());
    }

    public static GuiEssentiaCellTerminal NewWirelessEssentiaTerminalGui(EntityPlayer player) {
        return new GuiEssentiaCellTerminal(player, new ContainerWirelessEssentiaTerminal(player, null), ThEStrings.Part_EssentiaTerminal.getLocalized());
    }

    private void sortMatchingList() {
        Collections.sort(this.matchingSearchWidgets, new WidgetAspectSelectorComparator(this.sortMode));
    }

    private void updateScrollMaximum() {
        double overflowWidgets = Math.max(0, this.matchingSearchWidgets.size() - 36);
        int overflowRows = (int)Math.ceil(overflowWidgets / 9.0);
        if (overflowRows != this.scrollBar.getRange()) {
            this.scrollBar.setRange(0, overflowRows, 1);
            this.onScrollbarMoved();
        }
    }

    private void updateSearch() {
        this.matchingSearchWidgets.clear();
        for (WidgetAspectSelector currentWidget : this.aspectWidgets) {
            if (this.searchTerm != "" && !currentWidget.getAspect().getTag().contains(this.searchTerm)) continue;
            this.matchingSearchWidgets.add(currentWidget);
        }
        this.sortMatchingList();
        this.updateScrollMaximum();
    }

    protected void func_146976_a(float alpha, int sizeX, int sizeY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiTextureManager.ESSENTIA_TERMINAL.getTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r - 18, 0, 0, this.field_146999_f, this.field_147000_g);
        this.searchBar.func_146194_f();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.guiTitle, 7, -12, 0);
        this.drawWidgets(mouseX, mouseY);
        if (this.selectedAspectStack != null && this.selectedAspectStack.stackSize > 0L) {
            if (this.selectedAspectStack.stackSize != this.cacheAmountSelected) {
                this.cacheAmountDisplay = GuiHelper.shortenCount(this.selectedAspectStack.stackSize);
                this.cacheAmountSelected = this.selectedAspectStack.stackSize;
            }
            String aspectName = this.selectedAspectStack.getAspectName(this.player);
            this.field_146289_q.func_78276_b(this.selectedInfoNamePrefix + aspectName, 45, 73, 0);
            this.field_146289_q.func_78276_b(this.selectedInfoAmountPrefix + this.cacheAmountDisplay, 45, 83, 0);
        }
        if (this.tooltip.isEmpty()) {
            this.addTooltipFromButtons(mouseX, mouseY);
        }
        this.drawTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r, true);
    }

    @Override
    protected AbstractGuiWithScrollbar.ScrollbarParams getScrollbarParameters() {
        return new AbstractGuiWithScrollbar.ScrollbarParams(this, 175, 0, 70);
    }

    @Override
    protected void func_73869_a(char key, int keyID) {
        this.searchBar.func_146201_a(key, keyID);
        if (keyID == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (this.searchBar.func_146206_l()) {
            this.searchTerm = this.searchBar.func_146179_b().trim().toLowerCase();
            this.updateSearch();
        } else if (!Character.isDigit(key)) {
            super.func_73869_a(key, keyID);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseBtn) {
        int listSize = this.matchingSearchWidgets.size();
        int index = 0;
        block0: for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                index = (y + this.currentScroll) * 9 + x;
                if (index < listSize) {
                    WidgetAspectSelector currentWidget = this.matchingSearchWidgets.get(index);
                    if (!currentWidget.isMouseOverWidget(mouseX, mouseY)) continue;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    currentWidget.mouseClicked();
                    return;
                }
                y = 4;
                continue block0;
            }
        }
        if (mouseBtn == 1 && GuiHelper.INSTANCE.isPointInGuiRegion(-12, 98, 10, 69, mouseX, mouseY, this.field_147003_i, this.field_147009_r)) {
            this.searchTerm = "";
            this.searchBar.func_146180_a(this.searchTerm);
            this.updateSearch();
            return;
        }
        this.searchBar.func_146192_a(mouseX, mouseY, mouseBtn);
        super.func_73864_a(mouseX, mouseY, mouseBtn);
    }

    @Override
    protected void onButtonClicked(GuiButton button, int mouseButton) {
        if (button.field_146127_k == 0) {
            new PacketServerEssentiaCellTerminal().createRequestChangeSortMode(this.player, this.sortMode == AspectStackComparator.ComparatorMode.MODE_ALPHABETIC ? AspectStackComparator.ComparatorMode.MODE_AMOUNT : AspectStackComparator.ComparatorMode.MODE_ALPHABETIC).sendPacketToServer();
        }
    }

    @Override
    protected void onScrollbarMoved() {
        this.currentScroll = this.scrollBar.getCurrentScroll();
    }

    public void drawWidgets(int mouseX, int mouseY) {
        if (!this.matchingSearchWidgets.isEmpty()) {
            int startingIndex = this.currentScroll * 9;
            int endingIndex = Math.min(this.matchingSearchWidgets.size(), startingIndex + 36);
            int widgetPosX = 7;
            int widgetPosY = -1;
            int widgetColumnPosition = 1;
            WidgetAspectSelector widgetUnderMouse = null;
            for (int index = startingIndex; index < endingIndex; ++index) {
                WidgetAspectSelector currentWidget = this.matchingSearchWidgets.get(index);
                currentWidget.setPosition(widgetPosX, widgetPosY);
                currentWidget.drawWidget();
                if (currentWidget.isMouseOverWidget(mouseX, mouseY)) {
                    widgetUnderMouse = this.matchingSearchWidgets.get(index);
                }
                if (++widgetColumnPosition > 9) {
                    widgetPosX = 7;
                    widgetColumnPosition = 1;
                    widgetPosY += AbstractWidget.WIDGET_SIZE;
                    continue;
                }
                widgetPosX += AbstractWidget.WIDGET_SIZE;
            }
            if (widgetUnderMouse != null) {
                widgetUnderMouse.getTooltip(this.tooltip);
            }
        } else {
            this.currentScroll = 0;
        }
    }

    @Override
    public IAspectSelectorContainer getContainer() {
        return this.baseContainer;
    }

    @Override
    public AspectStack getSelectedAspect() {
        return this.selectedAspectStack;
    }

    public void func_146274_d() {
        super.func_146274_d();
        int deltaZ = Mouse.getEventDWheel();
        if (deltaZ != 0) {
            this.scrollBar.wheel(deltaZ);
            this.onScrollbarMoved();
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Mouse.getDWheel();
        this.updateAspects();
        this.searchBar = new GuiTextField(this.field_146289_q, this.field_147003_i + 98, this.field_147009_r + -12, 69, 10);
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146195_b(false);
        this.searchBar.func_146203_f(14);
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButtonSortingMode(0, this.field_147003_i + -18, this.field_147009_r + -15, 16, 16));
    }

    public void onReceiveAspectList(List<AspectStack> aspectStackList) {
        this.baseContainer.onReceivedAspectList(aspectStackList);
        this.updateAspects();
    }

    public void onReceiveAspectListChange(AspectStack change) {
        if (this.baseContainer.onReceivedAspectListChange(change)) {
            this.updateAspects();
        }
    }

    public void onReceiveSelectedAspect(Aspect selectedAspect) {
        this.baseContainer.onReceivedSelectedAspect(selectedAspect);
        this.updateSelectedAspect();
    }

    public void onSortModeChanged(AspectStackComparator.ComparatorMode sortMode) {
        this.sortMode = sortMode;
        ((GuiButtonSortingMode)((Object)this.field_146292_n.get(0))).setSortMode(sortMode);
        this.sortMatchingList();
    }

    public void updateAspects() {
        this.aspectWidgets = new ArrayList<WidgetAspectSelector>();
        for (AspectStack aspectStack : this.baseContainer.getAspectStackList()) {
            this.aspectWidgets.add(new WidgetAspectSelector(this, aspectStack, 0, 0, this.player));
        }
        this.updateScrollMaximum();
        this.updateSearch();
        this.updateSelectedAspect();
    }

    public void updateSelectedAspect() {
        this.selectedAspectStack = null;
        for (AspectStack aspectStack : this.baseContainer.getAspectStackList()) {
            if (aspectStack.aspect != this.baseContainer.getSelectedAspect()) continue;
            this.selectedAspectStack = aspectStack;
            return;
        }
    }
}

