/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.features;

import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.common.config.Config;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.features.AbstractDependencyFeature;
import thaumicenergistics.features.CommonDependantItems;
import thaumicenergistics.registries.BlockEnum;
import thaumicenergistics.registries.FeatureRegistry;
import thaumicenergistics.registries.RecipeRegistry;
import thaumicenergistics.registries.ResearchRegistry;

public class FeatureInfusionProvider
extends AbstractDependencyFeature {
    @Override
    protected boolean checkConfigs() {
        return ThEApi.instance().config().allowedToCraftInfusionProvider();
    }

    @Override
    protected Object[] getItemReqs(CommonDependantItems cdi) {
        return new Object[]{cdi.MEInterface};
    }

    @Override
    protected void registerCrafting() {
        CommonDependantItems cdi = FeatureRegistry.instance().getCommonItems();
        ItemStack CoalescenceCore = ThEApi.instance().items().CoalescenceCore.getStack();
        ItemStack InfusionProvider = ThEApi.instance().blocks().InfusionProvider.getStack();
        AspectList infusionProviderList = new AspectList();
        infusionProviderList.add(Aspect.MECHANISM, 64);
        infusionProviderList.add(Aspect.MAGIC, 32);
        infusionProviderList.add(Aspect.ORDER, 32);
        infusionProviderList.add(Aspect.EXCHANGE, 16);
        ItemStack[] infusionProviderRecipeItems = new ItemStack[]{cdi.EssentiaMirror, cdi.SalisMundus, CoalescenceCore, cdi.AirShard, cdi.EssentiaMirror, cdi.SalisMundus, CoalescenceCore, cdi.AirShard};
        RecipeRegistry.BLOCK_INFUSION_PROVIDER = ThaumcraftApi.addInfusionCraftingRecipe((String)ResearchRegistry.ResearchTypes.INFUSIONPROVIDER.getKey(), (Object)InfusionProvider, (int)4, (AspectList)infusionProviderList, (ItemStack)cdi.MEInterface, (ItemStack[])infusionProviderRecipeItems);
    }

    @Override
    protected void registerResearch() {
        AspectList infusionProviderList = new AspectList();
        infusionProviderList.add(Aspect.MECHANISM, 3);
        infusionProviderList.add(Aspect.MAGIC, 3);
        infusionProviderList.add(Aspect.EXCHANGE, 7);
        infusionProviderList.add(Aspect.MOTION, 7);
        infusionProviderList.add(Aspect.SENSES, 5);
        ItemStack infusionProviderIcon = new ItemStack(BlockEnum.INFUSION_PROVIDER.getBlock(), 1);
        ResearchPage[] infusionProviderPages = new ResearchPage[]{new ResearchPage(ResearchRegistry.ResearchTypes.INFUSIONPROVIDER.getPageName(1)), new ResearchPage(RecipeRegistry.BLOCK_INFUSION_PROVIDER)};
        String researchKeyMirrorOrJar = Config.allowMirrors ? "MIRROR" : "JARLABEL";
        String pseudoKeyMirrorOrJar = Config.allowMirrors ? ResearchRegistry.PseudoResearchTypes.MIRROR.getKey() : ResearchRegistry.PseudoResearchTypes.JAR.getKey();
        ResearchRegistry.ResearchTypes.INFUSIONPROVIDER.createResearchItem(infusionProviderList, 3, infusionProviderIcon, infusionProviderPages);
        ResearchRegistry.ResearchTypes.INFUSIONPROVIDER.researchItem.setParents(new String[]{this.getFirstValidParentKey(false), pseudoKeyMirrorOrJar, ResearchRegistry.PseudoResearchTypes.INFUSION.getKey()});
        ResearchRegistry.ResearchTypes.INFUSIONPROVIDER.researchItem.setParentsHidden(new String[]{researchKeyMirrorOrJar, "INFUSION"});
        ResearchRegistry.ResearchTypes.INFUSIONPROVIDER.researchItem.setConcealed().setSpecial();
        ResearchRegistry.ResearchTypes.INFUSIONPROVIDER.researchItem.registerResearchItem();
    }

    @Override
    public String getFirstValidParentKey(boolean includeSelf) {
        if (includeSelf && this.isAvailable()) {
            return ResearchRegistry.ResearchTypes.INFUSIONPROVIDER.getKey();
        }
        return FeatureRegistry.instance().featureEssentiaIOBuses.getFirstValidParentKey(true);
    }

    @Override
    public EnumSet<ResearchRegistry.PseudoResearchTypes> getPseudoParentTypes() {
        return EnumSet.of(ResearchRegistry.PseudoResearchTypes.INFUSION, Config.allowMirrors ? ResearchRegistry.PseudoResearchTypes.MIRROR : ResearchRegistry.PseudoResearchTypes.JAR);
    }
}

