/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container;

import appeng.api.config.Actionable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.container.AbstractContainerCellTerminalBase;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.inventory.HandlerWirelessEssentiaTerminal;
import thaumicenergistics.network.packet.client.PacketClientEssentiaCellTerminal;
import thaumicenergistics.network.packet.server.PacketServerEssentiaCellTerminal;
import thaumicenergistics.util.EffectiveSide;
import thaumicenergistics.util.PrivateInventory;

public class ContainerWirelessEssentiaTerminal
extends AbstractContainerCellTerminalBase {
    private static final int EXTRACT_POWER_ON_TICK = 10;
    private final HandlerWirelessEssentiaTerminal handler;
    private PrivateInventory privateInventory = new PrivateInventory("thaumicenergistics.item.essentia.cell.inventory", 2, 64){

        @Override
        public boolean func_94041_b(int slotID, ItemStack itemStack) {
            EssentiaItemContainerHelper.AspectItemType iType = EssentiaItemContainerHelper.INSTANCE.getItemType(itemStack);
            return iType == EssentiaItemContainerHelper.AspectItemType.EssentiaContainer || iType == EssentiaItemContainerHelper.AspectItemType.JarLabel;
        }
    };
    private boolean wasConnected = true;
    private int powerTickCounter = 1;
    private int terminalSlotIndex = -1;

    public ContainerWirelessEssentiaTerminal(EntityPlayer player, HandlerWirelessEssentiaTerminal handler) {
        super(player);
        this.bindToInventory(this.privateInventory);
        this.terminalSlotIndex = player.field_71071_by.field_70461_c;
        this.handler = handler;
        if (EffectiveSide.isServerSide()) {
            this.monitor = this.handler.getEssentiaMonitor();
            this.attachToMonitor();
        } else {
            new PacketServerEssentiaCellTerminal().createFullUpdateRequest(player).sendPacketToServer();
            this.hasRequested = true;
        }
    }

    private void updateConnectivity() {
        if (this.handler.isConnected()) {
            if (!this.wasConnected) {
                this.monitor = this.handler.getEssentiaMonitor();
                this.attachToMonitor();
                this.onClientRequestFullUpdate();
            }
        } else {
            if (this.wasConnected) {
                this.detachFromMonitor();
                this.onClientRequestFullUpdate();
                this.player.func_71053_j();
            }
            this.wasConnected = false;
        }
    }

    @Override
    public void doWork(int elapsedTicks) {
        if (this.handler == null) {
            return;
        }
        this.powerTickCounter += elapsedTicks;
        if (this.powerTickCounter > 10) {
            this.updateConnectivity();
            this.handler.updatePowerMultiplier();
            this.handler.extractPower(this.powerTickCounter, Actionable.MODULATE);
            this.player.field_71071_by.field_70462_a[this.terminalSlotIndex] = this.handler.getTerminalItem();
            this.powerTickCounter = 0;
        }
        this.transferEssentia(this.handler.getActionHost());
    }

    @Override
    public void onClientRequestFullUpdate() {
        new PacketClientEssentiaCellTerminal().createSortModeUpdate(this.player, this.handler.getSortingMode()).sendPacketToPlayer();
        new PacketClientEssentiaCellTerminal().createUpdateFullList(this.player, this.aspectStackList).sendPacketToPlayer();
    }

    @Override
    public void onClientRequestSortModeChange(AspectStackComparator.ComparatorMode sortingMode, EntityPlayer player) {
        this.handler.setSortingMode(sortingMode);
        new PacketClientEssentiaCellTerminal().createSortModeUpdate(player, sortingMode).sendPacketToPlayer();
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (EffectiveSide.isServerSide()) {
            for (int i = 0; i < 2; ++i) {
                this.player.func_71019_a(((Slot)this.field_75151_b.get(i)).func_75211_c(), false);
            }
        }
    }

    public ItemStack func_75144_a(int slotID, int buttonPressed, int flag, EntityPlayer player) {
        try {
            Slot clickedSlot = this.func_75139_a(slotID);
            if (clickedSlot.field_75224_c == this.player.field_71071_by && clickedSlot.getSlotIndex() == this.terminalSlotIndex) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.func_75144_a(slotID, buttonPressed, flag, player);
    }
}

