/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container;

import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.container.AbstractContainerCellTerminalBase;
import thaumicenergistics.network.packet.client.PacketClientEssentiaCellTerminal;
import thaumicenergistics.network.packet.server.PacketServerEssentiaCellTerminal;
import thaumicenergistics.parts.AEPartEssentiaTerminal;
import thaumicenergistics.util.EffectiveSide;

public class ContainerEssentiaTerminal
extends AbstractContainerCellTerminalBase {
    private AEPartEssentiaTerminal terminal = null;
    private PlayerSource playerSource = null;

    public ContainerEssentiaTerminal(AEPartEssentiaTerminal terminal, EntityPlayer player) {
        super(player);
        this.player = player;
        this.terminal = terminal;
        this.playerSource = new PlayerSource(player, (IActionHost)this.terminal);
        if (EffectiveSide.isServerSide()) {
            this.monitor = terminal.getGridBlock().getEssentiaMonitor();
            this.attachToMonitor();
            terminal.addListener(this);
        } else {
            new PacketServerEssentiaCellTerminal().createFullUpdateRequest(this.player).sendPacketToServer();
            this.hasRequested = true;
        }
        this.bindToInventory(terminal.getInventory());
    }

    @Override
    public void doWork(int elapsedTicks) {
        this.transferEssentia((BaseActionSource)this.playerSource);
    }

    @Override
    public void onClientRequestFullUpdate() {
        this.onSortingModeChanged(this.terminal.getSortingMode());
        if (this.monitor != null) {
            new PacketClientEssentiaCellTerminal().createUpdateFullList(this.player, this.aspectStackList).sendPacketToPlayer();
        }
    }

    @Override
    public void onClientRequestSortModeChange(AspectStackComparator.ComparatorMode sortingMode, EntityPlayer player) {
        this.terminal.onClientRequestSortingModeChange(sortingMode);
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (EffectiveSide.isServerSide() && this.terminal != null) {
            this.terminal.removeListener(this);
        }
    }

    public void onSortingModeChanged(AspectStackComparator.ComparatorMode sortingMode) {
        new PacketClientEssentiaCellTerminal().createSortModeUpdate(this.player, sortingMode).sendPacketToPlayer();
    }
}

