/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container;

import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.tile.storage.TileChest;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.container.AbstractContainerCellTerminalBase;
import thaumicenergistics.grid.EssentiaMonitor;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.inventory.HandlerItemEssentiaCell;
import thaumicenergistics.items.ItemEssentiaCell;
import thaumicenergistics.network.packet.client.PacketClientEssentiaCellTerminal;
import thaumicenergistics.network.packet.server.PacketServerEssentiaCellTerminal;
import thaumicenergistics.util.EffectiveSide;
import thaumicenergistics.util.PrivateInventory;

public class ContainerEssentiaCell
extends AbstractContainerCellTerminalBase {
    private TileChest hostChest;
    private PlayerSource playerSource = null;
    private ISaveProvider chestSaveProvider;
    private PrivateInventory privateInventory = new PrivateInventory("thaumicenergistics.item.essentia.cell.inventory", 2, 64){

        @Override
        public boolean func_94041_b(int slotID, ItemStack itemStack) {
            EssentiaItemContainerHelper.AspectItemType iType = EssentiaItemContainerHelper.INSTANCE.getItemType(itemStack);
            return iType == EssentiaItemContainerHelper.AspectItemType.EssentiaContainer || iType == EssentiaItemContainerHelper.AspectItemType.JarLabel;
        }
    };

    public ContainerEssentiaCell(EntityPlayer player, World world, int x, int y, int z) {
        super(player);
        if (EffectiveSide.isServerSide()) {
            TileChest hostObject = this.hostChest = (TileChest)world.func_147438_o(x, y, z);
            this.chestSaveProvider = (ISaveProvider)hostObject;
            this.playerSource = new PlayerSource(this.player, (IActionHost)hostObject);
            try {
                IMEInventoryHandler handler = this.hostChest.getHandler(StorageChannel.FLUIDS);
                if (handler != null) {
                    this.monitor = new EssentiaMonitor((IMEMonitor<IAEFluidStack>)((IMEMonitor)handler), this.hostChest.getProxy().getEnergy(), this);
                    this.attachToMonitor();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            new PacketServerEssentiaCellTerminal().createFullUpdateRequest(player).sendPacketToServer();
            this.hasRequested = true;
        }
        this.bindToInventory(this.privateInventory);
    }

    private HandlerItemEssentiaCell getCellHandler() {
        if (this.hostChest == null) {
            return null;
        }
        ItemStack essentiaCell = this.hostChest.func_70301_a(1);
        if (essentiaCell == null || !(essentiaCell.func_77973_b() instanceof ItemEssentiaCell)) {
            return null;
        }
        return new HandlerItemEssentiaCell(essentiaCell, this.chestSaveProvider);
    }

    @Override
    public void doWork(int elapsedTicks) {
        this.transferEssentia((BaseActionSource)this.playerSource);
    }

    @Override
    public void onClientRequestFullUpdate() {
        HandlerItemEssentiaCell cellHandler = this.getCellHandler();
        if (cellHandler != null) {
            new PacketClientEssentiaCellTerminal().createSortModeUpdate(this.player, cellHandler.getSortingMode()).sendPacketToPlayer();
        }
        if (this.monitor != null && this.hostChest.isPowered()) {
            new PacketClientEssentiaCellTerminal().createUpdateFullList(this.player, this.aspectStackList).sendPacketToPlayer();
        } else {
            new PacketClientEssentiaCellTerminal().createUpdateFullList(this.player, new ArrayList<AspectStack>()).sendPacketToPlayer();
        }
    }

    @Override
    public void onClientRequestSortModeChange(AspectStackComparator.ComparatorMode sortingMode, EntityPlayer player) {
        HandlerItemEssentiaCell cellHandler = this.getCellHandler();
        cellHandler.setSortingMode(sortingMode);
        new PacketClientEssentiaCellTerminal().createSortModeUpdate(player, sortingMode).sendPacketToPlayer();
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        if (EffectiveSide.isServerSide()) {
            if (this.monitor != null) {
                ((EssentiaMonitor)this.monitor).detach();
            }
            for (int i = 0; i < 2; ++i) {
                this.player.func_71019_a(((Slot)this.field_75151_b.get(i)).func_75211_c(), false);
            }
        }
        super.func_75134_a(player);
    }
}

