/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnace;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.ImmutablePair;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.container.ContainerWithPlayerInventory;
import thaumicenergistics.container.IAspectSelectorContainer;
import thaumicenergistics.container.slot.SlotRestrictive;
import thaumicenergistics.grid.IMEEssentiaMonitor;
import thaumicenergistics.grid.IMEEssentiaMonitorReceiver;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.network.packet.client.PacketClientEssentiaCellTerminal;
import thaumicenergistics.network.packet.server.PacketServerEssentiaCellTerminal;
import thaumicenergistics.util.EffectiveSide;
import thaumicenergistics.util.IInventoryUpdateReceiver;
import thaumicenergistics.util.PrivateInventory;

public abstract class AbstractContainerCellTerminalBase
extends ContainerWithPlayerInventory
implements IMEEssentiaMonitorReceiver,
IAspectSelectorContainer,
IInventoryUpdateReceiver {
    private static final int OUTPUT_POSITION_X = 26;
    private static final int OUTPUT_POSITION_Y = 74;
    private static final int INPUT_POSITION_X = 8;
    private static final int INPUT_POSITION_Y = 74;
    private static final int PLAYER_INV_POSITION_Y = 104;
    private static final int HOTBAR_INV_POSITION_Y = 162;
    private static final int MINIMUM_SOUND_WAIT = 900;
    private static final int WORK_TICK_RATE = 3;
    private static final int ESSENTIA_TRANSFER_PER_WORK_CYCLE = 64;
    public static int OUTPUT_SLOT_ID = 1;
    public static int INPUT_SLOT_ID = 0;
    protected IMEEssentiaMonitor monitor;
    protected List<AspectStack> aspectStackList = new ArrayList<AspectStack>();
    protected Aspect selectedAspect;
    protected EntityPlayer player;
    protected PrivateInventory inventory;
    private int lastInventorySecondSlotCount = 0;
    private long lastSoundPlaytime = 0L;
    private int inputSlotNumber = -1;
    private int outputSlotNumber = -1;
    private List<AspectStack> pendingChanges = new ArrayList<AspectStack>();
    private int tickCounter = 0;
    protected boolean hasRequested = false;

    public AbstractContainerCellTerminalBase(EntityPlayer player) {
        this.player = player;
        if (EffectiveSide.isClientSide()) {
            this.lastSoundPlaytime = System.currentTimeMillis();
        } else {
            this.hasRequested = true;
        }
    }

    private final int drainContainerAndMoveToOutput(BaseActionSource actionSource) {
        Slot inputSlot = this.func_75139_a(INPUT_SLOT_ID);
        if (!inputSlot.func_75216_d()) {
            return 0;
        }
        ItemStack container = inputSlot.func_75211_c().func_77946_l();
        container.field_77994_a = 1;
        AspectStack containerEssentia = EssentiaItemContainerHelper.INSTANCE.getAspectStackFromContainer(container);
        if (containerEssentia == null || containerEssentia.stackSize <= 0L) {
            return 0;
        }
        int proposedDrainAmount = (int)containerEssentia.stackSize;
        long rejectedAmount = this.monitor.injectEssentia(containerEssentia.aspect, proposedDrainAmount, Actionable.SIMULATE, actionSource, true);
        if (rejectedAmount > 0L && (proposedDrainAmount -= (int)rejectedAmount) <= 0) {
            return 0;
        }
        ImmutablePair<Integer, ItemStack> drainedContainer = EssentiaItemContainerHelper.INSTANCE.extractFromContainer(container, proposedDrainAmount);
        if (drainedContainer == null) {
            return 0;
        }
        if (this.mergeContainerWithOutputSlot((ItemStack)drainedContainer.getRight())) {
            proposedDrainAmount = (Integer)drainedContainer.left;
            this.monitor.injectEssentia(containerEssentia.aspect, proposedDrainAmount, Actionable.MODULATE, actionSource, true);
            inputSlot.func_75209_a(1);
            return proposedDrainAmount;
        }
        return 0;
    }

    private int fillContainerAndMoveToOutput(BaseActionSource actionSource) {
        if (this.selectedAspect == null) {
            return 0;
        }
        Slot inputSlot = this.func_75139_a(INPUT_SLOT_ID);
        if (!inputSlot.func_75216_d()) {
            return 0;
        }
        ItemStack container = inputSlot.func_75211_c().func_77946_l();
        container.field_77994_a = 1;
        int containerCapacity = EssentiaItemContainerHelper.INSTANCE.getContainerCapacity(container);
        if (containerCapacity == 0) {
            return 0;
        }
        long extractedAmount = this.monitor.extractEssentia(this.selectedAspect, containerCapacity, Actionable.SIMULATE, actionSource, true);
        if (extractedAmount <= 0L) {
            return 0;
        }
        int proposedFillAmount = (int)Math.min((long)containerCapacity, extractedAmount);
        ImmutablePair<Integer, ItemStack> filledContainer = EssentiaItemContainerHelper.INSTANCE.injectIntoContainer(container, new AspectStack(this.selectedAspect, proposedFillAmount));
        if (filledContainer == null) {
            return 0;
        }
        if (this.mergeContainerWithOutputSlot((ItemStack)filledContainer.getRight())) {
            proposedFillAmount = (Integer)filledContainer.left;
            this.monitor.extractEssentia(this.selectedAspect, proposedFillAmount, Actionable.MODULATE, actionSource, true);
            inputSlot.func_75209_a(1);
            return proposedFillAmount;
        }
        return 0;
    }

    private ImmutablePair<Integer, AspectStack> isChange(AspectStack potentialChange, List<AspectStack> comparedAgainst) {
        AspectStack matchingStack = null;
        for (int index = 0; index < comparedAgainst.size(); ++index) {
            matchingStack = comparedAgainst.get(index);
            if (potentialChange.aspect != matchingStack.aspect) continue;
            long changeAmount = potentialChange.stackSize - matchingStack.stackSize;
            AspectStack changedStack = new AspectStack(matchingStack.aspect, changeAmount);
            return new ImmutablePair((Object)index, (Object)changedStack);
        }
        return new ImmutablePair((Object)-1, (Object)potentialChange);
    }

    private boolean mergeAspectChangeWithCache(ImmutablePair<Integer, AspectStack> changeDetails) {
        int changedIndex = (Integer)changeDetails.getLeft();
        AspectStack changedStack = (AspectStack)changeDetails.getRight();
        if (changedStack.stackSize == 0L) {
            return false;
        }
        if (changedIndex != -1) {
            long newAmount = this.aspectStackList.get((int)changedIndex).stackSize + changedStack.stackSize;
            if (newAmount <= 0L) {
                this.aspectStackList.remove(changedIndex);
            } else {
                this.aspectStackList.get((int)changedIndex).stackSize = newAmount;
            }
        } else {
            this.aspectStackList.add(changedStack);
        }
        return true;
    }

    private boolean mergeContainerWithOutputSlot(ItemStack stackToMerge) {
        int amountMerged;
        if (stackToMerge == null) {
            return false;
        }
        Slot outputSlot = this.func_75139_a(OUTPUT_SLOT_ID);
        if (outputSlot == null) {
            return false;
        }
        if (!outputSlot.func_75216_d()) {
            outputSlot.func_75215_d(stackToMerge);
            return true;
        }
        ItemStack o = outputSlot.func_75211_c().func_77946_l();
        ItemStack n = stackToMerge.func_77946_l();
        o.field_77994_a = 1;
        n.field_77994_a = 1;
        if (ItemStack.func_77989_b((ItemStack)o, (ItemStack)n) && (amountMerged = this.inventory.incrStackSize(OUTPUT_SLOT_ID, stackToMerge.field_77994_a)) > 0) {
            stackToMerge.field_77994_a -= amountMerged;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void playTransferAudio() {
        ItemStack itemStack = this.inventory.func_70301_a(OUTPUT_SLOT_ID);
        if (itemStack != null) {
            if (this.lastInventorySecondSlotCount != itemStack.field_77994_a) {
                if (System.currentTimeMillis() - this.lastSoundPlaytime > 900L) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("game.neutral.swim"), (float)1.0f));
                    this.lastSoundPlaytime = System.currentTimeMillis();
                }
                this.lastInventorySecondSlotCount = itemStack.field_77994_a;
            }
        } else {
            this.lastInventorySecondSlotCount = 0;
        }
    }

    private void setLabelAspect() {
        if (this.selectedAspect == null) {
            return;
        }
        Slot outputSlot = this.func_75139_a(OUTPUT_SLOT_ID);
        if (outputSlot.func_75216_d() && outputSlot.func_75211_c().field_77994_a == 64) {
            return;
        }
        ItemStack label = this.inventory.func_70301_a(INPUT_SLOT_ID);
        if (EssentiaItemContainerHelper.INSTANCE.getItemType(label) != EssentiaItemContainerHelper.AspectItemType.JarLabel) {
            return;
        }
        EssentiaItemContainerHelper.INSTANCE.setLabelAspect(label, this.selectedAspect);
        this.inventory.func_70296_d();
    }

    protected void attachToMonitor() {
        if (EffectiveSide.isServerSide() && this.monitor != null) {
            this.monitor.addListener(this, this.monitor.hashCode());
            this.aspectStackList = new ArrayList<AspectStack>(this.monitor.getEssentiaList());
        }
    }

    protected void bindToInventory(PrivateInventory inventory) {
        this.inventory = inventory;
        this.inventory.setReceiver(this);
        SlotRestrictive workSlot = new SlotRestrictive(inventory, INPUT_SLOT_ID, 8, 74);
        this.func_75146_a(workSlot);
        this.inputSlotNumber = workSlot.field_75222_d;
        workSlot = new SlotFurnace(this.player, (IInventory)inventory, OUTPUT_SLOT_ID, 26, 74);
        this.func_75146_a(workSlot);
        this.outputSlotNumber = workSlot.field_75222_d;
        this.bindPlayerInventory((IInventory)this.player.field_71071_by, 104, 162);
    }

    protected void detachFromMonitor() {
        if (EffectiveSide.isServerSide() && this.monitor != null) {
            this.monitor.removeListener(this);
            this.monitor = null;
            this.aspectStackList.clear();
        }
    }

    protected abstract void doWork(int var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void transferEssentia(BaseActionSource actionSource) {
        boolean allowedToExtract = false;
        boolean allowedToInject = false;
        boolean doFill = false;
        boolean doDrain = false;
        if (this.monitor == null) return;
        if (this.inventory == null) {
            return;
        }
        ItemStack inputStack = this.inventory.func_70301_a(INPUT_SLOT_ID);
        if (inputStack == null) {
            return;
        }
        ItemStack outputStack = this.inventory.func_70301_a(OUTPUT_SLOT_ID);
        if (outputStack != null && outputStack.field_77994_a >= 64) {
            return;
        }
        EssentiaItemContainerHelper.AspectItemType iType = EssentiaItemContainerHelper.INSTANCE.getItemType(inputStack);
        if (iType == EssentiaItemContainerHelper.AspectItemType.JarLabel) {
            this.setLabelAspect();
            return;
        }
        if (iType != EssentiaItemContainerHelper.AspectItemType.EssentiaContainer) {
            return;
        }
        if (EssentiaItemContainerHelper.INSTANCE.isContainerEmpty(inputStack)) {
            if (this.selectedAspect == null) return;
            doFill = true;
        } else {
            doDrain = true;
        }
        if (actionSource != null) {
            IGridNode sourceNode = null;
            if (actionSource instanceof MachineSource) {
                sourceNode = ((MachineSource)actionSource).via.getActionableNode();
            } else if (actionSource instanceof PlayerSource) {
                sourceNode = ((PlayerSource)actionSource).via.getActionableNode();
            }
            if (sourceNode == null) {
                return;
            }
            ISecurityGrid sGrid = (ISecurityGrid)sourceNode.getGrid().getCache(ISecurityGrid.class);
            allowedToExtract = sGrid.hasPermission(this.player, SecurityPermissions.EXTRACT);
            allowedToInject = sGrid.hasPermission(this.player, SecurityPermissions.INJECT);
        }
        if (doFill && !allowedToExtract || doDrain && !allowedToInject) {
            return;
        }
        int totalTransfered = 0;
        int tmp = 0;
        do {
            if (doFill) {
                tmp = this.fillContainerAndMoveToOutput(actionSource);
                continue;
            }
            if (!doDrain) continue;
            tmp = this.drainContainerAndMoveToOutput(actionSource);
        } while (tmp > 0 && (totalTransfered += tmp) < 64);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public final void func_75142_b() {
        super.func_75142_b();
        ++this.tickCounter;
        if (this.tickCounter > 3) {
            this.doWork(this.tickCounter);
            this.tickCounter = 0;
        }
    }

    public List<AspectStack> getAspectStackList() {
        return this.aspectStackList;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public Aspect getSelectedAspect() {
        return this.selectedAspect;
    }

    @Override
    public boolean isValid(Object verificationToken) {
        if (this.monitor == null) {
            return false;
        }
        if (this.monitor.hashCode() == ((Integer)verificationToken).intValue()) {
            return true;
        }
        this.monitor = null;
        this.aspectStackList.clear();
        return false;
    }

    public boolean mergeChange(AspectStack change) {
        int index = (Integer)this.isChange(change, this.aspectStackList).getLeft();
        ImmutablePair changeDetails = new ImmutablePair((Object)index, (Object)change);
        return this.mergeAspectChangeWithCache((ImmutablePair<Integer, AspectStack>)changeDetails);
    }

    public abstract void onClientRequestFullUpdate();

    public abstract void onClientRequestSortModeChange(AspectStackComparator.ComparatorMode var1, EntityPlayer var2);

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.detachFromMonitor();
    }

    @Override
    public void onInventoryChanged(IInventory sourceInventory) {
        if (EffectiveSide.isClientSide()) {
            this.playTransferAudio();
        }
    }

    public void onReceivedAspectList(List<AspectStack> aspectStackList) {
        this.aspectStackList = aspectStackList;
        if (this.aspectStackList != null && !this.pendingChanges.isEmpty()) {
            for (int index = 0; index < this.pendingChanges.size(); ++index) {
                this.onReceivedAspectListChange(this.pendingChanges.get(index));
            }
            this.pendingChanges.clear();
        }
    }

    public boolean onReceivedAspectListChange(AspectStack change) {
        if (EffectiveSide.isServerSide()) {
            return false;
        }
        if (change == null) {
            return false;
        }
        if (!this.hasRequested) {
            return false;
        }
        if (this.aspectStackList == null) {
            this.pendingChanges.add(change);
            return false;
        }
        return this.mergeChange(change) && this.pendingChanges.isEmpty();
    }

    public void onReceivedSelectedAspect(Aspect selectedAspect) {
        this.selectedAspect = selectedAspect;
        if (EffectiveSide.isServerSide()) {
            new PacketClientEssentiaCellTerminal().createSelectedAspectUpdate(this.player, this.selectedAspect).sendPacketToPlayer();
        }
    }

    @Override
    public final void postChange(IMEEssentiaMonitor fromMonitor, Iterable<AspectStack> changes) {
        if (changes == null) {
            return;
        }
        for (AspectStack change : changes) {
            new PacketClientEssentiaCellTerminal().createListChanged(this.player, change).sendPacketToPlayer();
        }
    }

    @Override
    public void setSelectedAspect(Aspect selectedAspect) {
        new PacketServerEssentiaCellTerminal().createUpdateSelectedAspect(this.player, selectedAspect).sendPacketToServer();
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        Slot slot = (Slot)this.field_75151_b.get(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            boolean didMerge = false;
            ItemStack slotStack = slot.func_75211_c();
            if (slotNumber == this.inputSlotNumber || slotNumber == this.outputSlotNumber) {
                didMerge = this.mergeSlotWithPlayerInventory(slotStack);
            } else if (this.slotClickedWasInPlayerInventory(slotNumber) || this.slotClickedWasInHotbarInventory(slotNumber)) {
                if (((Slot)this.field_75151_b.get(this.inputSlotNumber)).func_75214_a(slotStack)) {
                    didMerge = this.func_75135_a(slotStack, this.inputSlotNumber, this.inputSlotNumber + 1, false);
                }
                if (!didMerge) {
                    didMerge = this.swapSlotInventoryHotbar(slotNumber, slotStack);
                }
            }
            if (didMerge) {
                if (slotStack.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
            }
        }
        return null;
    }
}

