/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.EventHandler;
import hardcorequesting.FileVersion;
import hardcorequesting.QuestingData;
import hardcorequesting.Team;
import hardcorequesting.TeamStats;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.network.PacketId;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestData;
import hardcorequesting.quests.QuestDataTask;
import hardcorequesting.quests.RepeatType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public abstract class QuestTask {
    protected Quest parent;
    private List<QuestTask> requirements;
    public String description;
    private String longDescription;
    private int id;
    private List<String> cachedDescription;
    static final int START_X = 180;
    static final int START_Y = 95;

    public QuestTask(Quest parent, String description, String longDescription) {
        this.parent = parent;
        this.requirements = new ArrayList<QuestTask>();
        this.description = description;
        this.longDescription = longDescription;
        this.updateId();
    }

    public void updateId() {
        this.id = this.parent.nextTaskId++;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isCompleted(EntityPlayer player) {
        return this.getData((EntityPlayer)player).completed;
    }

    public boolean isCompleted(String playername) {
        return this.getData((String)playername).completed;
    }

    public boolean isVisible(EntityPlayer player) {
        QuestTask requirement;
        Iterator<QuestTask> var2 = this.requirements.iterator();
        do {
            if (var2.hasNext()) continue;
            return true;
        } while ((requirement = var2.next()).isCompleted(player) && requirement.isVisible(player));
        return false;
    }

    public Class<? extends QuestDataTask> getDataType() {
        return QuestDataTask.class;
    }

    public void write(DataWriter dw, QuestDataTask task, boolean light) {
        dw.writeBoolean(task.completed);
    }

    public void read(DataReader dr, QuestDataTask task, FileVersion version, boolean light) {
        task.completed = dr.readBoolean();
    }

    public abstract void save(DataWriter var1);

    public abstract void load(DataReader var1, FileVersion var2);

    public QuestDataTask getData(EntityPlayer player) {
        return this.getData(QuestingData.getUserName(player));
    }

    public QuestDataTask getData(String playerName) {
        QuestData questData = QuestingData.getQuestingData(playerName).getQuestData(this.parent.getId());
        questData.tasks[this.id] = this.validateData(questData.tasks[this.id]);
        return questData.tasks[this.id];
    }

    public QuestDataTask validateData(QuestDataTask data) {
        if (data.getClass() != this.getDataType()) {
            try {
                QuestDataTask obj;
                Constructor<? extends QuestDataTask> constructor = this.getDataType().getConstructor(QuestTask.class);
                data = obj = constructor.newInstance(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return data;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getCachedLongDescription(GuiBase gui) {
        if (this.cachedDescription == null) {
            this.cachedDescription = gui.getLinesFromText(this.longDescription, 0.7f, 130);
        }
        return this.cachedDescription;
    }

    public DataWriter getWriterForTask(PacketId packetId) {
        DataWriter dw = PacketHandler.getWriter(packetId);
        dw.writeData((int)this.parent.getId(), DataBitHelper.QUESTS);
        dw.writeData(this.id, DataBitHelper.TASKS);
        return dw;
    }

    protected void completeTask(String playerName) {
        this.getData((String)playerName).completed = true;
        QuestTask.completeQuest(this.parent, playerName);
    }

    public static void completeQuest(Quest quest, String playerName) {
        if (!quest.isEnabled(playerName) || !quest.isAvailable(playerName)) {
            return;
        }
        for (QuestTask questTask : quest.getTasks()) {
            if (questTask.getData((String)playerName).completed) continue;
            return;
        }
        QuestData data = quest.getQuestData(playerName);
        data.completed = true;
        data.claimed = false;
        data.available = false;
        data.time = Quest.serverTicker.getHours();
        if (QuestingData.getQuestingData(playerName).getTeam().getRewardSetting() == Team.RewardSetting.RANDOM) {
            int rewardId = (int)(Math.random() * (double)data.reward.length);
            data.reward[rewardId] = true;
        } else {
            for (int i = 0; i < data.reward.length; ++i) {
                data.reward[i] = true;
            }
        }
        TeamStats.refreshTeam(QuestingData.getQuestingData(playerName).getTeam());
        for (Quest child : quest.getReversedRequirement()) {
            QuestTask.completeQuest(child, playerName);
            child.sendUpdatedDataToTeam(playerName);
        }
        if (quest.getRepeatInfo().getType() == RepeatType.INSTANT) {
            quest.reset(playerName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void draw(GuiQuestBook var1, EntityPlayer var2, int var3, int var4);

    @SideOnly(value=Side.CLIENT)
    public abstract void onClick(GuiQuestBook var1, EntityPlayer var2, int var3, int var4, int var5);

    public abstract void onUpdate(EntityPlayer var1, DataReader var2);

    public int getId() {
        return this.id;
    }

    public Quest getParent() {
        return this.parent;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
        this.cachedDescription = null;
    }

    public List<QuestTask> getRequirements() {
        return this.requirements;
    }

    public void addRequirement(QuestTask task) {
        this.requirements.add(task);
    }

    public void clearRequirements() {
        this.requirements.clear();
    }

    public abstract float getCompletedRatio(String var1);

    public abstract void mergeProgress(String var1, QuestDataTask var2, QuestDataTask var3);

    public abstract void autoComplete(String var1);

    public void copyProgress(QuestDataTask own, QuestDataTask other) {
        own.completed = other.completed;
    }

    public void onDelete() {
        EventHandler.instance().remove(this);
    }

    public void register(EventHandler.Type ... types) {
        EventHandler.instance().add(this, types);
    }

    public void onServerTick(TickEvent.ServerTickEvent event) {
    }

    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
    }

    public void onLivingDeath(LivingDeathEvent event) {
    }

    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
    }

    public void onItemPickUp(EntityItemPickupEvent event) {
    }

    public void onOpenBook(EventHandler.BookOpeningEvent event) {
    }

    public void onReputationChange(EventHandler.ReputationEvent event) {
    }
}

