/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingbook.container;

import com.google.common.collect.ArrayListMultimap;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.blay09.mods.cookingbook.KitchenMultiBlock;
import net.blay09.mods.cookingbook.api.kitchen.IKitchenItemProvider;
import net.blay09.mods.cookingbook.container.ComparatorName;
import net.blay09.mods.cookingbook.container.InventoryCraftBook;
import net.blay09.mods.cookingbook.container.InventoryRecipeBook;
import net.blay09.mods.cookingbook.container.InventoryRecipeBookMatrix;
import net.blay09.mods.cookingbook.container.SlotCraftMatrix;
import net.blay09.mods.cookingbook.container.SlotRecipe;
import net.blay09.mods.cookingbook.network.MessageClickRecipe;
import net.blay09.mods.cookingbook.network.MessageRecipeInfo;
import net.blay09.mods.cookingbook.network.MessageSyncList;
import net.blay09.mods.cookingbook.network.NetworkHandler;
import net.blay09.mods.cookingbook.registry.CookingRegistry;
import net.blay09.mods.cookingbook.registry.food.FoodRecipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2FPacketSetSlot;

public class ContainerRecipeBook
extends Container {
    private final EntityPlayer player;
    private final boolean allowCrafting;
    private final boolean allowSmelting;
    private final boolean isClientSide;
    private final InventoryRecipeBook recipeBook;
    private final SlotRecipe[] recipeBookSlots = new SlotRecipe[12];
    private final InventoryRecipeBookMatrix craftMatrix;
    private final SlotCraftMatrix[] craftMatrixSlots = new SlotCraftMatrix[9];
    private final ArrayListMultimap<String, FoodRecipe> availableRecipes = ArrayListMultimap.create();
    private final List<ItemStack> sortedRecipes = new ArrayList<ItemStack>();
    private String searchTerm = "";
    private final InventoryCraftBook craftBook;
    private Comparator<ItemStack> currentSort = new ComparatorName();
    private int scrollOffset;
    private boolean isFurnaceRecipe;
    private boolean isSelectionDirty;
    private boolean isRecipeListDirty;
    private int syncSlotIndex = -1;
    private int currentSlotIndex = -1;
    private FoodRecipe currentRecipe;
    private boolean hasVariants;
    private boolean isMissingTools;
    private boolean isMissingOven;
    private String currentRecipeKey;
    private List<FoodRecipe> currentRecipeList;
    private int currentRecipeIdx;
    private boolean noFilter;
    private final List<IKitchenItemProvider> emptyProviderList = new ArrayList<IKitchenItemProvider>();
    private final List<IInventory> playerInventoryList = new ArrayList<IInventory>();
    private KitchenMultiBlock kitchenMultiBlock;

    public ContainerRecipeBook(EntityPlayer player, boolean allowCrafting, boolean allowSmelting, boolean isClientSide) {
        int j;
        int i;
        this.player = player;
        this.playerInventoryList.add((IInventory)player.field_71071_by);
        this.allowCrafting = allowCrafting;
        this.allowSmelting = allowSmelting;
        this.isClientSide = isClientSide;
        this.craftMatrix = new InventoryRecipeBookMatrix();
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.craftMatrixSlots[j + i * 3] = new SlotCraftMatrix(player, this.craftMatrix, j + i * 3, 24 + j * 18, 20 + i * 18);
                this.craftMatrixSlots[j + i * 3].setSourceInventories(this.playerInventoryList);
                this.craftMatrixSlots[j + i * 3].setItemProviders(this.emptyProviderList);
                this.func_75146_a(this.craftMatrixSlots[j + i * 3]);
            }
        }
        this.recipeBook = new InventoryRecipeBook();
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                this.recipeBookSlots[j + i * 3] = new SlotRecipe(this.recipeBook, j + i * 3, 102 + j * 18, 11 + i * 18);
                this.func_75146_a(this.recipeBookSlots[j + i * 3]);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, j + i * 9 + 9, 8 + j * 18, 92 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, 8 + i * 18, 150));
        }
        this.updateRecipeList();
        this.craftBook = new InventoryCraftBook(this);
        this.craftBook.setItemProviders(this.emptyProviderList);
        this.craftBook.setInventories(this.playerInventoryList);
        this.findAvailableRecipes();
    }

    public void setCraftMatrix(FoodRecipe recipe) {
        block9: {
            block7: {
                block8: {
                    if (recipe == null) break block7;
                    this.isFurnaceRecipe = recipe.isSmeltingRecipe();
                    if (!this.isFurnaceRecipe) break block8;
                    for (SlotCraftMatrix previewSlot : this.craftMatrixSlots) {
                        previewSlot.setIngredient(null);
                        previewSlot.setEnabled(false);
                        if (this.isClientSide) continue;
                        previewSlot.updateVisibleStacks();
                    }
                    this.craftMatrixSlots[4].setIngredient(recipe.getCraftMatrix().get(0));
                    this.craftMatrixSlots[4].setEnabled(true);
                    if (this.isClientSide) break block9;
                    this.craftMatrixSlots[4].updateVisibleStacks();
                    break block9;
                }
                int offset = 0;
                if (recipe.getCraftMatrix().size() <= 3) {
                    offset += 3;
                }
                if (recipe.getCraftMatrix().size() == 1) {
                    ++offset;
                }
                for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                    int recipeIdx = i - offset;
                    if (recipeIdx >= 0 && recipeIdx < recipe.getCraftMatrix().size()) {
                        this.craftMatrixSlots[i].setIngredient(recipe.getCraftMatrix().get(recipeIdx));
                    } else {
                        this.craftMatrixSlots[i].setIngredient(null);
                    }
                    this.craftMatrixSlots[i].setEnabled(true);
                    if (this.isClientSide) continue;
                    this.craftMatrixSlots[i].updateVisibleStacks();
                }
                break block9;
            }
            for (SlotCraftMatrix previewSlot : this.craftMatrixSlots) {
                previewSlot.setIngredient(null);
                previewSlot.setEnabled(false);
            }
        }
    }

    public boolean hasVariants() {
        return this.hasVariants;
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.updateRecipeList();
    }

    public void search(String term) {
        this.searchTerm = term;
    }

    public void updateRecipeList() {
        boolean noRecipes = this.getAvailableRecipeCount() == 0;
        for (int i = 0; i < this.recipeBook.func_70302_i_(); ++i) {
            int recipeIdx = i + this.scrollOffset * 3;
            if (recipeIdx < this.sortedRecipes.size()) {
                this.recipeBook.setFoodItem(i, this.availableRecipes.get((Object)this.sortedRecipes.get(recipeIdx).toString()));
            } else {
                this.recipeBook.setFoodItem(i, null);
            }
            this.recipeBookSlots[i].func_75215_d(this.recipeBook.func_70301_a(i));
            this.recipeBookSlots[i].setEnabled(!noRecipes);
        }
        if (noRecipes) {
            this.setCraftMatrix(null);
            if (!this.isClientSide) {
                this.currentRecipeList = null;
                this.currentRecipeIdx = -1;
            }
        } else if (!this.isClientSide) {
            this.currentRecipeList = this.availableRecipes.get((Object)this.currentRecipeKey);
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_75144_a(int slotIdx, int button, int mode, EntityPlayer player) {
        if ((mode == 0 || mode == 1) && this.isClientSide) {
            this.clickRecipe(slotIdx, mode == 1);
            NetworkHandler.instance.sendToServer((IMessage)new MessageClickRecipe(slotIdx, this.scrollOffset, mode == 1));
        }
        return super.func_75144_a(slotIdx, button, mode, player);
    }

    public void clickRecipe(int slotIdx, boolean shiftClick) {
        SlotRecipe slot;
        if (slotIdx > 0 && slotIdx < this.field_75151_b.size() && this.field_75151_b.get(slotIdx) instanceof SlotRecipe && (slot = (SlotRecipe)((Object)this.field_75151_b.get(slotIdx))).func_75211_c() != null) {
            if (!this.isClientSide && this.canClickCraft(this.scrollOffset * 3 + slot.getSlotIndex())) {
                this.tryCraft(this.player, this.currentRecipe, shiftClick);
                return;
            }
            if (!this.isClientSide && !this.isMissingOven && this.canClickSmelt(this.scrollOffset * 3 + slot.getSlotIndex())) {
                this.trySmelt(this.player, this.currentRecipe, shiftClick);
                return;
            }
            int oldSlotIndex = this.currentSlotIndex;
            this.currentSlotIndex = this.scrollOffset * 3 + slot.getSlotIndex();
            if (oldSlotIndex != this.currentSlotIndex && !this.isClientSide) {
                this.currentRecipeKey = this.recipeBook.func_70301_a(slot.getSlotIndex()).toString();
                this.currentRecipeList = this.recipeBook.getFoodList(slot.getSlotIndex());
                this.currentRecipeIdx = 0;
                this.currentRecipe = this.currentRecipeList.get(this.currentRecipeIdx);
                this.setCraftMatrix(this.currentRecipe);
                this.isSelectionDirty = true;
            }
        }
    }

    private void trySmelt(EntityPlayer player, FoodRecipe recipe, boolean isShiftDown) {
        if (!recipe.isSmeltingRecipe()) {
            return;
        }
        List<IInventory> sourceInventories = this.kitchenMultiBlock.getSourceInventories(player.field_71071_by);
        for (int i = 0; i < sourceInventories.size(); ++i) {
            for (int j = 0; j < sourceInventories.get(i).func_70302_i_(); ++j) {
                ItemStack itemStack = sourceInventories.get(i).func_70301_a(j);
                if (itemStack == null) continue;
                for (ItemStack ingredientStack : recipe.getCraftMatrix().get(0).getItemStacks()) {
                    if (!CookingRegistry.areItemStacksEqualWithWildcard(itemStack, ingredientStack)) continue;
                    int count = isShiftDown ? Math.min(itemStack.field_77994_a, ingredientStack.func_77976_d()) : 1;
                    ItemStack restStack = this.kitchenMultiBlock.smeltItem(itemStack, count);
                    sourceInventories.get(i).func_70299_a(j, restStack);
                    if (i == 0) {
                        if (j < 9) {
                            ((EntityPlayerMP)player).func_71111_a((Container)this, 48 + j, restStack);
                        } else {
                            ((EntityPlayerMP)player).func_71111_a((Container)this, 21 + j - 9, restStack);
                        }
                    }
                    return;
                }
            }
        }
    }

    private void tryCraft(EntityPlayer player, FoodRecipe recipe, boolean isShiftDown) {
        block6: {
            ItemStack craftingResult;
            block5: {
                ItemStack craftingResult2;
                if (recipe.isSmeltingRecipe()) {
                    return;
                }
                if (isShiftDown) break block5;
                if (!this.craftBook.canMouseItemHold(player, recipe) || (craftingResult2 = this.craftBook.craft(player, recipe)) == null) break block6;
                ItemStack mouseItem = player.field_71071_by.func_70445_o();
                if (mouseItem != null) {
                    mouseItem.field_77994_a += craftingResult2.field_77994_a;
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S2FPacketSetSlot(-1, 0, mouseItem));
                } else {
                    player.field_71071_by.func_70437_b(craftingResult2);
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S2FPacketSetSlot(-1, 0, craftingResult2));
                }
                break block6;
            }
            for (int crafted = 0; (craftingResult = this.craftBook.craft(player, recipe)) != null && crafted < 64; crafted += craftingResult.field_77994_a) {
                if (player.field_71071_by.func_70441_a(craftingResult)) continue;
                if (player.field_71071_by.func_70445_o() == null) {
                    player.field_71071_by.func_70437_b(craftingResult);
                    break;
                }
                player.func_71019_a(craftingResult, false);
                break;
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int i) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.field_75151_b.get(i);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (i >= 48 && i < 57 ? !this.func_75135_a(slotStack, 21, 48, false) : i >= 21 && i < 48 && !this.func_75135_a(slotStack, 48, 57, false)) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.field_77994_a == itemStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, slotStack);
        }
        return itemStack;
    }

    public int getAvailableRecipeCount() {
        return this.sortedRecipes.size();
    }

    public boolean isFurnaceRecipe() {
        return this.isFurnaceRecipe;
    }

    public boolean hasSelection() {
        return this.currentRecipe != null;
    }

    public boolean canClickSmelt(int slotIndex) {
        return this.allowSmelting && this.currentSlotIndex == slotIndex && this.currentRecipe != null && this.currentRecipe.isSmeltingRecipe();
    }

    public boolean canClickCraft(int slotIndex) {
        return this.allowCrafting && this.currentSlotIndex == slotIndex && this.currentRecipe != null && !this.currentRecipe.isSmeltingRecipe();
    }

    public boolean isMissingTools() {
        return this.isMissingTools;
    }

    public boolean isRecipeListDirty() {
        return this.isRecipeListDirty;
    }

    public void markDirty(boolean dirty) {
        this.isRecipeListDirty = dirty;
    }

    @SideOnly(value=Side.CLIENT)
    public void setAvailableItems(List<ItemStack> sortedRecipes, ArrayListMultimap<String, FoodRecipe> availableRecipes) {
        this.sortedRecipes.clear();
        this.sortedRecipes.addAll(sortedRecipes);
        this.availableRecipes.clear();
        this.availableRecipes.putAll(availableRecipes);
        this.search(this.searchTerm);
        this.markDirty(true);
    }

    public boolean gotRecipeInfo() {
        return this.syncSlotIndex == this.currentSlotIndex;
    }

    public void findAvailableRecipes() {
        this.availableRecipes.clear();
        this.sortedRecipes.clear();
        for (FoodRecipe foodRecipe : CookingRegistry.getFoodRecipes()) {
            ItemStack foodStack = foodRecipe.getOutputItem();
            if (foodStack == null || !this.noFilter && !CookingRegistry.areIngredientsAvailableFor(foodRecipe.getCraftMatrix(), this.kitchenMultiBlock != null ? this.kitchenMultiBlock.getSourceInventories(this.player.field_71071_by) : this.playerInventoryList, this.kitchenMultiBlock != null ? this.kitchenMultiBlock.getItemProviders() : this.emptyProviderList)) continue;
            String foodStackString = foodStack.toString();
            if (!this.availableRecipes.containsKey((Object)foodStackString)) {
                this.sortedRecipes.add(foodStack);
            }
            this.availableRecipes.put((Object)foodStackString, (Object)foodRecipe);
        }
        this.isRecipeListDirty = true;
    }

    public void sortRecipes(Comparator<ItemStack> comparator) {
        this.currentSort = comparator;
        Collections.sort(this.sortedRecipes, comparator);
        this.updateRecipeList();
        this.isRecipeListDirty = true;
    }

    public void prevRecipe() {
        if (this.currentRecipeList != null) {
            --this.currentRecipeIdx;
            if (this.currentRecipeIdx < 0) {
                this.currentRecipeIdx = this.currentRecipeList.size() - 1;
            }
            this.setCraftMatrix(this.currentRecipeList.get(this.currentRecipeIdx));
            this.isSelectionDirty = true;
        }
    }

    public void nextRecipe() {
        if (this.currentRecipeList != null) {
            ++this.currentRecipeIdx;
            if (this.currentRecipeIdx >= this.currentRecipeList.size()) {
                this.currentRecipeIdx = 0;
            }
            this.setCraftMatrix(this.currentRecipeList.get(this.currentRecipeIdx));
            this.isSelectionDirty = true;
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.isClientSide) {
            if (this.player.field_71071_by.field_70459_e) {
                this.findAvailableRecipes();
                this.sortRecipes(this.currentSort);
                this.player.field_71071_by.field_70459_e = false;
            }
            if (this.isSelectionDirty) {
                this.isSelectionDirty = false;
                if (this.currentRecipe != null && !this.currentRecipe.isSmeltingRecipe()) {
                    this.craftBook.prepareRecipe(this.player, this.currentRecipe);
                    this.isMissingTools = !this.craftBook.matches(this.player.field_70170_p);
                } else {
                    this.isMissingTools = false;
                }
                this.hasVariants = this.currentRecipeList != null && this.currentRecipeList.size() > 1;
                this.isMissingOven = this.kitchenMultiBlock == null || !this.kitchenMultiBlock.hasSmeltingProvider();
                NetworkHandler.instance.sendTo((IMessage)new MessageRecipeInfo(this.currentSlotIndex, this.currentRecipe, this.isMissingTools, this.hasVariants, this.isMissingOven), (EntityPlayerMP)this.player);
            }
            if (this.isRecipeListDirty) {
                NetworkHandler.instance.sendTo((IMessage)new MessageSyncList(this.sortedRecipes, this.availableRecipes), (EntityPlayerMP)this.player);
                this.isRecipeListDirty = false;
            }
            for (SlotCraftMatrix previewSlot : this.craftMatrixSlots) {
                previewSlot.update();
            }
        }
    }

    public ContainerRecipeBook setNoFilter() {
        this.noFilter = true;
        for (SlotCraftMatrix slotCraftMatrix : this.craftMatrixSlots) {
            slotCraftMatrix.setNoFilter(true);
        }
        this.findAvailableRecipes();
        this.sortRecipes(this.currentSort);
        return this;
    }

    public ContainerRecipeBook setKitchenMultiBlock(KitchenMultiBlock kitchenMultiBlock) {
        this.kitchenMultiBlock = kitchenMultiBlock;
        this.findAvailableRecipes();
        List<IInventory> sourceInventories = kitchenMultiBlock.getSourceInventories(this.player.field_71071_by);
        for (int i = 0; i < this.craftMatrixSlots.length; ++i) {
            this.craftMatrixSlots[i].setSourceInventories(sourceInventories);
            this.craftMatrixSlots[i].setItemProviders(kitchenMultiBlock.getItemProviders());
        }
        this.craftBook.setInventories(sourceInventories);
        this.craftBook.setItemProviders(kitchenMultiBlock.getItemProviders());
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSelectedRecipe(int currentSlotIndex, FoodRecipe currentRecipe, boolean hasVariants, boolean isMissingTools, boolean isMissingOven) {
        this.currentSlotIndex = currentSlotIndex;
        this.syncSlotIndex = currentSlotIndex;
        this.currentRecipe = currentRecipe;
        this.hasVariants = hasVariants;
        this.isMissingTools = isMissingTools;
        this.isMissingOven = isMissingOven;
        this.setCraftMatrix(currentRecipe);
    }

    public boolean isMissingOven() {
        return this.isMissingOven;
    }
}

