/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingbook.client.render;

import net.blay09.mods.cookingbook.CookingBook;
import net.blay09.mods.cookingbook.block.TileEntityFridge;
import net.blay09.mods.cookingbook.client.model.ModelFridge;
import net.blay09.mods.cookingbook.client.model.ModelSmallFridge;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileEntityFridgeRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation textureSmall = new ResourceLocation("cookingbook", "textures/entity/ModelSmallFridge.png");
    private static final ResourceLocation textureBig = new ResourceLocation("cookingbook", "textures/entity/ModelFridge.png");
    private ModelFridge modelBig = new ModelFridge();
    private ModelSmallFridge modelSmall = new ModelSmallFridge();
    public static final float[][] fridgeColorTable = new float[][]{{1.0f, 1.0f, 1.0f}, {0.85f, 0.5f, 0.2f}, {0.7f, 0.3f, 0.85f}, {0.4f, 0.6f, 0.85f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.5f, 0.65f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.5f, 0.6f}, {0.5f, 0.25f, 0.7f}, {0.2f, 0.3f, 0.7f}, {0.4f, 0.3f, 0.2f}, {0.4f, 0.5f, 0.2f}, {0.6f, 0.2f, 0.2f}, {0.1f, 0.1f, 0.1f}};

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float delta) {
        float angle;
        int metadata = 0;
        boolean isLargeFridge = false;
        TileEntityFridge tileEntityFridge = (TileEntityFridge)tileEntity;
        int dye = tileEntityFridge.getFridgeColor();
        if (tileEntity.func_145830_o()) {
            Block below;
            metadata = tileEntity.func_145832_p();
            Block above = tileEntity.func_145831_w().func_147439_a(tileEntity.field_145851_c, tileEntity.field_145848_d + 1, tileEntity.field_145849_e);
            if (above == CookingBook.blockFridge) {
                isLargeFridge = true;
            }
            if ((below = tileEntity.func_145831_w().func_147439_a(tileEntity.field_145851_c, tileEntity.field_145848_d - 1, tileEntity.field_145849_e)) == CookingBook.blockFridge) {
                return;
            }
        }
        GL11.glPushMatrix();
        boolean oldRescaleNormal = GL11.glIsEnabled((int)32826);
        if (oldRescaleNormal) {
            GL11.glEnable((int)32826);
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z));
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        switch (ForgeDirection.getOrientation((int)metadata)) {
            case NORTH: {
                angle = 0.0f;
                break;
            }
            case EAST: {
                angle = -90.0f;
                break;
            }
            case SOUTH: {
                angle = 180.0f;
                break;
            }
            case WEST: {
                angle = 90.0f;
                break;
            }
            default: {
                angle = -90.0f;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float doorAngle = tileEntityFridge.getPrevDoorAngle() + (tileEntityFridge.getDoorAngle() - tileEntityFridge.getPrevDoorAngle()) * delta;
        doorAngle = 1.0f - doorAngle;
        doorAngle = 1.0f - doorAngle * doorAngle * doorAngle;
        if (isLargeFridge) {
            float neighbourDoorAngle;
            TileEntityFridge upperFridge = tileEntityFridge.getNeighbourFridge();
            if (upperFridge != null && (neighbourDoorAngle = upperFridge.getPrevDoorAngle() + (upperFridge.getDoorAngle() - upperFridge.getPrevDoorAngle()) * delta) > doorAngle) {
                doorAngle = neighbourDoorAngle;
            }
            this.modelBig.Door.field_78796_g = (float)(1.5707963267948966 * (double)doorAngle);
            this.modelBig.DoorHandle.field_78796_g = (float)(1.5707963267948966 * (double)doorAngle);
            this.func_147499_a(textureBig);
            this.modelBig.renderUncolored();
            GL11.glColor4f((float)fridgeColorTable[dye][0], (float)fridgeColorTable[dye][1], (float)fridgeColorTable[dye][2], (float)1.0f);
            this.modelBig.renderColored();
            if (doorAngle > 0.0f) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.modelBig.renderInterior();
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                int largeFridgeSize = tileEntityFridge.func_70302_i_() + (upperFridge != null ? upperFridge.func_70302_i_() : 0);
                for (int i = 0; i < largeFridgeSize; ++i) {
                    float itemZ;
                    ItemStack itemStack;
                    ItemStack itemStack2 = itemStack = i >= tileEntityFridge.func_70302_i_() && upperFridge != null ? upperFridge.func_70301_a(i - tileEntityFridge.func_70302_i_()) : tileEntityFridge.func_70301_a(i);
                    if (itemStack == null) continue;
                    int shelfCapacity = largeFridgeSize / 3;
                    int relSlot = i % shelfCapacity;
                    float itemX = Math.min(0.8888889f, (float)(relSlot % 9) / 9.0f);
                    float itemY = i >= shelfCapacity * 2 ? -0.75f : (i >= shelfCapacity ? 0.125f : -1.625f);
                    float f = itemZ = relSlot < 9 ? 0.0f : -0.5f;
                    if (relSlot % 2 == 0) {
                        itemZ -= 0.1f;
                    }
                    tileEntityFridge.getRenderItem().func_92058_a(itemStack);
                    RenderManager.field_78727_a.func_147940_a((Entity)tileEntityFridge.getRenderItem(), (double)(0.45f - itemX), (double)itemY, (double)(0.5f + itemZ), 0.0f, 5.0f);
                }
            }
        } else {
            this.modelSmall.Door.field_78796_g = (float)(1.5707963267948966 * (double)doorAngle);
            this.modelSmall.DoorHandle.field_78796_g = (float)(1.5707963267948966 * (double)doorAngle);
            this.func_147499_a(textureSmall);
            this.modelSmall.renderUncolored();
            GL11.glColor4f((float)fridgeColorTable[dye][0], (float)fridgeColorTable[dye][1], (float)fridgeColorTable[dye][2], (float)1.0f);
            this.modelSmall.renderColored();
            if (doorAngle > 0.0f) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.modelSmall.renderInterior();
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                for (int i = 0; i < tileEntityFridge.func_70302_i_(); ++i) {
                    float itemZ;
                    ItemStack itemStack = tileEntityFridge.func_70301_a(i);
                    if (itemStack == null) continue;
                    int relSlot = i;
                    if (i > tileEntityFridge.func_70302_i_() / 2) {
                        relSlot -= tileEntityFridge.func_70302_i_() / 2;
                    }
                    float itemX = relSlot > 8 ? Math.min(0.8f, (float)(relSlot - 9) / 5.0f) : Math.min(0.8888889f, (float)relSlot / 9.0f);
                    float itemY = i > tileEntityFridge.func_70302_i_() / 2 ? -0.7f : 0.01f;
                    float f = itemZ = relSlot > 8 ? -0.8f : -0.1f;
                    if (relSlot % 2 == 0) {
                        itemZ -= 0.1f;
                    }
                    tileEntityFridge.getRenderItem().func_92058_a(itemStack);
                    RenderManager.field_78727_a.func_147940_a((Entity)tileEntityFridge.getRenderItem(), (double)(0.45f - itemX), (double)(-2.0f + itemY), (double)(0.5f + itemZ), 0.0f, 0.0f);
                }
            }
        }
        if (!oldRescaleNormal) {
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

