/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingbook.block;

import java.util.Random;
import net.blay09.mods.cookingbook.CookingBook;
import net.blay09.mods.cookingbook.api.kitchen.IKitchenStorageProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityFridge
extends TileEntity
implements IInventory,
IKitchenStorageProvider {
    private static final Random random = new Random();
    private ItemStack[] inventory = new ItemStack[27];
    private EntityItem renderItem;
    private int fridgeColor;
    private float prevDoorAngle;
    private float doorAngle;
    private int numPlayersUsing;

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        this.renderItem = new EntityItem(world, 0.0, 0.0, 0.0);
        this.renderItem.field_70290_d = 0.0f;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int i, int count) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= count) {
                ItemStack itemStack = this.inventory[i];
                this.inventory[i] = null;
                this.func_70296_d();
                return itemStack;
            }
            ItemStack itemStack = this.inventory[i].func_77979_a(count);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            this.func_70296_d();
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory[i] = itemStack;
        this.func_70296_d();
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.prevDoorAngle = this.doorAngle;
        if (this.numPlayersUsing > 0) {
            float doorSpeed = 0.2f;
            this.doorAngle = Math.min(1.0f, this.doorAngle + 0.2f);
        } else {
            float doorSpeed = 0.1f;
            this.doorAngle = Math.max(0.0f, this.doorAngle - 0.1f);
        }
    }

    public String func_145825_b() {
        return "container.cookingbook:fridge";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_145842_c(int id, int value) {
        if (id == 1) {
            this.numPlayersUsing = value;
            return true;
        }
        if (id == 2) {
            this.fridgeColor = value;
            return true;
        }
        return super.func_145842_c(id, value);
    }

    public void func_70295_k_() {
        ++this.numPlayersUsing;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
    }

    public void func_70305_f() {
        --this.numPlayersUsing;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
    }

    public void setFridgeColor(int fridgeColor) {
        this.fridgeColor = fridgeColor;
        this.func_70296_d();
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 2, fridgeColor);
    }

    public int getFridgeColor() {
        return this.fridgeColor;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory = new ItemStack[this.func_70302_i_()];
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = tagList.func_150305_b(i);
            this.inventory[itemCompound.func_74771_c((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)itemCompound);
        }
        this.fridgeColor = tagCompound.func_74771_c("FridgeColor");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(itemCompound);
            tagList.func_74742_a((NBTBase)itemCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        tagCompound.func_74774_a("FridgeColor", (byte)this.fridgeColor);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tagCompound = pkt.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tagCompound);
    }

    public TileEntityFridge getNeighbourFridge() {
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == CookingBook.blockFridge) {
            return (TileEntityFridge)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == CookingBook.blockFridge) {
            return (TileEntityFridge)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        }
        return null;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_145830_o()) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public float getDoorAngle() {
        return this.doorAngle;
    }

    public float getPrevDoorAngle() {
        return this.prevDoorAngle;
    }

    public void breakBlock() {
        for (ItemStack itemStack : this.inventory) {
            if (itemStack == null) continue;
            float offsetX = random.nextFloat() * 0.8f + 0.1f;
            float offsetY = random.nextFloat() * 0.8f + 0.1f;
            float offsetZ = random.nextFloat() * 0.8f + 0.1f;
            while (itemStack.field_77994_a > 0) {
                int stackSize = random.nextInt(21) + 10;
                if (stackSize > itemStack.field_77994_a) {
                    stackSize = itemStack.field_77994_a;
                }
                itemStack.field_77994_a -= stackSize;
                EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + offsetX), (double)((float)this.field_145848_d + offsetY), (double)((float)this.field_145849_e + offsetZ), new ItemStack(itemStack.func_77973_b(), stackSize, itemStack.func_77960_j()));
                float f3 = 0.05f;
                entityItem.field_70159_w = (float)random.nextGaussian() * f3;
                entityItem.field_70181_x = (float)random.nextGaussian() * f3 + 0.2f;
                entityItem.field_70179_y = (float)random.nextGaussian() * f3;
                if (itemStack.func_77942_o()) {
                    entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
                }
                this.field_145850_b.func_72838_d((Entity)entityItem);
            }
        }
    }

    public EntityItem getRenderItem() {
        return this.renderItem;
    }

    @Override
    public IInventory getInventory() {
        return this;
    }
}

