/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingbook.addon;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingbook.api.CookingAPI;
import net.blay09.mods.cookingbook.api.event.FoodRegistryInitEvent;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class HarvestCraftAddon {
    private static final String[] ADDITIONAL_RECIPES = new String[]{"flourItem", "doughItem", "cornmealItem", "freshwaterItem", "pastaItem", "vanillaItem", "butterItem", "heavycreamItem", "saltItem", "freshmilkItem", "mayoItem", "cocoapowderItem", "ketchupItem", "vinegarItem", "mustardItem", "blackpepperItem", "groundcinnamonItem", "groundnutmegItem", "saladdressingItem", "batterItem", "oliveoilItem"};
    private static final String[] OVEN_RECIPES = new String[]{"turkeyrawItem", "turkeycookedItem", "rabbitrawItem", "rabbitcookedItem", "venisonrawItem", "venisoncookedItem"};
    private static final String[] TOOLS = new String[]{"cuttingboardItem", "potItem", "skilletItem", "saucepanItem", "bakewareItem", "mortarandpestleItem", "mixingbowlItem", "juicerItem"};

    public HarvestCraftAddon() {
        CookingAPI.addOvenFuel(GameRegistry.findItemStack((String)"harvestcraft", (String)"oliveoilItem", (int)1), 1600);
        for (int i = 0; i < OVEN_RECIPES.length; i += 2) {
            ItemStack source = GameRegistry.findItemStack((String)"harvestcraft", (String)OVEN_RECIPES[i], (int)1);
            ItemStack result = GameRegistry.findItemStack((String)"harvestcraft", (String)OVEN_RECIPES[i + 1], (int)1);
            if (source == null || result == null) continue;
            CookingAPI.addOvenRecipe(source, result);
        }
        for (String toolName : TOOLS) {
            ItemStack toolItem = GameRegistry.findItemStack((String)"harvestcraft", (String)toolName, (int)1);
            if (toolItem == null) continue;
            CookingAPI.addToolItem(toolItem);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onFoodRegistryInit(FoodRegistryInitEvent event) {
        event.registerNonFoodRecipe(new ItemStack(Items.field_151105_aU));
        event.registerNonFoodRecipe(new ItemStack(Items.field_151102_aT));
        for (String s : ADDITIONAL_RECIPES) {
            ItemStack itemStack = GameRegistry.findItemStack((String)"harvestcraft", (String)s, (int)1);
            if (itemStack == null) continue;
            event.registerNonFoodRecipe(itemStack);
        }
    }

    public static boolean isWeirdBrokenRecipe(IRecipe recipe) {
        if (recipe.func_77570_a() == 2 && recipe instanceof ShapelessOreRecipe) {
            List list;
            ShapelessOreRecipe oreRecipe = (ShapelessOreRecipe)recipe;
            Object first = oreRecipe.getInput().get(0);
            Object second = oreRecipe.getInput().get(1);
            ItemStack firstItem = null;
            ItemStack secondItem = null;
            if (first instanceof ItemStack) {
                firstItem = (ItemStack)first;
            } else if (first instanceof ArrayList && (list = (List)first).size() == 1) {
                firstItem = (ItemStack)list.get(0);
            }
            if (second instanceof ItemStack) {
                secondItem = (ItemStack)second;
            } else if (second instanceof ArrayList && (list = (List)second).size() == 1) {
                secondItem = (ItemStack)list.get(0);
            }
            if (firstItem != null && secondItem != null && ItemStack.func_77989_b((ItemStack)firstItem, (ItemStack)secondItem) && oreRecipe.func_77571_b().func_77969_a(firstItem)) {
                return true;
            }
        }
        return false;
    }
}

