/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.pyramid;

import com.google.common.collect.Lists;
import com.teammetallurgy.atum.blocks.BlockSandLayers;
import com.teammetallurgy.atum.blocks.stone.limestone.BlockLimestoneBricks;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity.TileEntityLimestoneChest;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity.TileEntitySarcophagus;
import com.teammetallurgy.atum.blocks.trap.BlockTrap;
import com.teammetallurgy.atum.blocks.wood.BlockAtumPlank;
import com.teammetallurgy.atum.blocks.wood.BlockAtumTorchUnlit;
import com.teammetallurgy.atum.blocks.wood.BlockCrate;
import com.teammetallurgy.atum.blocks.wood.tileentity.crate.TileEntityCrate;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.world.gen.structure.pyramid.MapGenPyramid;
import com.teammetallurgy.atum.world.gen.structure.ruins.RuinPieces;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureComponentTemplate;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class PyramidPieces {
    public static final ResourceLocation PYRAMID = new ResourceLocation("atum", "pyramid");
    private static final int MAZE_SIZE_X = 27;
    private static final int MAZE_SIZE_Z = 25;

    public static void registerPyramid() {
        MapGenStructureIO.func_143034_b(MapGenPyramid.Start.class, (String)String.valueOf(PYRAMID));
        MapGenStructureIO.func_143031_a(PyramidTemplate.class, (String)String.valueOf(new ResourceLocation("atum", "pyramid_template")));
        MapGenStructureIO.func_143031_a(Maze.class, (String)String.valueOf(new ResourceLocation("atum", "maze")));
    }

    static List<StructureComponent> getComponents(TemplateManager manager, BlockPos pos, Rotation rotation, Random random) {
        ArrayList components = Lists.newArrayList();
        PyramidTemplate template = new PyramidTemplate(manager, pos, rotation, random);
        Maze maze = new Maze(PyramidPieces.getMazeBounds(template.func_74874_b(), template.rotation), template.func_186165_e());
        components.add(template);
        components.add(maze);
        return components;
    }

    private static StructureBoundingBox getMazeBounds(StructureBoundingBox pyramidBounds, Rotation rotation) {
        int width = 27;
        int depth = 25;
        int xOffset = 2;
        int zOffset = 5;
        if (rotation == Rotation.CLOCKWISE_90) {
            xOffset = 3;
            zOffset = 2;
            width = 25;
            depth = 27;
        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            xOffset = 5;
            zOffset = 3;
            width = 25;
            depth = 27;
        } else if (rotation == Rotation.CLOCKWISE_180) {
            xOffset = 4;
            zOffset = 3;
        }
        return StructureBoundingBox.func_175899_a((int)(pyramidBounds.field_78897_a + xOffset), (int)(pyramidBounds.field_78895_b + 6), (int)(pyramidBounds.field_78896_c + zOffset), (int)(pyramidBounds.field_78897_a + xOffset + width - 1), (int)(pyramidBounds.field_78895_b + 7), (int)(pyramidBounds.field_78896_c + zOffset + depth - 1));
    }

    public static class Maze
    extends StructureComponent {
        private boolean[][] maze = null;

        public Maze() {
        }

        public Maze(StructureBoundingBox boundingBox, EnumFacing componentType) {
            this.func_186164_a(componentType);
            this.field_74887_e = boundingBox;
        }

        public boolean func_74875_a(@Nonnull World world, @Nonnull Random random, @Nonnull StructureBoundingBox validBounds) {
            this.addMaze(world, random, validBounds);
            return true;
        }

        private void addMaze(World world, Random random, StructureBoundingBox validBounds) {
            if (this.maze == null) {
                this.maze = this.generateMaze(new Random(world.func_72905_C() * (long)this.field_74887_e.field_78897_a * (long)this.field_74887_e.field_78896_c), this.field_74887_e.func_78883_b(), this.field_74887_e.func_78880_d());
            }
            for (int x = 0; x < this.field_74887_e.func_78883_b(); ++x) {
                for (int z = 0; z < this.field_74887_e.func_78880_d(); ++z) {
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x, 0, z, validBounds);
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x, 1, z, validBounds);
                    if (this.func_175807_a(world, x, -1, z, validBounds).func_177230_c() instanceof BlockLadder) {
                        this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x, 0, z, validBounds);
                        this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x, 1, z, validBounds);
                        continue;
                    }
                    if (!this.maze[x][z]) {
                        this.func_175811_a(world, PyramidTemplate.CARVED_BRICK, x, 0, z, validBounds);
                        this.func_175811_a(world, PyramidTemplate.CARVED_BRICK, x, 1, z, validBounds);
                        if (!(random.nextDouble() <= 0.1)) continue;
                        this.placeTrap(world, this.maze, x, z, random, validBounds);
                        continue;
                    }
                    int layers = MathHelper.func_76136_a((Random)random, (int)1, (int)2);
                    this.func_175811_a(world, AtumBlocks.SAND_LAYERED.func_176223_P().func_177226_a((IProperty)BlockSandLayers.LAYERS, (Comparable)Integer.valueOf(layers)), x, 0, z, validBounds);
                }
            }
        }

        private void placeTrap(World world, boolean[][] maze, int x, int z, Random random, StructureBoundingBox validBounds) {
            IBlockState trapState = PyramidTemplate.FLOOR_TRAPS.get(random.nextInt(PyramidTemplate.FLOOR_TRAPS.size())).func_176223_P();
            ArrayList<EnumFacing> validDirections = new ArrayList<EnumFacing>();
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                if (x + facing.func_82601_c() < 0 || x + facing.func_82601_c() >= maze.length || z + facing.func_82599_e() < 0 || z + facing.func_82599_e() >= maze[0].length || !maze[x + facing.func_82601_c()][z + facing.func_82599_e()]) continue;
                validDirections.add(facing.func_176734_d());
            }
            if (!validDirections.isEmpty()) {
                trapState = trapState.func_177226_a((IProperty)BlockTrap.FACING, (Comparable)validDirections.get(random.nextInt(validDirections.size())));
                this.func_175811_a(world, trapState, x, 0, z, validBounds);
            }
        }

        private boolean[][] generateMaze(Random random, int sizeX, int sizeZ) {
            boolean[][] array = new boolean[sizeX][sizeZ];
            return this.generateMazeRecursive(array, random, 1, 1);
        }

        private boolean[][] generateMazeRecursive(boolean[][] array, Random random, int x, int z) {
            ArrayList<Pair> choices = new ArrayList<Pair>();
            do {
                int innerSizeX = array.length - 1;
                int innerSizeZ = array[0].length - 1;
                choices.clear();
                if (x + 2 < innerSizeX && !array[x + 2][z]) {
                    choices.add(new Pair(2, 0));
                }
                if (x - 2 >= 0 && !array[x - 2][z]) {
                    choices.add(new Pair(-2, 0));
                }
                if (z + 2 < innerSizeZ && !array[x][z + 2]) {
                    choices.add(new Pair(0, 2));
                }
                if (z - 2 >= 0 && !array[x][z - 2]) {
                    choices.add(new Pair(0, -2));
                }
                if (choices.size() <= 0) continue;
                int xMin = random.nextInt(choices.size());
                Pair choice = (Pair)choices.get(xMin);
                choices.remove(xMin);
                array[choice.x + x][choice.y + z] = true;
                array[x + choice.x / 2][z + choice.y / 2] = true;
                this.generateMazeRecursive(array, random, x + choice.x, z + choice.y);
            } while (choices.size() > 0);
            return array;
        }

        protected void func_143012_a(@Nonnull NBTTagCompound compound) {
        }

        protected void func_143011_b(@Nonnull NBTTagCompound compound, @Nonnull TemplateManager manager) {
        }

        class Pair {
            public int x;
            public int y;

            Pair(int x, int y) {
                this.x = x;
                this.y = y;
            }

            public boolean equals(Object p) {
                return p instanceof Pair && ((Pair)p).x == this.x && ((Pair)p).y == this.y;
            }
        }
    }

    public static class PyramidTemplate
    extends StructureComponentTemplate {
        public static final List<Block> FLOOR_TRAPS = Arrays.asList(AtumBlocks.BURNING_TRAP, AtumBlocks.POISON_TRAP, AtumBlocks.SMOKE_TRAP, AtumBlocks.TAR_TRAP);
        static final IBlockState CARVED_BRICK = BlockLimestoneBricks.getBrick(BlockLimestoneBricks.BrickType.CARVED).func_176223_P().func_177226_a((IProperty)BlockLimestoneBricks.UNBREAKABLE, (Comparable)Boolean.valueOf(true));
        private ResourceLocation undeadSpawnerPair;
        private Rotation rotation;
        private Mirror mirror;

        public PyramidTemplate() {
        }

        PyramidTemplate(TemplateManager manager, BlockPos pos, Rotation rotation, Random random) {
            this(manager, pos, rotation, Mirror.NONE, random);
        }

        private PyramidTemplate(TemplateManager manager, BlockPos pos, Rotation rotation, Mirror mirror, Random random) {
            super(0);
            this.field_186178_c = pos;
            this.rotation = rotation;
            this.mirror = mirror;
            this.undeadSpawnerPair = RuinPieces.RuinTemplate.UNDEAD.get(random.nextInt(RuinPieces.RuinTemplate.UNDEAD.size())).getRegistryName();
            this.loadTemplate(manager);
        }

        private void loadTemplate(TemplateManager templateManager) {
            Template template = templateManager.func_186237_a(null, PYRAMID);
            PlacementSettings placementsettings = new PlacementSettings().func_186222_a(true).func_186220_a(this.rotation).func_186214_a(this.mirror).func_186223_a(this.field_74887_e);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_186175_a(@Nonnull String function, @Nonnull BlockPos pos, @Nonnull World world, @Nonnull Random rand, @Nonnull StructureBoundingBox box) {
            if (function.startsWith("Arrow")) {
                Rotation rotation = this.field_186177_b.func_186215_c();
                IBlockState arrowTrap = AtumBlocks.ARROW_TRAP.func_176223_P();
                if (rand.nextDouble() <= 0.3) {
                    switch (function) {
                        case "ArrowWest": {
                            arrowTrap = arrowTrap.func_177226_a((IProperty)BlockTrap.FACING, (Comparable)rotation.func_185831_a(EnumFacing.WEST));
                            break;
                        }
                        case "ArrowEast": {
                            arrowTrap = arrowTrap.func_177226_a((IProperty)BlockTrap.FACING, (Comparable)rotation.func_185831_a(EnumFacing.EAST));
                            break;
                        }
                        case "ArrowSouth": {
                            arrowTrap = arrowTrap.func_177226_a((IProperty)BlockTrap.FACING, (Comparable)rotation.func_185831_a(EnumFacing.SOUTH));
                            break;
                        }
                        case "ArrowNorth": {
                            arrowTrap = arrowTrap.func_177226_a((IProperty)BlockTrap.FACING, (Comparable)rotation.func_185831_a(EnumFacing.NORTH));
                        }
                    }
                    world.func_180501_a(pos, arrowTrap, 2);
                } else {
                    world.func_180501_a(pos, CARVED_BRICK, 2);
                }
            } else if (function.startsWith("Floor")) {
                switch (function) {
                    case "FloorTrap": {
                        if (rand.nextDouble() <= 0.5) {
                            Block trap = FLOOR_TRAPS.get(rand.nextInt(FLOOR_TRAPS.size()));
                            world.func_180501_a(pos, trap.func_176223_P().func_177226_a((IProperty)BlockTrap.FACING, (Comparable)EnumFacing.UP), 2);
                            break;
                        }
                        world.func_180501_a(pos, CARVED_BRICK, 2);
                        break;
                    }
                    case "FloorCopy": {
                        this.setTrapsCopy(world, pos, rand, box, 2);
                        break;
                    }
                    case "FloorBox": 
                    case "FloorSpace": {
                        this.setTrapsCopy(world, pos, rand, box, 3);
                    }
                }
            } else if (function.contains("Spawner")) {
                if (function.equals("SpawnerUndead")) {
                    if (box.func_175898_b((Vec3i)pos)) {
                        world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
                        TileEntity tileEntity = world.func_175625_s(pos);
                        if (tileEntity instanceof TileEntityMobSpawner) {
                            ResourceLocation location = RuinPieces.RuinTemplate.UNDEAD.get(rand.nextInt(RuinPieces.RuinTemplate.UNDEAD.size())).getRegistryName();
                            ((TileEntityMobSpawner)tileEntity).func_145881_a().func_190894_a(location);
                        }
                    }
                } else if (function.equals("SpawnerUndeadPair") && box.func_175898_b((Vec3i)pos)) {
                    world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (tileEntity instanceof TileEntityMobSpawner) {
                        ((TileEntityMobSpawner)tileEntity).func_145881_a().func_190894_a(this.undeadSpawnerPair);
                    }
                }
            } else if (function.equals("CrateChance")) {
                if (box.func_175898_b((Vec3i)pos)) {
                    if (rand.nextDouble() <= 0.2) {
                        world.func_180501_a(pos, BlockCrate.getCrate(BlockAtumPlank.WoodType.DEADWOOD).correctFacing(world, pos, BlockCrate.getCrate(BlockAtumPlank.WoodType.DEADWOOD).func_176223_P()), 2);
                        TileEntity tileEntity = world.func_175625_s(pos);
                        if (tileEntity instanceof TileEntityCrate) {
                            ((TileEntityCrate)tileEntity).func_189404_a(AtumLootTables.CRATE, rand.nextLong());
                        }
                    } else {
                        world.func_175698_g(pos);
                    }
                }
            } else if (function.equals("Chest")) {
                TileEntity tileentity;
                BlockPos posDown = pos.func_177977_b();
                if (box.func_175898_b((Vec3i)posDown) && (tileentity = world.func_175625_s(posDown)) instanceof TileEntityLimestoneChest) {
                    ((TileEntityLimestoneChest)tileentity).func_189404_a(AtumLootTables.PYRAMID_CHEST, rand.nextLong());
                }
                world.func_175698_g(pos);
            } else if (function.equals("Sarcophagus")) {
                TileEntity tileentity;
                BlockPos posDown = pos.func_177977_b();
                if (box.func_175898_b((Vec3i)posDown) && (tileentity = world.func_175625_s(posDown)) instanceof TileEntitySarcophagus) {
                    ((TileEntitySarcophagus)tileentity).func_189404_a(AtumLootTables.PHARAOH, rand.nextLong());
                }
                world.func_175698_g(pos);
            } else if (function.equals("SarcophagusArtifact")) {
                TileEntity tileentity;
                BlockPos posDown = pos.func_177977_b();
                if (box.func_175898_b((Vec3i)posDown) && (tileentity = world.func_175625_s(posDown)) instanceof TileEntitySarcophagus) {
                    ((TileEntitySarcophagus)tileentity).func_189404_a(AtumLootTables.SARCOPHAGUS_ARTIFACT, rand.nextLong());
                }
                world.func_175698_g(pos);
            } else if (function.equals("PharaohTorch") && box.func_175898_b((Vec3i)pos)) {
                if (rand.nextDouble() <= 0.25) {
                    world.func_180501_a(pos, BlockAtumTorchUnlit.getUnlitTorch((Block)AtumBlocks.PHARAOH_TORCH).func_176223_P(), 2);
                } else {
                    world.func_175698_g(pos);
                }
            }
        }

        private void setTrapsCopy(World world, BlockPos pos, Random rand, StructureBoundingBox box, int range) {
            if (rand.nextDouble() <= 0.5) {
                IBlockState copy = null;
                for (EnumFacing horizontal : EnumFacing.field_176754_o) {
                    for (int xMin = 0; xMin <= range; ++xMin) {
                        IBlockState adjacent;
                        BlockPos posOffset = pos.func_177967_a(horizontal, xMin);
                        if (!box.func_175898_b((Vec3i)posOffset) || !((adjacent = world.func_180495_p(pos.func_177967_a(horizontal, xMin))).func_177230_c() instanceof BlockTrap)) continue;
                        copy = adjacent;
                    }
                }
                if (copy != null) {
                    world.func_180501_a(pos, copy, 2);
                } else {
                    Block trap = FLOOR_TRAPS.get(rand.nextInt(FLOOR_TRAPS.size()));
                    world.func_180501_a(pos, trap.func_176223_P().func_177226_a((IProperty)BlockTrap.FACING, (Comparable)EnumFacing.UP), 2);
                }
            } else {
                world.func_180501_a(pos, CARVED_BRICK, 2);
            }
        }

        protected void func_143012_a(NBTTagCompound compound) {
            super.func_143012_a(compound);
            compound.func_74778_a("Rot", this.field_186177_b.func_186215_c().name());
            compound.func_74778_a("Mi", this.field_186177_b.func_186212_b().name());
        }

        protected void func_143011_b(NBTTagCompound compound, TemplateManager manager) {
            super.func_143011_b(compound, manager);
            this.rotation = Rotation.valueOf((String)compound.func_74779_i("Rot"));
            this.mirror = Mirror.valueOf((String)compound.func_74779_i("Mi"));
            this.loadTemplate(manager);
        }
    }
}

