/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.feature;

import com.teammetallurgy.atum.blocks.vegetation.BlockDate;
import com.teammetallurgy.atum.blocks.wood.BlockAtumPlank;
import com.teammetallurgy.atum.blocks.wood.BlockAtumSapling;
import com.teammetallurgy.atum.blocks.wood.BlockLeave;
import com.teammetallurgy.atum.init.AtumBlocks;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenPalm
extends WorldGenAbstractTree {
    private static final IBlockState BLOCK_LOG = AtumBlocks.PALM_LOG.func_176223_P();
    private static final IBlockState BLOCK_LEAVES = BlockLeave.getLeave(BlockAtumPlank.WoodType.PALM).func_176223_P().func_177226_a((IProperty)BlockLeave.field_176236_b, (Comparable)Boolean.valueOf(false));
    private final int minTreeHeight;
    private final IBlockState stateWood;
    private final IBlockState stateLeaves;
    private boolean generateOphidiansTongue;

    public WorldGenPalm(boolean notify) {
        this(notify, 5, BLOCK_LOG, BLOCK_LEAVES, false);
    }

    public WorldGenPalm(boolean notify, int minTreeHeight, boolean generateOphidiansTongue) {
        this(notify, minTreeHeight, BLOCK_LOG, BLOCK_LEAVES, generateOphidiansTongue);
    }

    public WorldGenPalm(boolean notify, int minTreeHeight, IBlockState wood, IBlockState leaves, boolean generateOphidiansTongue) {
        super(notify);
        this.minTreeHeight = minTreeHeight;
        this.stateWood = wood;
        this.stateLeaves = leaves;
        this.generateOphidiansTongue = generateOphidiansTongue;
    }

    public boolean func_180709_b(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos pos) {
        boolean isSoil;
        int treeHeight = random.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        boolean bl = this.stateWood.func_177230_c() == AtumBlocks.PALM_LOG ? soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockAtumSapling)BlockAtumSapling.getSapling(BlockAtumPlank.WoodType.PALM))) && pos.func_177956_o() >= 1 && pos.func_177956_o() + treeHeight + 1 <= 256 : (isSoil = soil.func_177230_c() == AtumBlocks.LIMESTONE_GRAVEL);
        if (isSoil) {
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + 1 + treeHeight; ++j) {
                int k = 1;
                if (j == pos.func_177956_o()) {
                    k = 0;
                }
                if (j >= pos.func_177956_o() + 1 + treeHeight - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int l = pos.func_177958_n() - k; l <= pos.func_177958_n() + k && flag; ++l) {
                    for (int i1 = pos.func_177952_p() - k; i1 <= pos.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            if (this.isReplaceable(world, (BlockPos)mutableBlockPos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = pos.func_177977_b();
            IBlockState stateDown = world.func_180495_p(down);
            if (pos.func_177956_o() >= 256 - treeHeight - 1) {
                return false;
            }
            stateDown.func_177230_c().onPlantGrow(stateDown, world, down, pos);
            int i3 = pos.func_177958_n();
            int j1 = pos.func_177952_p();
            int k1 = pos.func_177956_o() + treeHeight;
            BlockPos leafPos = new BlockPos(i3, k1, j1);
            this.spawnLeaf(world, leafPos.func_177982_a(0, 1, 0));
            for (BlockPos.MutableBlockPos baseLeafPos : BlockPos.MutableBlockPos.func_177975_b((BlockPos)leafPos.func_177982_a(-1, 0, -1), (BlockPos)leafPos.func_177982_a(1, 0, 1))) {
                this.spawnLeaf(world, (BlockPos)baseLeafPos);
            }
            this.spawnLeaf(world, leafPos.func_177982_a(2, 0, 0));
            this.spawnLeaf(world, leafPos.func_177982_a(-2, 0, 0));
            this.spawnLeaf(world, leafPos.func_177982_a(0, 0, 2));
            this.spawnLeaf(world, leafPos.func_177982_a(0, 0, -2));
            this.spawnLeaf(world, leafPos.func_177982_a(0, -1, -2));
            this.spawnLeaf(world, leafPos.func_177982_a(0, -1, 2));
            this.spawnLeaf(world, leafPos.func_177982_a(2, -1, 0));
            this.spawnLeaf(world, leafPos.func_177982_a(-2, -1, 0));
            this.spawnLeaf(world, leafPos.func_177982_a(0, -1, -3));
            this.spawnLeaf(world, leafPos.func_177982_a(0, -1, 3));
            this.spawnLeaf(world, leafPos.func_177982_a(3, -1, 0));
            this.spawnLeaf(world, leafPos.func_177982_a(-3, -1, 0));
            if (this.generateOphidiansTongue && random.nextDouble() <= 0.5) {
                for (int height = 0; height < treeHeight - 1; ++height) {
                    int amount;
                    BlockPos upN = pos.func_177981_b(height);
                    stateDown = world.func_180495_p(upN);
                    if (!stateDown.func_177230_c().isAir(stateDown, (IBlockAccess)world, upN) && !stateDown.func_177230_c().isLeaves(stateDown, (IBlockAccess)world, upN) && stateDown.func_185904_a() != Material.field_151582_l) continue;
                    this.func_175903_a(world, pos.func_177981_b(height), BLOCK_LOG);
                    if (height <= 0) continue;
                    int randAmount = MathHelper.func_76136_a((Random)random, (int)1, (int)3);
                    if (random.nextInt(25) == 0 && world.func_175623_d(pos.func_177982_a(-1, ++height, 0))) {
                        for (amount = 0; amount <= randAmount; ++amount) {
                            this.addOphidianTongue(world, pos.func_177982_a(-1, height - amount, 0), BlockVine.field_176278_M);
                        }
                    }
                    if (random.nextInt(25) == 0 && world.func_175623_d(pos.func_177982_a(1, height, 0))) {
                        for (amount = 0; amount <= randAmount; ++amount) {
                            this.addOphidianTongue(world, pos.func_177982_a(1, height - amount, 0), BlockVine.field_176280_O);
                        }
                    }
                    if (random.nextInt(25) == 0 && world.func_175623_d(pos.func_177982_a(0, height, -1))) {
                        for (amount = 0; amount <= randAmount; ++amount) {
                            this.addOphidianTongue(world, pos.func_177982_a(0, height - amount, -1), BlockVine.field_176279_N);
                        }
                    }
                    if (random.nextInt(25) != 0 || !world.func_175623_d(pos.func_177982_a(0, height, 1))) continue;
                    for (amount = 0; amount <= randAmount; ++amount) {
                        this.addOphidianTongue(world, pos.func_177982_a(0, height - amount, 1), BlockVine.field_176273_b);
                    }
                }
            }
            BlockPos datePos = leafPos.func_177977_b().func_177972_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            if (this.stateLeaves.func_177230_c() == BLOCK_LEAVES.func_177230_c() && random.nextFloat() <= 0.1f) {
                world.func_180501_a(datePos, AtumBlocks.DATE_BLOCK.func_176223_P().func_177226_a((IProperty)BlockDate.AGE, (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)random, (int)0, (int)7))), 2);
            }
            for (int height = 0; height < treeHeight; ++height) {
                BlockPos upN = pos.func_177981_b(height);
                IBlockState stateUpN = world.func_180495_p(upN);
                if (!stateUpN.func_177230_c().isAir(stateUpN, (IBlockAccess)world, upN) && !stateUpN.func_177230_c().isLeaves(stateUpN, (IBlockAccess)world, upN)) continue;
                this.func_175903_a(world, pos.func_177981_b(height), this.stateWood);
            }
            return true;
        }
        return false;
    }

    private void spawnLeaf(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (world.func_175623_d(pos) || state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, pos)) {
            this.func_175903_a(world, pos, this.stateLeaves);
        }
    }

    private void addOphidianTongue(World world, BlockPos pos, PropertyBool prop) {
        this.func_175903_a(world, pos, AtumBlocks.OPHIDIAN_TONGUE.func_176223_P().func_177226_a((IProperty)prop, (Comparable)Boolean.TRUE));
    }
}

