/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.biome.base;

import com.teammetallurgy.atum.entity.animal.EntityDesertRabbit;
import com.teammetallurgy.atum.entity.animal.EntityTarantula;
import com.teammetallurgy.atum.entity.bandit.EntityAssassin;
import com.teammetallurgy.atum.entity.bandit.EntityBarbarian;
import com.teammetallurgy.atum.entity.bandit.EntityBrigand;
import com.teammetallurgy.atum.entity.bandit.EntityNomad;
import com.teammetallurgy.atum.entity.stone.EntityStoneguard;
import com.teammetallurgy.atum.entity.stone.EntityStonewarden;
import com.teammetallurgy.atum.entity.undead.EntityBonestorm;
import com.teammetallurgy.atum.entity.undead.EntityForsaken;
import com.teammetallurgy.atum.entity.undead.EntityMummy;
import com.teammetallurgy.atum.entity.undead.EntityWraith;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.utils.AtumConfig;
import com.teammetallurgy.atum.utils.AtumUtils;
import com.teammetallurgy.atum.world.biome.base.BiomeDecoratorAtum;
import com.teammetallurgy.atum.world.gen.feature.WorldGenDeadwood;
import com.teammetallurgy.atum.world.gen.feature.WorldGenFossil;
import com.teammetallurgy.atum.world.gen.feature.WorldGenOasisGrass;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class AtumBiome
extends Biome {
    protected BiomeDecoratorAtum atumDecorator;
    private int weight;
    protected double deadwoodRarity = 0.1;

    public AtumBiome(AtumBiomeProperties properties) {
        super((Biome.BiomeProperties)properties);
        this.weight = properties.weight;
        this.atumDecorator = (BiomeDecoratorAtum)this.func_76729_a();
        this.field_76761_J.clear();
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        this.field_82914_M.clear();
        this.field_76752_A = AtumBlocks.SAND.func_176223_P();
        this.field_76753_B = AtumBlocks.LIMESTONE.func_176223_P();
    }

    public int getWeight() {
        return this.weight;
    }

    protected void addDefaultSpawns() {
        this.addSpawn(EntityDesertRabbit.class, 5, 2, 3, EnumCreatureType.CREATURE);
        this.addSpawn(EntityBat.class, 5, 8, 8, EnumCreatureType.AMBIENT);
        this.addSpawn(EntityAssassin.class, 1, 1, 1, EnumCreatureType.MONSTER);
        this.addSpawn(EntityBarbarian.class, 8, 1, 2, EnumCreatureType.MONSTER);
        this.addSpawn(EntityBrigand.class, 30, 2, 3, EnumCreatureType.MONSTER);
        this.addSpawn(EntityNomad.class, 22, 1, 4, EnumCreatureType.MONSTER);
        this.addSpawn(EntityBonestorm.class, 5, 1, 2, EnumCreatureType.MONSTER);
        this.addSpawn(EntityForsaken.class, 22, 1, 4, EnumCreatureType.MONSTER);
        this.addSpawn(EntityMummy.class, 30, 1, 3, EnumCreatureType.MONSTER);
        this.addSpawn(EntityWraith.class, 10, 1, 2, EnumCreatureType.MONSTER);
        this.addSpawn(EntityStoneguard.class, 34, 1, 2, EnumCreatureType.MONSTER);
        this.addSpawn(EntityStonewarden.class, 1, 1, 1, EnumCreatureType.MONSTER);
        this.addSpawn(EntityTarantula.class, 20, 1, 3, EnumCreatureType.MONSTER);
    }

    protected void addSpawn(Class<? extends EntityLiving> entityClass, int weight, int min, int max, EnumCreatureType type) {
        String category = "mobs." + AtumUtils.toRegistryName(entityClass.getSimpleName()).replace("entity_", "").replace("_", " ");
        weight = AtumConfig.config.get(category, "weight", weight).getInt();
        min = AtumConfig.config.get(category, "min", min).getInt();
        max = AtumConfig.config.get(category, "max", max).getInt();
        this.func_76747_a(type).add(new Biome.SpawnListEntry(entityClass, weight, min, max));
    }

    public static void initCreatureTypes() {
    }

    @Nonnull
    public BiomeDecorator getModdedBiomeDecorator(@Nonnull BiomeDecorator original) {
        BiomeDecoratorAtum dec = new BiomeDecoratorAtum();
        dec.field_76804_C = 5;
        dec.field_76799_E = 0;
        dec.field_76800_F = 0;
        dec.field_76803_B = 0;
        return dec;
    }

    @Nonnull
    public WorldGenerator func_76730_b(Random rand) {
        if (this == AtumBiomes.OASIS) {
            return new WorldGenOasisGrass(AtumBlocks.OASIS_GRASS);
        }
        return new WorldGenOasisGrass(AtumBlocks.DEAD_GRASS);
    }

    public void func_180624_a(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos pos) {
        int x = random.nextInt(16) + 8;
        int z = random.nextInt(16) + 8;
        BlockPos height = world.func_175645_m(pos.func_177982_a(x, 0, z));
        if (this.deadwoodRarity > 0.0 && random.nextDouble() <= this.deadwoodRarity) {
            new WorldGenDeadwood(false).func_180709_b(world, random, height);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FOSSIL) && random.nextInt(64) == 0) {
            new WorldGenFossil().func_180709_b(world, random, pos);
        }
        super.func_180624_a(world, random, pos);
    }

    public void func_180622_a(World world, Random random, @Nonnull ChunkPrimer chunkPrimer, int x, int z, double stoneNoise) {
        int height = 63;
        IBlockState stateTop = this.field_76752_A;
        IBlockState stateFiller = this.field_76753_B;
        int flag = -1;
        int elevation = (int)(stoneNoise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        int xx = x & 0xF;
        int zz = z & 0xF;
        for (int yy = 255; yy >= 0; --yy) {
            if (yy <= random.nextInt(5)) {
                chunkPrimer.func_177855_a(zz, yy, xx, Blocks.field_150357_h.func_176223_P());
                continue;
            }
            IBlockState existingState = chunkPrimer.func_177856_a(zz, yy, xx);
            if (existingState.func_185904_a() == Material.field_151579_a) {
                flag = -1;
                continue;
            }
            if (existingState.func_177230_c() != AtumBlocks.LIMESTONE && existingState.func_177230_c() != Blocks.field_150348_b) continue;
            if (flag == -1) {
                if (elevation <= 0) {
                    stateTop = Blocks.field_150350_a.func_176223_P();
                    stateFiller = AtumBlocks.LIMESTONE.func_176223_P();
                } else if (yy >= height - 4 && yy <= height + 1) {
                    stateTop = this.field_76752_A;
                    stateFiller = this.field_76753_B;
                }
                flag = elevation;
                if (yy >= height - 1) {
                    chunkPrimer.func_177855_a(zz, yy, xx, stateTop);
                    continue;
                }
                chunkPrimer.func_177855_a(zz, yy, xx, stateFiller);
                continue;
            }
            if (flag <= 0) continue;
            chunkPrimer.func_177855_a(zz, yy, xx, stateFiller);
            if (--flag != 0 || stateFiller.func_177230_c() != AtumBlocks.SAND || elevation <= 1) continue;
            flag = random.nextInt(4) + Math.max(0, zz - height);
            stateFiller = AtumBlocks.LIMESTONE.func_176223_P();
        }
    }

    public int getModdedBiomeGrassColor(int original) {
        return 12889745;
    }

    public int getModdedBiomeFoliageColor(int original) {
        return 12889745;
    }

    public static class AtumBiomeProperties
    extends Biome.BiomeProperties {
        private int weight;

        public AtumBiomeProperties(String biomeName, int weight) {
            super(biomeName);
            this.setBaseHeight(0.135f);
            this.setHeightVariation(0.05f);
            this.func_185395_b(0.0f);
            this.func_185396_a();
            this.func_185410_a(2.0f);
            this.func_185402_a(16421912);
            this.weight = weight != 0 ? AtumConfig.config.get("biome." + biomeName, "weight", weight).getInt() : 0;
            AtumConfig.config.save();
        }

        @Nonnull
        public AtumBiomeProperties setBaseHeight(float height) {
            super.func_185398_c(height);
            return this;
        }

        @Nonnull
        public AtumBiomeProperties setHeightVariation(float variation) {
            super.func_185400_d(variation);
            return this;
        }
    }
}

