/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.utils.event;

import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumParticles;
import com.teammetallurgy.atum.items.artifacts.atum.ItemEyesOfAtum;
import com.teammetallurgy.atum.items.artifacts.nuit.ItemNuitsVanishing;
import com.teammetallurgy.atum.proxy.ClientProxy;
import com.teammetallurgy.atum.utils.AtumConfig;
import com.teammetallurgy.atum.world.WorldProviderAtum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="atum", value={Side.CLIENT})
public class ClientEvents {
    private static final ResourceLocation MUMMY_BLUR_TEXTURE = new ResourceLocation("atum", "textures/hud/mummyblur.png");
    private static final ResourceLocation SAND_BLUR_TEXTURE = new ResourceLocation("atum", "textures/hud/sandstormwip.png");
    private static float intensity = 1.0f;

    @SubscribeEvent
    public static void renderlast(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().field_71439_g.field_71093_bK == AtumConfig.DIMENSION_ID) {
            if (Minecraft.func_71410_x().field_71474_y.field_74319_N) {
                ClientEvents.renderSand(event.getPartialTicks(), 1, 2, 3, 4, 5, 6);
            } else {
                ClientEvents.renderSand(event.getPartialTicks(), 1, 2, 3, 4, 5, 6);
            }
        }
    }

    private static void renderSand(float partialTicks, int ... layers) {
        float baseDarkness = AtumConfig.SAND_DARKNESS;
        float baseAlpha = AtumConfig.SAND_ALPHA;
        float eyesOfAtumAlpha = AtumConfig.SAND_EYES_ALPHA;
        Minecraft mc = Minecraft.func_71410_x();
        WorldProvider worldProvider = mc.field_71439_g.field_70170_p.field_73011_w;
        if (worldProvider instanceof WorldProviderAtum && mc.field_71439_g.field_71093_bK == AtumConfig.DIMENSION_ID) {
            WorldProviderAtum provider = (WorldProviderAtum)worldProvider;
            float stormStrength = provider.stormStrength;
            if (stormStrength < 1.0E-4f) {
                return;
            }
            float light = mc.field_71439_g.field_70170_p.func_72971_b(partialTicks);
            GlStateManager.func_179094_E();
            GlStateManager.func_179123_a();
            ScaledResolution scaledRes = new ScaledResolution(mc);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)scaledRes.func_78327_c(), (double)scaledRes.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179118_c();
            mc.func_110434_K().func_110577_a(SAND_BLUR_TEXTURE);
            EntityPlayerSP player = mc.field_71439_g;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            BlockPos playerPos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            boolean sky = player.field_70170_p.func_175710_j(playerPos);
            if (!sky || player.field_70170_p.func_180494_b(playerPos) == AtumBiomes.OASIS) {
                intensity -= 0.001f * partialTicks;
                intensity = Math.max(0.0f, intensity);
            } else {
                intensity += 0.01f * partialTicks;
                intensity = Math.min(stormStrength, intensity);
            }
            for (int i : layers) {
                float scale = 0.2f / (float)i;
                float alpha = (float)Math.pow(intensity - baseAlpha, i) * intensity;
                ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
                if (helmet.func_77973_b() instanceof ItemEyesOfAtum) {
                    alpha *= eyesOfAtumAlpha;
                }
                GlStateManager.func_179131_c((float)(baseDarkness * light), (float)(baseDarkness * light), (float)(baseDarkness * light), (float)alpha);
                float scaleX = 0.01f * (float)scaledRes.func_78328_b() * scale * (float)scaledRes.func_78325_e();
                float scaleY = 0.01f * (float)scaledRes.func_78326_a() * scale * (float)scaledRes.func_78325_e();
                float speed = 500.0f - (float)(i * 15);
                float movement = (float)(-(System.currentTimeMillis() % (long)((int)speed))) / speed;
                float yaw = 0.25f * (mc.field_71439_g.field_70177_z % 360.0f / 360.0f) / scale;
                float pitch = 0.5f * (mc.field_71439_g.field_70125_A % 360.0f / 360.0f) / scale;
                bufferbuilder.func_181662_b(0.0, (double)scaledRes.func_78328_b(), 90.0).func_187315_a((double)(movement + yaw), 1.0 / (double)scaleY + (double)pitch).func_181675_d();
                bufferbuilder.func_181662_b((double)scaledRes.func_78326_a(), (double)scaledRes.func_78328_b(), 90.0).func_187315_a(1.0 / (double)scaleX + (double)movement + (double)yaw, 1.0 / (double)scaleY + (double)pitch).func_181675_d();
                bufferbuilder.func_181662_b((double)scaledRes.func_78326_a(), 0.0, 90.0).func_187315_a(1.0 / (double)scaleX + (double)movement + (double)yaw, 0.0 + (double)pitch).func_181675_d();
                bufferbuilder.func_181662_b(0.0, 0.0, 90.0).func_187315_a((double)(movement + yaw), 0.0 + (double)pitch).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179121_F();
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public static void renderFog(EntityViewRenderEvent.RenderFogEvent event) {
        float sandstormFog = AtumConfig.SANDSTORM_FOG;
        WorldProvider provider = Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73011_w;
        if (provider instanceof WorldProviderAtum && event.getEntity().field_71093_bK == AtumConfig.DIMENSION_ID && AtumConfig.FOG_ENABLED) {
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            float fogDensity = 0.08f;
            if (event.getEntity() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntity();
                ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
                if (player.func_180425_c().func_177956_o() <= 60) {
                    fogDensity += (float)(62 - player.func_180425_c().func_177956_o()) * 0.005f;
                }
                if (helmet.func_77973_b() instanceof ItemEyesOfAtum) {
                    fogDensity /= 3.0f;
                }
                if (helmet.func_77973_b() == AtumItems.WANDERER_HELMET || helmet.func_77973_b() == AtumItems.DESERT_HELMET_IRON || helmet.func_77973_b() == AtumItems.DESERT_HELMET_GOLD || helmet.func_77973_b() == AtumItems.DESERT_HELMET_DIAMOND) {
                    fogDensity /= 1.5f;
                }
                if (player.field_70163_u >= (double)(player.field_70170_p.func_181545_F() - 8)) {
                    WorldProviderAtum providerAtum = (WorldProviderAtum)provider;
                    fogDensity *= 1.0f + sandstormFog - (sandstormFog - sandstormFog * providerAtum.stormStrength);
                }
                GlStateManager.func_179095_a((float)fogDensity);
            }
        }
    }

    @SubscribeEvent
    public static void onRender(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        EnumHand hand = player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() == AtumItems.NUITS_VANISHING ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
        ItemStack heldStack = player.func_184586_b(hand);
        if (ItemNuitsVanishing.IS_BAUBLES_INSTALLED && ItemNuitsVanishing.getAmulet(player).func_77973_b() == AtumItems.NUITS_VANISHING) {
            heldStack = ItemNuitsVanishing.getAmulet(player);
        }
        if (heldStack.func_77973_b() == AtumItems.NUITS_VANISHING && !ItemNuitsVanishing.isPlayerMoving(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderMummyHelmet(RenderGameOverlayEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Minecraft mc = Minecraft.func_71410_x();
        if (player != null && mc.field_71474_y.field_74320_O == 0 && event.getType() == RenderGameOverlayEvent.ElementType.HELMET && player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == AtumItems.MUMMY_HELMET) {
            ScaledResolution scaledResolution = new ScaledResolution(mc);
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179118_c();
            mc.func_110434_K().func_110577_a(MUMMY_BLUR_TEXTURE);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(0.0, (double)height, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b((double)width, (double)height, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b((double)width, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71441_e != null && !Minecraft.func_71410_x().func_147113_T()) {
            ClientProxy.atumParticles.updateEffects();
        }
    }

    @SubscribeEvent
    public static void onRenderLastWorld(RenderWorldLastEvent event) {
        EntityRenderer entityRenderer = Minecraft.func_71410_x().field_71460_t;
        AtumParticles particles = ClientProxy.atumParticles;
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.func_175606_aa();
        entityRenderer.func_180436_i();
        mc.field_71424_I.func_76318_c("litParticles");
        particles.renderLitParticles(entity, event.getPartialTicks());
        RenderHelper.func_74518_a();
        mc.field_71424_I.func_76318_c("particles");
        particles.renderParticles(entity, event.getPartialTicks());
        entityRenderer.func_175072_h();
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            ClientProxy.atumParticles.clearEffects(event.getWorld());
        }
    }
}

