/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.teammetallurgy.atum.entity.stone.EntityStoneBase;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="atum")
public class ItemGauntlet
extends ItemSword {
    protected static final TObjectFloatMap<EntityLivingBase> cooldown = new TObjectFloatHashMap();
    private final float damage;

    protected ItemGauntlet(Item.ToolMaterial material) {
        super(material);
        this.damage = material.func_78000_c() + 2.5f;
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) && enchantment != Enchantments.field_191530_r;
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        EntityLivingBase attacker;
        EntityLivingBase target = event.getEntityLiving();
        Entity source = event.getSource().func_76346_g();
        if (!(target instanceof EntityStoneBase) && source instanceof EntityLivingBase && (attacker = (EntityLivingBase)source).func_184614_ca().func_77973_b() instanceof ItemGauntlet) {
            float knockback = 0.0f;
            if (cooldown.get((Object)attacker) == 1.0f) {
                knockback = 1.0f;
            }
            target.func_70024_g((double)(-MathHelper.func_76126_a((float)(attacker.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(attacker.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAttack(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.getTarget() instanceof EntityLivingBase && !(event.getTarget() instanceof EntityStoneBase) && player.func_184614_ca().func_77973_b() instanceof ItemGauntlet) {
            cooldown.put((Object)player, player.func_184825_o(0.5f));
        }
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
        HashMultimap map = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.damage, 0));
            map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.2, 0));
        }
        return map;
    }
}

