/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.limestone.chest;

import com.teammetallurgy.atum.blocks.base.BlockChestBase;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity.TileEntitySarcophagus;
import com.teammetallurgy.atum.init.AtumBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="atum")
public class BlockSarcophagus
extends BlockChestBase {
    public BlockSarcophagus() {
        this.func_149711_c(4.0f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySarcophagus();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntitySarcophagus && !((TileEntitySarcophagus)tileEntity).isOpenable) {
            return -1.0f;
        }
        return super.func_176195_g(state, world, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntitySarcophagus && !((TileEntitySarcophagus)tileEntity).isOpenable) {
            return 6000000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean func_180639_a(World world, @Nonnull BlockPos pos, IBlockState state, @Nonnull EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntitySarcophagus sarcophagus;
        TileEntity tileEntity = world.func_175625_s(pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176459_a);
        BlockPos posLeft = pos.func_177972_a(facing.func_176746_e());
        TileEntity tileLeft = world.func_175625_s(posLeft);
        if (world.func_180495_p(posLeft).func_177230_c() == this && tileLeft instanceof TileEntitySarcophagus) {
            sarcophagus = (TileEntitySarcophagus)tileLeft;
            if (!sarcophagus.hasSpawned) {
                this.func_180639_a(world, pos.func_177972_a(facing.func_176746_e()), state, player, hand, side, hitX, hitY, hitZ);
                return false;
            }
        }
        if (tileEntity instanceof TileEntitySarcophagus) {
            sarcophagus = (TileEntitySarcophagus)tileEntity;
            if (!sarcophagus.hasSpawned) {
                if (this.canSpawnPharaoh(world, pos, facing)) {
                    for (EnumFacing horizontal : EnumFacing.field_176754_o) {
                        TileEntity tileEntityOffset = world.func_175625_s(pos.func_177972_a(horizontal));
                        if (!(tileEntityOffset instanceof TileEntitySarcophagus)) continue;
                        ((TileEntitySarcophagus)tileEntityOffset).hasSpawned = true;
                    }
                    sarcophagus.spawn(player, world.func_175649_E(pos));
                    sarcophagus.hasSpawned = true;
                    return false;
                }
                if (!sarcophagus.isOpenable) {
                    player.func_146105_b(new TextComponentTranslation("chat.atum.cannotSpawnPharaoh", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                    world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187945_hs, SoundCategory.HOSTILE, 0.7f, 0.4f, false);
                    return false;
                }
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    private boolean canSpawnPharaoh(World world, BlockPos pos, EnumFacing facing) {
        boolean isTopLeftCorner = world.func_180495_p(pos.func_177967_a(facing.func_176746_e(), 2).func_177967_a(facing.func_176734_d(), 1)).func_177230_c() == AtumBlocks.PHARAOH_TORCH;
        boolean isBottomLeftCorner = world.func_180495_p(pos.func_177967_a(facing.func_176746_e(), 2).func_177967_a(facing, 2)).func_177230_c() == AtumBlocks.PHARAOH_TORCH;
        boolean isTopRightCorner = world.func_180495_p(pos.func_177967_a(facing.func_176735_f(), 3).func_177967_a(facing.func_176734_d(), 1)).func_177230_c() == AtumBlocks.PHARAOH_TORCH;
        boolean isBottomRightCorner = world.func_180495_p(pos.func_177967_a(facing.func_176735_f(), 3).func_177967_a(facing, 2)).func_177230_c() == AtumBlocks.PHARAOH_TORCH;
        return isTopLeftCorner && isBottomLeftCorner && isTopRightCorner && isBottomRightCorner;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntitySarcophagus) {
            TileEntitySarcophagus sarcophagus = (TileEntitySarcophagus)tileEntity;
            sarcophagus.hasSpawned = true;
            sarcophagus.setOpenable();
            sarcophagus.func_145836_u();
            for (EnumFacing horizontal : EnumFacing.field_176754_o) {
                TileEntity tileEntityOffset = world.func_175625_s(pos.func_177972_a(horizontal));
                if (!(tileEntityOffset instanceof TileEntitySarcophagus)) continue;
                ((TileEntitySarcophagus)tileEntityOffset).hasSpawned = true;
                ((TileEntitySarcophagus)tileEntityOffset).setOpenable();
                tileEntityOffset.func_145836_u();
            }
        }
    }

    @SubscribeEvent
    public static void onPlaced(BlockEvent.PlaceEvent event) {
        IBlockState placedState = event.getPlacedBlock();
        if (placedState.func_177230_c() instanceof BlockSarcophagus && !BlockSarcophagus.canPlaceRightSac(event.getWorld(), event.getPos(), (EnumFacing)placedState.func_177229_b((IProperty)field_176459_a))) {
            event.setCanceled(true);
        }
    }

    private static boolean canPlaceRightSac(World world, BlockPos pos, EnumFacing facing) {
        boolean right2 = world.func_180495_p(pos.func_177967_a(facing.func_176735_f(), 2)).func_177230_c() instanceof BlockSarcophagus;
        boolean up = world.func_180495_p(pos.func_177972_a(facing.func_176735_f()).func_177972_a(facing)).func_177230_c() instanceof BlockSarcophagus;
        boolean down = world.func_180495_p(pos.func_177972_a(facing.func_176735_f()).func_177972_a(facing.func_176734_d())).func_177230_c() instanceof BlockSarcophagus;
        return !right2 && !up && !down;
    }

    @Override
    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack(AtumBlocks.SARCOPHAGUS);
    }

    @Override
    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        drops.add((Object)new ItemStack(AtumBlocks.SARCOPHAGUS));
    }
}

