/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum;

import com.teammetallurgy.atum.client.gui.AtumGuiHandler;
import com.teammetallurgy.atum.commands.AtumWeather;
import com.teammetallurgy.atum.init.AtumRecipes;
import com.teammetallurgy.atum.integration.IntegrationHandler;
import com.teammetallurgy.atum.network.NetworkHandler;
import com.teammetallurgy.atum.proxy.CommonProxy;
import com.teammetallurgy.atum.utils.AtumConfig;
import com.teammetallurgy.atum.utils.AtumCreativeTab;
import com.teammetallurgy.atum.world.AtumDimension;
import com.teammetallurgy.atum.world.gen.structure.girafitomb.GirafiTombPieces;
import com.teammetallurgy.atum.world.gen.structure.lighthouse.LighthousePieces;
import com.teammetallurgy.atum.world.gen.structure.mineshaft.StructureAtumMineshaftPieces;
import com.teammetallurgy.atum.world.gen.structure.pyramid.PyramidPieces;
import com.teammetallurgy.atum.world.gen.structure.ruins.RuinPieces;
import com.teammetallurgy.atum.world.gen.structure.tomb.TombPieces;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="atum", name="Atum2", version="2.0.17", dependencies="required-after:forge@[14.23.5.2768,);after:baubles", guiFactory="com.teammetallurgy.atum.client.gui.AtumGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class Atum {
    @Mod.Instance(value="atum")
    public static Atum instance;
    @SidedProxy(clientSide="com.teammetallurgy.atum.proxy.ClientProxy", serverSide="com.teammetallurgy.atum.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final Logger LOG;
    public static final CreativeTabs CREATIVE_TAB;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        AtumConfig config = new AtumConfig(event.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)config);
        IntegrationHandler.INSTANCE.initModIntegration();
        NetworkHandler.register();
        StructureAtumMineshaftPieces.registerMineshaft();
        PyramidPieces.registerPyramid();
        RuinPieces.registerRuins();
        TombPieces.registerTomb();
        GirafiTombPieces.registerGirafiTomb();
        LighthousePieces.registerLighthouse();
        IntegrationHandler.INSTANCE.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        AtumRecipes.addKilnRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new AtumGuiHandler());
        IntegrationHandler.INSTANCE.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        AtumDimension.register();
    }

    @Mod.EventHandler
    public static void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new AtumWeather());
    }

    static {
        LOG = LogManager.getLogger((String)"Atum2");
        CREATIVE_TAB = new AtumCreativeTab();
    }
}

