/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.tool.sextant;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.base.ISpecialInteractItem;
import hellfirepvp.astralsorcery.common.item.tool.sextant.SextantFinder;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.structure.array.PatternBlockArray;
import hellfirepvp.astralsorcery.common.tile.IMultiblockDependantTile;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSextant
extends Item
implements ISpecialInteractItem {
    public ItemSextant() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            ItemStack adv = new ItemStack((Item)this);
            ItemSextant.setAdvanced(adv);
            items.add((Object)adv);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        SextantFinder.TargetObject to;
        if (ItemSextant.isAdvanced(stack)) {
            tooltip.add(TextFormatting.BLUE.toString() + I18n.func_135052_a((String)"item.itemsextant.upgraded", (Object[])new Object[0]));
        }
        if ((to = ItemSextant.getTarget(stack)) != null) {
            tooltip.add(TextFormatting.GOLD.toString() + I18n.func_135052_a((String)("item.itemsextant.target." + to.getRegistryName() + ".name"), (Object[])new Object[0]));
        }
    }

    public static boolean isAdvanced(ItemStack sextantStack) {
        if (sextantStack.func_190926_b() || !(sextantStack.func_77973_b() instanceof ItemSextant)) {
            return false;
        }
        return NBTHelper.getBoolean(NBTHelper.getPersistentData(sextantStack), "advanced", false);
    }

    public static void setAdvanced(ItemStack sextantStack) {
        if (sextantStack.func_190926_b() || !(sextantStack.func_77973_b() instanceof ItemSextant)) {
            return;
        }
        NBTHelper.getPersistentData(sextantStack).func_74757_a("advanced", true);
    }

    @Nullable
    public static SextantFinder.TargetObject getTarget(ItemStack sextantStack) {
        if (sextantStack.func_190926_b() || !(sextantStack.func_77973_b() instanceof ItemSextant)) {
            return null;
        }
        return SextantFinder.getByName(NBTHelper.getPersistentData(sextantStack).func_74779_i("target"));
    }

    public static void setTarget(ItemStack sextantStack, SextantFinder.TargetObject target) {
        if (sextantStack.func_190926_b() || !(sextantStack.func_77973_b() instanceof ItemSextant)) {
            return;
        }
        NBTHelper.getPersistentData(sextantStack).func_74778_a("target", target.getRegistryName());
    }

    @Nullable
    public static Tuple<BlockPos, Integer> getCurrentTargetInformation(ItemStack sextantStack) {
        if (sextantStack.func_190926_b() || !(sextantStack.func_77973_b() instanceof ItemSextant)) {
            return null;
        }
        NBTTagCompound pers = NBTHelper.getPersistentData(sextantStack);
        if (!pers.func_74764_b("targetPos") || !pers.func_74764_b("targetDim")) {
            return null;
        }
        BlockPos pos = NBTHelper.readBlockPosFromNBT(pers.func_74775_l("targetPos"));
        Integer dim = pers.func_74762_e("targetDim");
        return new Tuple<BlockPos, Integer>(pos, dim);
    }

    public static void setCurrentTargetInformation(ItemStack sextantStack, @Nullable BlockPos pos, @Nullable Integer dim) {
        if (sextantStack.func_190926_b() || !(sextantStack.func_77973_b() instanceof ItemSextant)) {
            return;
        }
        NBTTagCompound pers = NBTHelper.getPersistentData(sextantStack);
        if (pos == null || dim == null) {
            pers.func_82580_o("targetPos");
            pers.func_82580_o("targetDim");
        } else {
            NBTHelper.setAsSubTag(pers, "targetPos", tag -> NBTHelper.writeBlockPosToNBT(pos, tag));
            pers.func_74768_a("targetDim", dim.intValue());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack held = player.func_184586_b(handIn);
        if (worldIn.field_72995_K && ResearchManager.clientProgress.getTierReached().isThisLaterOrEqual(ProgressionTier.BASIC_CRAFT)) {
            player.openGui((Object)AstralSorcery.instance, CommonProxy.EnumGuiId.SEXTANT.ordinal(), worldIn, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)held);
    }

    @Override
    public boolean needsSpecialHandling(World world, BlockPos at, EntityPlayer player, ItemStack stack) {
        TileEntity te = world.func_175625_s(at);
        if (te != null && te instanceof IMultiblockDependantTile) {
            PatternBlockArray struct = ((IMultiblockDependantTile)te).getRequiredStructure();
            return struct != null;
        }
        return false;
    }

    @Override
    public boolean onRightClick(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, EnumHand hand, ItemStack stack) {
        PatternBlockArray struct;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IMultiblockDependantTile && (struct = ((IMultiblockDependantTile)te).getRequiredStructure()) != null) {
            if (!struct.matches(world, pos)) {
                if (!world.field_72995_K && world instanceof WorldServer && entityPlayer.func_184812_l_() && entityPlayer.func_70093_af() && MiscUtils.isChunkLoaded(world, pos)) {
                    IBlockState current = world.func_180495_p(pos);
                    struct.placeInWorld(world, pos);
                    if (!world.func_180495_p(pos).equals(current)) {
                        world.func_175656_a(pos, current);
                    }
                }
                if (world.field_72995_K) {
                    this.requestPreview(te);
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void requestPreview(TileEntity te) {
        EffectHandler.getInstance().requestStructurePreviewFor((IMultiblockDependantTile)te);
    }
}

