/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.metadata;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;

public class RegistryExportableCraftingRecipe
implements IRegistryExportable {
    @Override
    public JsonObject export() {
        ListMultimap taggedRecipeReverse = Multimaps.newListMultimap((Map)Maps.newHashMap(), Lists::newArrayList);
        for (ModContainer modContainer : Loader.instance().getActiveModList()) {
            RecipeHandler recipeHandler;
            if (!(modContainer.getMod() instanceof ModBase) || (recipeHandler = ((ModBase)modContainer.getMod()).getRecipeHandler()) == null) continue;
            for (Map.Entry entry : recipeHandler.getTaggedRecipes().entries()) {
                if (!(((org.cyclops.cyclopscore.recipe.custom.api.IRecipe)entry.getValue()).getOutput() instanceof IngredientRecipeComponent)) continue;
                ItemStack outputStack = ((IngredientRecipeComponent)((org.cyclops.cyclopscore.recipe.custom.api.IRecipe)entry.getValue()).getOutput()).getFirstItemStack();
                taggedRecipeReverse.put((Object)outputStack, entry.getKey());
            }
        }
        JsonObject elements = new JsonObject();
        for (ResourceLocation key : CraftingManager.field_193380_a.func_148742_b()) {
            IRecipe value = (IRecipe)CraftingManager.field_193380_a.func_82594_a((Object)key);
            JsonObject serializedRecipe = this.serializeRecipe(value);
            ItemStack outputItem = value.func_77571_b();
            JsonArray tags = new JsonArray();
            for (Map.Entry entry : taggedRecipeReverse.entries()) {
                if (!ItemStack.func_77989_b((ItemStack)((ItemStack)entry.getKey()), (ItemStack)outputItem)) continue;
                tags.add((String)entry.getValue());
            }
            serializedRecipe.add("tags", (JsonElement)tags);
            String outputKey = outputItem.func_77973_b().getRegistryName().toString();
            if (!elements.has(outputKey)) {
                elements.add(outputKey, (JsonElement)new JsonArray());
            }
            elements.getAsJsonArray(outputKey).add((JsonElement)serializedRecipe);
        }
        return elements;
    }

    @Override
    public String getName() {
        return "crafting_recipe";
    }

    public JsonObject serializeRecipe(IRecipe recipe) {
        JsonObject object = new JsonObject();
        NonNullList inputs = recipe.func_192400_c();
        JsonArray arrayInputs = new JsonArray();
        for (Ingredient input : inputs) {
            JsonArray arrayInputAlternatives = new JsonArray();
            for (ItemStack inputAlternative : input.func_193365_a()) {
                arrayInputAlternatives.add((JsonElement)IRegistryExportable.serializeItemStack(inputAlternative));
            }
            arrayInputs.add((JsonElement)arrayInputAlternatives);
        }
        object.add("input", (JsonElement)arrayInputs);
        object.add("output", (JsonElement)IRegistryExportable.serializeItemStack(recipe.func_77571_b()));
        if (recipe instanceof IShapedRecipe) {
            object.addProperty("width", (Number)((IShapedRecipe)recipe).getRecipeWidth());
            object.addProperty("height", (Number)((IShapedRecipe)recipe).getRecipeHeight());
        }
        return object;
    }
}

