/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.util;

import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.google.common.base.Optional;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockUtils {
    public static final int UPDATE = 1;
    public static final int SEND_TO_CLIENTS = 2;
    public static final int NO_RERENDER = 4;
    public static final int RERENDER_MAIN_THREAD = 8;
    public static final int NO_OBSERVERS = 16;
    public static final int DEFAULT = 3;
    public static final int DEFAULT_AND_RERENDER = 11;
    public static final IBlockState AIR_STATE = Blocks.field_150350_a.func_176223_P();
    public static final String DATA_TAG = "BlockEntityTag";

    public static String getNameFromState(IBlockState state) {
        if (state == AIR_STATE) {
            return "minecraft:air";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(Block.field_149771_c.func_177774_c((Object)state.func_177230_c()));
        if (state != state.func_177230_c().func_176223_P() && !state.func_177228_b().isEmpty()) {
            builder.append('[');
            boolean first = true;
            for (Map.Entry entry : state.func_177228_b().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(((IProperty)entry.getKey()).func_177701_a());
                builder.append('=');
                builder.append(((IProperty)entry.getKey()).func_177702_a((Comparable)CommonUtils.cast(entry.getValue())));
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static IBlockState getStateFromName(String name, IBlockState def) {
        if (name.isEmpty()) {
            return def;
        }
        int p = name.indexOf(91);
        String stateName = p == -1 ? name : name.substring(0, p);
        IBlockState state = ((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(stateName))).func_176223_P();
        if (state == AIR_STATE) {
            return def;
        }
        if (p >= 0) {
            for (String property : name.substring(p + 1, name.length() - 1).split(",")) {
                Optional propValue;
                String[] p1 = property.split("=", 2);
                IProperty property1 = state.func_177230_c().func_176194_O().func_185920_a(p1[0]);
                if (property1 == null || !(propValue = property1.func_185929_b(p1[1])).isPresent()) continue;
                state = state.func_177226_a(property1, (Comparable)CommonUtils.cast(propValue.get()));
            }
        }
        return state;
    }

    public static IBlockState getStateFromName(String name) {
        return BlockUtils.getStateFromName(name, AIR_STATE);
    }

    public static void notifyBlockUpdate(World world, BlockPos pos, @Nullable IBlockState state) {
        if (state == null) {
            state = world.func_180495_p(pos);
        }
        world.func_184138_a(pos, state, state, 11);
    }

    public static boolean hasData(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b(DATA_TAG);
    }

    public static NBTTagCompound getData(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt != null ? nbt.func_74775_l(DATA_TAG) : new NBTTagCompound();
    }

    public static void removeData(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            nbt.func_82580_o(DATA_TAG);
            nbt.func_74775_l("display").func_82580_o("Lore");
            stack.func_77982_d(NBTUtils.minimize(nbt));
        }
    }
}

