/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IconAnimation
extends Icon {
    public final List<Icon> list;

    public static Icon fromList(List<Icon> icons, boolean includeEmpty) {
        ArrayList<Icon> list = new ArrayList<Icon>(icons.size());
        for (Icon icon : icons) {
            if (icon instanceof IconAnimation) {
                for (Icon icon1 : ((IconAnimation)icon).list) {
                    if (!includeEmpty && icon1.isEmpty()) continue;
                    list.add(icon1);
                }
                continue;
            }
            if (!includeEmpty && icon.isEmpty()) continue;
            list.add(icon);
        }
        if (list.isEmpty()) {
            return EMPTY;
        }
        if (list.size() == 1) {
            return (Icon)list.get(0);
        }
        return new IconAnimation(list);
    }

    private IconAnimation(List<Icon> l) {
        this.list = l;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int w, int h) {
        if (!this.list.isEmpty()) {
            this.list.get((int)(System.currentTimeMillis() / 1000L % (long)this.list.size())).draw(x, y, w, h);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawStatic(int x, int y, int w, int h) {
        if (!this.list.isEmpty()) {
            this.list.get(0).drawStatic(x, y, w, h);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw3D() {
        if (!this.list.isEmpty()) {
            this.list.get((int)(System.currentTimeMillis() / 1000L % (long)this.list.size())).draw3D();
        }
    }

    @Override
    public JsonElement getJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", "animation");
        JsonArray array = new JsonArray();
        for (Icon icon : this.list) {
            array.add(icon.getJson());
        }
        json.add("icons", (JsonElement)array);
        return json;
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof IconAnimation && this.list.equals(((IconAnimation)o).list);
    }

    @Override
    @Nullable
    public Object getIngredient() {
        if (!this.list.isEmpty()) {
            return this.list.get((int)(System.currentTimeMillis() / 1000L % (long)this.list.size())).getIngredient();
        }
        return null;
    }
}

