/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2classictweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import ic2.api.classic.recipe.ClassicRecipes;
import java.util.Locale;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import trinsdar.ic2classictweaker.CraftTweakerActions;

@ModOnly(value="ic2")
@ZenClass(value="mods.ic2.LiquidFuelGenerator")
@ZenRegister
public class LiquidFuelGeneratorSupport {
    @ZenMethod
    public static void addFluid(ILiquidStack liquid, int ticks, int powerOutput) {
        CraftTweakerActions.apply(new LiquidFuelGeneratorFuelAction(liquid, ticks, powerOutput));
    }

    private static final class LiquidFuelGeneratorFuelAction
    implements IAction {
        private final FluidStack fluid;
        private final int time;
        private final int power;

        LiquidFuelGeneratorFuelAction(ILiquidStack liquid, int time, int power) {
            this.fluid = CraftTweakerMC.getLiquidStack((ILiquidStack)liquid);
            this.time = time;
            this.power = power;
        }

        public void apply() {
            ClassicRecipes.fluidGenerator.addEntry(this.fluid.getFluid(), this.time, (float)this.power);
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Add Fuel[%s, %s, %s] to %s", this.fluid, this.time, this.power, ClassicRecipes.fluidGenerator);
        }
    }
}

