/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2classictweaker;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.custom.IClassicScrapBoxManager;
import ic2.core.platform.registry.Ic2Items;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;
import trinsdar.ic2classictweaker.Config;

@Mod(modid="ic2_classic_tweaker", name="IC2 Classic Tweaker", version="1.0.3", dependencies="required-after:ic2;required-after:ic2-classic-spmod;required-after:crafttweaker;before:jei", acceptedMinecraftVersions="[1.12.2]")
public class IC2ClassicTweaker {
    public static final String MODID = "ic2_classic_tweaker";
    public static final String MODNAME = "IC2 Classic Tweaker";
    public static final String VERSION = "1.0.3";
    public static Logger logger;
    public static Configuration config;
    public static List<ItemStack> scrapboxToRemove;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        File directory = event.getModConfigurationDirectory();
        config = new Configuration(new File(directory.getPath(), "ic2/ic2classictweaker.cfg"));
        Config.readConfig();
        scrapboxToRemove = new ArrayList<ItemStack>();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        IC2ClassicTweaker.initRemoveCanningMachineRecipes();
        IC2ClassicTweaker.initRemoveRareEarthRecipes();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        for (ItemStack stack : scrapboxToRemove) {
            for (IClassicScrapBoxManager.IDrop drop : ClassicRecipes.scrapboxDrops.getEntries()) {
                if (!drop.getDrop().func_77969_a(stack)) continue;
                ClassicRecipes.scrapboxDrops.removeDrop(drop);
            }
        }
    }

    private static void initRemoveRareEarthRecipes() {
        if (Config.disableAllDefaultRareEarthRecipes) {
            ClassicRecipes.earthExtractor.removeEntry(new ItemStack[]{new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150348_b, 1, 1), new ItemStack(Blocks.field_150348_b, 1, 3), new ItemStack(Blocks.field_150348_b, 1, 5), new ItemStack(Blocks.field_150424_aL), new ItemStack((Block)Blocks.field_150391_bh), new ItemStack(Items.field_151119_aD), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150425_aM)});
        } else {
            if (Config.disableCobblestone) {
                ClassicRecipes.earthExtractor.removeEntry(new ItemStack[]{new ItemStack(Blocks.field_150347_e)});
            }
            if (Config.disableGranite) {
                ClassicRecipes.earthExtractor.removeEntry(new ItemStack[]{new ItemStack(Blocks.field_150348_b, 1, 1)});
            }
            if (Config.disableDiorite) {
                ClassicRecipes.earthExtractor.removeEntry(new ItemStack[]{new ItemStack(Blocks.field_150348_b, 1, 3)});
            }
            if (Config.disableAndestie) {
                ClassicRecipes.earthExtractor.removeEntry(new ItemStack[]{new ItemStack(Blocks.field_150348_b, 1, 5)});
            }
            if (Config.disableNetherrack) {
                ClassicRecipes.earthExtractor.removeEntry(new ItemStack[]{new ItemStack(Blocks.field_150424_aL)});
            }
            if (Config.disableMycelium) {
                ClassicRecipes.earthExtractor.removeEntry(new ItemStack[]{new ItemStack((Block)Blocks.field_150391_bh)});
            }
            if (Config.disableClay) {
                ClassicRecipes.earthExtractor.removeEntry(new ItemStack[]{new ItemStack(Items.field_151119_aD)});
            }
            if (Config.disableObsidian) {
                ClassicRecipes.earthExtractor.removeEntry(new ItemStack[]{new ItemStack(Blocks.field_150343_Z)});
            }
            if (Config.disableSoulSand) {
                ClassicRecipes.earthExtractor.removeEntry(new ItemStack[]{new ItemStack(Blocks.field_150425_aM)});
            }
        }
    }

    private static void initRemoveCanningMachineRecipes() {
        if (Config.disableAllEmptyCanFillingRecipes) {
            ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell);
        } else {
            if (Config.disableHCoalCell) {
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, Ic2Items.hydratedCoalClump);
            }
            if (Config.disableBioCell) {
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, Ic2Items.bioBall);
            }
            if (Config.disableLavaCell) {
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, new ItemStack((Block)Blocks.field_150353_l));
            }
            if (Config.disableWaterCell) {
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, new ItemStack((Block)Blocks.field_150355_j));
            }
            if (Config.disableUraniumFuelCell) {
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, Ic2Items.uraniumIngot);
            }
            if (Config.disableRedstoneUraniumFuelCell) {
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, Ic2Items.redstoneUraniumIngot);
            }
            if (Config.disableBlazeUraniumFuelCell) {
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, Ic2Items.blazeUraniumIngot);
            }
            if (Config.disableEnderpearlUraniumFuelCell) {
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, Ic2Items.enderPearlUraniumIngot);
            }
            if (Config.disableNetherStarUraniumFuelCell) {
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, Ic2Items.netherStarUraniumIngot);
            }
            if (Config.disableCharcoalUraniumFuelCell) {
                ClassicRecipes.canningMachine.removeCanningRecipe(Ic2Items.emptyCell, Ic2Items.charcoalUraniumIngot);
            }
        }
    }
}

