/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.zenscript.wrapper;

import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import leviathan143.loottweaker.common.ErrorHandler;
import leviathan143.loottweaker.common.darkmagic.LootTableManagerAccessors;
import leviathan143.loottweaker.common.lib.DataParser;
import leviathan143.loottweaker.common.mutable_loot.MutableLootPool;
import leviathan143.loottweaker.common.mutable_loot.entry.MutableLootEntry;
import leviathan143.loottweaker.common.mutable_loot.entry.MutableLootEntryEmpty;
import leviathan143.loottweaker.common.mutable_loot.entry.MutableLootEntryItem;
import leviathan143.loottweaker.common.mutable_loot.entry.MutableLootEntryTable;
import leviathan143.loottweaker.common.zenscript.LootTweakerContext;
import leviathan143.loottweaker.common.zenscript.wrapper.ZenLootConditionWrapper;
import leviathan143.loottweaker.common.zenscript.wrapper.ZenLootFunctionWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="loottweaker.vanilla.loot.LootPool")
public class ZenLootPoolWrapper {
    private static final String ENTRY_NAME_PREFIX = "loottweaker#";
    private static final int DEFAULT_QUALITY = 0;
    private static final LootCondition[] NO_CONDITIONS = new LootCondition[0];
    private static final LootFunction[] NO_FUNCTIONS = new LootFunction[0];
    private final LootTweakerContext context;
    private final DataParser loggingParser;
    private final List<LootPoolTweaker> tweakers = new ArrayList<LootPoolTweaker>();
    private final ResourceLocation parentTableId;
    private final String id;
    private int nextEntryNameId = 1;

    public ZenLootPoolWrapper(LootTweakerContext context, String id, ResourceLocation parentTableId) {
        this.context = context;
        this.loggingParser = this.createDataParser(context.getErrorHandler());
        this.id = id;
        this.parentTableId = parentTableId;
    }

    private DataParser createDataParser(ErrorHandler errorHandler) {
        return new DataParser(LootTableManagerAccessors.getGsonInstance(), e -> errorHandler.error(e.getMessage()));
    }

    @ZenMethod
    public void addConditionsHelper(ZenLootConditionWrapper[] conditionWrappers) {
        List parsedConditions = Arrays.stream(conditionWrappers).filter(ZenLootConditionWrapper::isValid).map(ZenLootConditionWrapper::unwrap).collect(Collectors.toList());
        this.enqueueTweaker(pool -> pool.addConditions(parsedConditions), "Added %d conditions to pool '%s' of table '%s'", parsedConditions.size(), this.id, this.parentTableId);
    }

    @ZenMethod
    public void addConditionsJson(IData[] conditionsJson) {
        List parsedConditions = Arrays.stream(conditionsJson).map(c -> this.loggingParser.parse((IData)c, LootCondition.class)).filter(java.util.Optional::isPresent).map(java.util.Optional::get).collect(Collectors.toList());
        this.enqueueTweaker(pool -> pool.addConditions(parsedConditions), "Added %d conditions to pool '%s' of table '%s'", parsedConditions.size(), this.id, this.parentTableId);
    }

    @ZenMethod
    public void clearConditions() {
        this.enqueueTweaker(MutableLootPool::clearConditions, "Queuing all conditions of pool %s in table %s for removal", this.id, this.parentTableId);
    }

    @ZenMethod
    public void clearEntries() {
        this.enqueueTweaker(MutableLootPool::clearEntries, "Queuing all entries of pool %s in table %s for removal", this.id, this.parentTableId);
    }

    @ZenMethod
    public void removeEntry(String entryName) {
        this.enqueueTweaker(pool -> {
            if (pool.removeEntry(entryName) == null) {
                this.context.getErrorHandler().error("No entry with name %s exists in pool %s", entryName, this.id);
            }
        }, "Queueing entry %s of pool %s for removal", entryName, this.id);
    }

    @ZenMethod
    public void addItemEntry(IItemStack stack, int weight, @Optional String name) {
        this.addItemEntryInternal(stack, weight, 0, NO_FUNCTIONS, NO_CONDITIONS, name);
    }

    @ZenMethod
    public void addItemEntry(IItemStack stack, int weight, int quality, @Optional String name) {
        this.addItemEntryInternal(stack, weight, quality, NO_FUNCTIONS, NO_CONDITIONS, name);
    }

    @ZenMethod
    public void addItemEntryHelper(IItemStack stack, int weight, int quality, ZenLootFunctionWrapper[] functions, ZenLootConditionWrapper[] conditions, @Optional String name) {
        this.addItemEntryInternal(stack, weight, quality, (LootFunction[])Arrays.stream(functions).filter(ZenLootFunctionWrapper::isValid).map(ZenLootFunctionWrapper::unwrap).toArray(LootFunction[]::new), (LootCondition[])Arrays.stream(conditions).filter(ZenLootConditionWrapper::isValid).map(ZenLootConditionWrapper::unwrap).toArray(LootCondition[]::new), name);
    }

    @ZenMethod
    public void addItemEntryJson(IItemStack stack, int weight, int quality, IData[] functions, IData[] conditions, @Optional String name) {
        LootFunction[] parsedFunctions = (LootFunction[])Arrays.stream(functions).map(c -> this.loggingParser.parse((IData)c, LootFunction.class)).filter(java.util.Optional::isPresent).map(java.util.Optional::get).toArray(LootFunction[]::new);
        LootCondition[] parsedConditions = (LootCondition[])Arrays.stream(conditions).map(c -> this.loggingParser.parse((IData)c, LootCondition.class)).filter(java.util.Optional::isPresent).map(java.util.Optional::get).toArray(LootCondition[]::new);
        this.addItemEntryInternal(stack, weight, quality, parsedFunctions, parsedConditions, name);
    }

    private void addItemEntryInternal(IItemStack stack, int weight, int quality, LootFunction[] functions, LootCondition[] conditions, @Optional String name) {
        if (stack == null) {
            return;
        }
        String entryName = name != null ? name : this.generateName();
        Item item = CraftTweakerMC.getItemStack((IItemStack)stack).func_77973_b();
        MutableLootEntryItem entry = new MutableLootEntryItem(entryName, weight, quality, Lists.newArrayList((Object[])conditions), item, this.withStackFunctions(stack, functions));
        this.addEntry(entry, "Queued item entry '%s' for addition to pool %s of table %s", entryName, this.id, this.parentTableId);
    }

    private List<LootFunction> withStackFunctions(IItemStack iStack, LootFunction[] existingFunctions) {
        ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)iStack);
        boolean sizeFuncExists = false;
        boolean damageFuncExists = false;
        boolean nbtFuncExists = false;
        for (LootFunction lootFunction : existingFunctions) {
            if (lootFunction instanceof SetCount) {
                sizeFuncExists = true;
            }
            if (lootFunction instanceof SetDamage || lootFunction instanceof SetMetadata) {
                damageFuncExists = true;
            }
            if (!(lootFunction instanceof SetNBT)) continue;
            nbtFuncExists = true;
        }
        ArrayList functionsOut = Lists.newArrayListWithCapacity((int)(existingFunctions.length + 3));
        Collections.addAll(functionsOut, existingFunctions);
        if (iStack.getAmount() > 1 && !sizeFuncExists) {
            functionsOut.add(new SetCount(NO_CONDITIONS, new RandomValueRange((float)iStack.getAmount())));
        }
        if (iStack.getDamage() > 0 && !damageFuncExists) {
            functionsOut.add(stack.func_77984_f() ? new SetDamage(NO_CONDITIONS, new RandomValueRange((float)stack.func_77952_i() / (float)stack.func_77958_k())) : new SetMetadata(NO_CONDITIONS, new RandomValueRange((float)iStack.getDamage())));
        }
        if (iStack.getTag() != DataMap.EMPTY && !nbtFuncExists) {
            functionsOut.add(new SetNBT(NO_CONDITIONS, CraftTweakerMC.getNBTCompound((IData)iStack.getTag())));
        }
        return functionsOut;
    }

    @ZenMethod
    public void addLootTableEntry(String tableName, int weight, @Optional String name) {
        this.addLootTableEntry(tableName, weight, 0, name);
    }

    @ZenMethod
    public void addLootTableEntry(String tableName, int weight, int quality, @Optional String name) {
        this.addLootTableEntryInternal(tableName, weight, quality, NO_CONDITIONS, name);
    }

    @ZenMethod
    public void addLootTableEntryHelper(String tableName, int weight, int quality, ZenLootConditionWrapper[] conditions, @Optional String name) {
        this.addLootTableEntryInternal(tableName, weight, quality, (LootCondition[])Arrays.stream(conditions).filter(ZenLootConditionWrapper::isValid).map(ZenLootConditionWrapper::unwrap).toArray(LootCondition[]::new), name);
    }

    @ZenMethod
    public void addLootTableEntryJson(String tableName, int weight, int quality, IData[] conditions, @Optional String name) {
        LootCondition[] parsedConditions = (LootCondition[])Arrays.stream(conditions).map(c -> this.loggingParser.parse((IData)c, LootCondition.class)).filter(java.util.Optional::isPresent).map(java.util.Optional::get).toArray(LootCondition[]::new);
        this.addLootTableEntryInternal(tableName, weight, quality, parsedConditions, name);
    }

    private void addLootTableEntryInternal(String tableName, int weight, int quality, LootCondition[] conditions, @Optional String name) {
        String entryName = name != null ? name : this.generateName();
        this.addEntry(new MutableLootEntryTable(entryName, weight, quality, conditions, new ResourceLocation(tableName)), "Queued loot table entry '%s' for addition to pool %s of table %s", entryName, this.id, this.parentTableId);
    }

    @ZenMethod
    public void addEmptyEntry(int weight, @Optional String name) {
        this.addEmptyEntry(weight, 0, name);
    }

    @ZenMethod
    public void addEmptyEntry(int weight, int quality, @Optional String name) {
        this.addEmptyEntryInternal(weight, quality, NO_CONDITIONS, name);
    }

    @ZenMethod
    public void addEmptyEntryHelper(int weight, int quality, ZenLootConditionWrapper[] conditions, @Optional String name) {
        this.addEmptyEntryInternal(weight, quality, (LootCondition[])Arrays.stream(conditions).filter(ZenLootConditionWrapper::isValid).map(ZenLootConditionWrapper::unwrap).toArray(LootCondition[]::new), name);
    }

    @ZenMethod
    public void addEmptyEntryJson(int weight, int quality, IData[] conditions, @Optional String name) {
        LootCondition[] parsedConditions = (LootCondition[])Arrays.stream(conditions).map(c -> this.loggingParser.parse((IData)c, LootCondition.class)).filter(java.util.Optional::isPresent).map(java.util.Optional::get).toArray(LootCondition[]::new);
        this.addEmptyEntryInternal(weight, quality, parsedConditions, name);
    }

    private void addEmptyEntryInternal(int weight, int quality, LootCondition[] conditions, @Optional String name) {
        String entryName = name != null ? name : this.generateName();
        this.addEntry(new MutableLootEntryEmpty(entryName, weight, quality, conditions), "Queued empty entry '%s' for addition to pool %s of table %s", entryName, this.id, this.parentTableId);
    }

    private String generateName() {
        return ENTRY_NAME_PREFIX + this.nextEntryNameId++;
    }

    @ZenMethod
    public void setRolls(float minRolls, float maxRolls) {
        this.enqueueTweaker(pool -> pool.setRolls(new RandomValueRange(minRolls, maxRolls)), "Rolls of pool %s in table %s will be set to (%.0f, %.0f)", this.id, this.parentTableId, Float.valueOf(minRolls), Float.valueOf(maxRolls));
    }

    @ZenMethod
    public void setBonusRolls(float minBonusRolls, float maxBonusRolls) {
        this.enqueueTweaker(pool -> pool.setBonusRolls(new RandomValueRange(minBonusRolls, maxBonusRolls)), "Bonus rolls of pool %s in table %s will be set to (%.0f, %.0f)", this.id, this.parentTableId, Float.valueOf(minBonusRolls), Float.valueOf(maxBonusRolls));
    }

    private void addEntry(MutableLootEntry<?, ?> entry, String format, Object ... args) {
        this.enqueueTweaker(pool -> {
            if (pool.getEntry(entry.getName()) != null) {
                this.context.getErrorHandler().error("Cannot add entry '%s' to pool '%s' of table '%s'. Entry names must be unique within their pool.", entry.getName(), pool.getName(), this.parentTableId);
                return;
            }
            pool.addEntry(entry);
        }, format, args);
    }

    private void enqueueTweaker(LootPoolTweaker tweaker, String format, Object ... args) {
        this.tweakers.add(tweaker);
        CraftTweakerAPI.logInfo((String)String.format(format, args));
    }

    public void tweak(MutableLootPool pool) {
        for (LootPoolTweaker tweaker : this.tweakers) {
            tweaker.tweak(pool);
        }
    }

    @FunctionalInterface
    public static interface LootPoolTweaker {
        public void tweak(MutableLootPool var1);
    }
}

