/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.zenscript;

import java.util.HashMap;
import java.util.Map;
import leviathan143.loottweaker.common.mutable_loot.MutableLootTable;
import leviathan143.loottweaker.common.zenscript.LootTweakerContext;
import leviathan143.loottweaker.common.zenscript.wrapper.ZenLootTableWrapper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableTweakManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, ZenLootTableWrapper> tweakedTables = new HashMap<ResourceLocation, ZenLootTableWrapper>();
    private final LootTweakerContext context;

    LootTableTweakManager(LootTweakerContext context) {
        this.context = context;
    }

    public ZenLootTableWrapper getTable(String tableName) {
        return this.getTableInternal(tableName);
    }

    public ZenLootTableWrapper getTableUnchecked(String tableName) {
        return this.getTable(tableName);
    }

    private ZenLootTableWrapper getTableInternal(String tableName) {
        ResourceLocation tableId = new ResourceLocation(tableName);
        ZenLootTableWrapper wrapper = this.tweakedTables.get(tableId);
        if (wrapper == null) {
            wrapper = this.context.wrapLootTable(tableId);
            if (!wrapper.isValid()) {
                this.context.getErrorHandler().error("No loot table with name %s exists!", tableName);
            } else {
                this.tweakedTables.put(tableId, wrapper);
            }
        }
        return wrapper;
    }

    public LootTable tweakTable(ResourceLocation tableId, LootTable table) {
        if (this.tweakedTables.containsKey(tableId)) {
            if (table.isFrozen()) {
                LOGGER.debug("Skipped modifying loot table {} because it is frozen", (Object)tableId);
                return table;
            }
            MutableLootTable mutableTable = new MutableLootTable(table, tableId);
            this.tweakedTables.get(tableId).applyTweakers(mutableTable);
            return mutableTable.toImmutable();
        }
        return table;
    }
}

