/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_crop_overrides;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ic2.api.crops.CropCard;
import ic2.api.crops.CropProperties;
import ic2.api.crops.Crops;
import ic2.core.IC2;
import ic2.core.block.crop.Ic2Crops;
import ic2.core.block.crop.crops.CropCardBase;
import ic2.core.block.crop.crops.CropDynamic;
import ic2.core.block.crop.misc.CropLoader;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_crop_overrides.Ic2cCropOverrides;
import trinsdar.ic2c_crop_overrides.Ic2cExtrasCompat;

public class CropJsonLoader
extends CropLoader {
    public static void load(JsonObject obj) {
        boolean reload = false;
        if (obj.has("crops")) {
            for (JsonElement element : obj.getAsJsonArray("crops")) {
                try {
                    CropLoader.CropStage stage;
                    JsonObject subObj = element.getAsJsonObject();
                    CropDynamic.CropInfo info = new CropDynamic.CropInfo();
                    info.name = subObj.get("name").getAsString();
                    info.owner = subObj.get("owner").getAsString();
                    info.id = subObj.get("id").getAsString();
                    CropCardBase old = (CropCardBase)Ic2Crops.instance.getCropCard(info.owner, info.id);
                    if (old == null) {
                        Ic2cCropOverrides.logger.info("Crop Owner & ID not found: [owner=" + info.owner + ", ID=" + info.id + "]");
                        continue;
                    }
                    info.discoverer = subObj.has("discovered") ? subObj.get("discovered").getAsString() : old.getDiscoveredBy();
                    info.harvestChanceMod = subObj.has("dropchance") ? subObj.get("dropchance").getAsDouble() : old.dropGainChance();
                    info.optimalHarvestStage = Math.max(2, subObj.get("optimalstage").getAsInt());
                    info.attributes = subObj.has("attributes") ? CropJsonLoader.parseString(subObj.getAsJsonArray("attributes")) : old.getAttributes();
                    if (subObj.has("props")) {
                        JsonObject props = subObj.getAsJsonObject("props");
                        info.props = new CropProperties(props.get("tier").getAsInt(), props.get("chemistry").getAsInt(), props.get("consumable").getAsInt(), props.get("defensive").getAsInt(), props.get("colorful").getAsInt(), props.get("weed").getAsInt());
                    } else {
                        info.props = old.getProperties();
                    }
                    int stageCount = subObj.has("totalstages") ? subObj.get("totalstages").getAsInt() : old.getMaxSize();
                    Int2ObjectOpenHashMap stageMap = new Int2ObjectOpenHashMap();
                    if (subObj.has("defaultStage")) {
                        stageMap.put(-1, (Object)new CropLoader.CropStage(subObj.getAsJsonObject("defaultStage"), true));
                    }
                    for (JsonElement el : subObj.getAsJsonArray("stages")) {
                        JsonObject test = el.getAsJsonObject();
                        stage = new CropLoader.CropStage(test, false);
                        int myIndex = CropJsonLoader.getMyIndex(stage);
                        stageMap.put(myIndex, (Object)stage);
                    }
                    for (CropLoader.CropStage cropStage : stageMap.values()) {
                        cropStage.evaluateParents((Int2ObjectMap)stageMap);
                    }
                    for (int i = 0; i < stageCount; ++i) {
                        stage = (CropLoader.CropStage)stageMap.get(i + 1);
                        if (stage == null) {
                            Ic2cCropOverrides.logger.info("CropStage: " + (i + 1) + " is not found!");
                            return;
                        }
                        info.stages.add(stage);
                    }
                    if (IC2.platform.isRendering()) {
                        CropLoader.CropStage cropStage;
                        ObjectLinkedOpenHashSet textures = new ObjectLinkedOpenHashSet();
                        cropStage = stageMap.values().iterator();
                        while (cropStage.hasNext()) {
                            CropLoader.CropStage cropStage2 = (CropLoader.CropStage)cropStage.next();
                            textures.addAll(cropStage2.getCropTextures());
                        }
                        Map<ResourceLocation, TextureAtlasSprite> sprites = CropJsonLoader.registerTextures((Set<ResourceLocation>)textures);
                        Crops.instance.registerCropTextures(sprites);
                    }
                    if (info.owner.equals("ic2")) {
                        if (info.id.equalsIgnoreCase("wheat")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropWheat, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("pumpkin")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropPumpkin, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("melon")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropMelon, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("dandelion")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropYellowFlower, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("rose")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropRedFlower, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("blackthorn")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropBlackFlower, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("tulip")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropPurpleFlower, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("cyazint")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropBlueFlower, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("daisy")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropWhiteFlower, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("venomilia")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropVenomilia, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("rainbow")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropRainbowFlower, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("reed")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropReed, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("stickreed")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropStickReed, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("cocoa")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropCocoa, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("ferru")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropFerru, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("malachite")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropMalachite, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("stannum")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropStannum, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("aurelia")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropAurelia, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("argentum")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropArgentum, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("lumilia")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropGlowstone, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("redwheat")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropRedwheat, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("bluewheat")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropBluewheat, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("netherwart")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropNetherWart, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("terrawart")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropTerraWart, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("glowshroom")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropGlowWart, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("coffee")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropCoffee, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("hops")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropHops, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("carrots")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropCarrots, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("potato")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropPotato, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("redmushroom")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropRedMushroom, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("brownmushroom")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropBrownMushroom, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("cacti")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropCacti, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("tea")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropTea, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("hemp")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropHemp, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("beetroots")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropBeetRoot, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("oaksapling")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropOakSapling, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("sprucesapling")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropSpruceSapling, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("birchsapling")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropBirchSapling, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("junglesapling")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropJungleSapling, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("acaciasapling")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropAcaciaSapling, info, subObj);
                            reload = true;
                        }
                        if (info.id.equalsIgnoreCase("dark_oaksapling")) {
                            CropJsonLoader.registerCrop(Ic2Crops.cropDarkOakSapling, info, subObj);
                            reload = true;
                        }
                        if (!info.id.equalsIgnoreCase("plumbilia") || !Loader.isModLoaded((String)"ic2c_extras")) continue;
                        CropJsonLoader.registerCrop(Ic2cExtrasCompat.getCrop(), info, subObj);
                        reload = true;
                        continue;
                    }
                    Ic2cCropOverrides.logger.info("Sorry, Crop with Owner & ID[owner=" + info.owner + ", ID=" + info.id + "]  not supported at this time.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (reload) {
            IC2.platform.reloadLang();
        }
    }

    private static void registerCrop(CropCard card, CropDynamic.CropInfo info, JsonObject subObj) {
        ItemStack stack;
        card = new CropDynamic(info);
        Ic2Crops crop = Ic2Crops.instance;
        crop.registerCrop(card);
        if (subObj.has("display") && !(stack = CropJsonLoader.createStack((JsonObject)subObj.getAsJsonObject("display"))).func_190926_b()) {
            crop.registerCropDisplayItem(card, stack);
        }
    }

    private static String[] parseString(JsonArray array) {
        String[] result = new String[array.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i).getAsString();
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    private static Map<ResourceLocation, TextureAtlasSprite> registerTextures(Set<ResourceLocation> locations) {
        Object2ObjectLinkedOpenHashMap sprites = new Object2ObjectLinkedOpenHashMap();
        for (ResourceLocation location : locations) {
            sprites.put(location, Minecraft.func_71410_x().func_147117_R().func_174942_a(location));
        }
        return sprites;
    }

    private static int getMyIndex(CropLoader.CropStage stage) {
        Field myIndex = null;
        try {
            myIndex = CropLoader.CropStage.class.getDeclaredField("myIndex");
        }
        catch (SecurityException e) {
            Ic2cCropOverrides.logger.info("CropStage security deployed");
        }
        catch (NoSuchFieldException e) {
            Ic2cCropOverrides.logger.info("Trying to access CropStage value has failed");
        }
        if (myIndex != null) {
            myIndex.setAccessible(true);
        }
        int copy = 0;
        try {
            if (myIndex != null) {
                copy = (Integer)myIndex.get(stage);
            }
        }
        catch (IllegalArgumentException e) {
            Ic2cCropOverrides.logger.info("Accessed CropStage class but field getter failed");
        }
        catch (IllegalAccessException e) {
            Ic2cCropOverrides.logger.info("Accessed CropStage class but access denied");
        }
        return copy;
    }

    public static class CropStageOverride
    extends CropLoader.CropStage {
        int myIndex;

        public CropStageOverride(JsonObject obj, boolean defaultStage) {
            super(obj, defaultStage);
            this.myIndex = defaultStage ? -1 : MathHelper.func_76125_a((int)obj.get("index").getAsInt(), (int)0, (int)Integer.MAX_VALUE);
        }
    }
}

