/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.util;

import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import thaumcraft.api.aspects.Aspect;

public class EssentiaFilter
implements INBTSerializable<NBTTagCompound>,
Iterable<Aspect> {
    private Aspect[] aspects;

    public EssentiaFilter(int slots) {
        this.aspects = new Aspect[slots];
    }

    public void setAspect(Aspect aspect, int slot) {
        this.aspects[slot] = aspect;
        this.onContentsChanged();
    }

    public Aspect getAspect(int slot) {
        if (slot < 0 || slot > this.aspects.length) {
            return null;
        }
        return this.aspects[slot];
    }

    public boolean isInFilter(Aspect aspect) {
        return this.isInFilter(aspect.getTag());
    }

    public boolean isInFilter(String aspect) {
        for (Aspect af : this.aspects) {
            if (af == null || !af.getTag().equalsIgnoreCase(aspect)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAspects() {
        for (Aspect a : this.aspects) {
            if (a == null) continue;
            return true;
        }
        return false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("count", this.aspects.length);
        for (int i = 0; i < this.aspects.length; ++i) {
            if (this.aspects[i] == null) continue;
            tag.func_74778_a("aspect#" + i, this.aspects[i].getTag());
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("count")) {
            this.aspects = new Aspect[tag.func_74762_e("count")];
        }
        for (int i = 0; i < this.aspects.length; ++i) {
            if (!tag.func_74764_b("aspect#" + i)) continue;
            this.aspects[i] = Aspect.getAspect((String)tag.func_74779_i("aspect#" + i));
        }
        this.onContentsChanged();
    }

    protected void onContentsChanged() {
    }

    @Override
    @Nonnull
    public Iterator<Aspect> iterator() {
        return Arrays.asList(this.aspects).iterator();
    }
}

