/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.items.contents.CellUpgrades;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.items.IItemHandler;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.storage.IAEEssentiaStack;
import thaumicenergistics.api.storage.IEssentiaStorageChannel;
import thaumicenergistics.client.render.IThEModel;
import thaumicenergistics.init.ModGlobals;
import thaumicenergistics.item.ItemBase;
import thaumicenergistics.util.inventory.EssentiaCellConfig;

public class ItemEssentiaCell
extends ItemBase
implements IStorageCell<IAEEssentiaStack>,
IThEModel {
    private String size;
    private int bytes;
    private int types;

    public ItemEssentiaCell(String size, int bytes, int types) {
        super("essentia_cell_" + size);
        this.size = size;
        this.bytes = bytes;
        this.types = types;
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(false);
        this.func_77637_a(ModGlobals.CREATIVE_TAB);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!player.func_70093_af()) {
            return super.func_77659_a(world, player, hand);
        }
        ItemStack held = player.func_184586_b(hand);
        if (held.func_190926_b()) {
            return super.func_77659_a(world, player, hand);
        }
        ICellInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(held, null, (IStorageChannel)this.getChannel());
        if (handler == null) {
            throw new NullPointerException("Couldn't get ICellInventoryHandler for Essentia Cell");
        }
        if (!handler.getAvailableItems(this.getChannel().createList()).isEmpty()) {
            return super.func_77659_a(world, player, hand);
        }
        Optional<ItemStack> cellComponent = this.getComponentOfCell(held);
        Optional emptyCasing = AEApi.instance().definitions().materials().emptyStorageCell().maybeStack(1);
        if (!cellComponent.isPresent() || !emptyCasing.isPresent()) {
            return super.func_77659_a(world, player, hand);
        }
        InventoryPlayer inv = player.field_71071_by;
        if (hand == EnumHand.MAIN_HAND) {
            inv.func_70299_a(inv.field_70461_c, ItemStack.field_190927_a);
        }
        if (!inv.func_70441_a(cellComponent.get())) {
            player.func_71019_a(cellComponent.get(), false);
        }
        if (!inv.func_70441_a((ItemStack)emptyCasing.get())) {
            player.func_71019_a((ItemStack)emptyCasing.get(), false);
        }
        if (player.field_71069_bz != null) {
            player.field_71069_bz.func_75142_b();
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)ItemStack.field_190927_a);
    }

    private Optional<ItemStack> getComponentOfCell(ItemStack stack) {
        Preconditions.checkNotNull((Object)stack);
        Preconditions.checkNotNull((Object)stack.func_77973_b());
        Preconditions.checkNotNull((Object)stack.func_77973_b().getRegistryName());
        Preconditions.checkNotNull((Object)stack.func_77973_b().getRegistryName().func_110623_a());
        switch (stack.func_77973_b().getRegistryName().func_110623_a().split("_")[2]) {
            case "1k": {
                return ThEApi.instance().items().essentiaComponent1k().maybeStack(1);
            }
            case "4k": {
                return ThEApi.instance().items().essentiaComponent4k().maybeStack(1);
            }
            case "16k": {
                return ThEApi.instance().items().essentiaComponent16k().maybeStack(1);
            }
            case "64k": {
                return ThEApi.instance().items().essentiaComponent64k().maybeStack(1);
            }
        }
        return Optional.empty();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ICellInventoryHandler cellInventory = AEApi.instance().registries().cell().getCellInventory(stack, null, (IStorageChannel)this.getChannel());
        AEApi.instance().client().addCellInformation(cellInventory, tooltip);
    }

    public int getBytes(ItemStack itemStack) {
        return this.bytes;
    }

    public int getBytesPerType(ItemStack itemStack) {
        return 8;
    }

    public int getTotalTypes(ItemStack itemStack) {
        return this.types;
    }

    public boolean isBlackListed(ItemStack itemStack, IAEEssentiaStack iaeEssentiaStack) {
        return false;
    }

    public boolean storableInStorageCell() {
        return false;
    }

    public boolean isStorageCell(ItemStack itemStack) {
        return true;
    }

    public double getIdleDrain() {
        return 1.0;
    }

    public IEssentiaStorageChannel getChannel() {
        return (IEssentiaStorageChannel)AEApi.instance().storage().getStorageChannel(IEssentiaStorageChannel.class);
    }

    public boolean isEditable(ItemStack itemStack) {
        return true;
    }

    public IItemHandler getUpgradesInventory(ItemStack itemStack) {
        return new CellUpgrades(itemStack, 0);
    }

    public IItemHandler getConfigInventory(ItemStack itemStack) {
        return new EssentiaCellConfig(itemStack);
    }

    public FuzzyMode getFuzzyMode(ItemStack itemStack) {
        return FuzzyMode.IGNORE_ALL;
    }

    public void setFuzzyMode(ItemStack itemStack, FuzzyMode fuzzyMode) {
    }

    @Override
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("thaumicenergistics:cell/essentia_cell_" + this.size, "inventory"));
    }
}

