/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client.gui.component.impl;

import io.github.phantamanta44.libnine.client.gui.component.GuiComponent;
import io.github.phantamanta44.libnine.util.function.IFloatSupplier;
import io.github.phantamanta44.libnine.util.render.TextureRegion;
import java.util.function.Supplier;

public class GuiComponentVerticalBar
extends GuiComponent {
    private final TextureRegion bg;
    private final TextureRegion fg;
    private final int innerX;
    private final int innerY;
    private final int innerWidth;
    private final int innerHeight;
    private final IFloatSupplier dataSrc;
    private final Supplier<String> ttSrc;

    public GuiComponentVerticalBar(int x, int y, TextureRegion bg, TextureRegion fg, int offsetX, int offsetY, IFloatSupplier dataSrc, Supplier<String> ttSrc) {
        super(x, y, bg.getWidth(), bg.getHeight());
        this.bg = bg;
        this.fg = fg;
        this.innerX = x + offsetX;
        this.innerY = y + offsetY;
        this.innerWidth = this.width - 2 * offsetX;
        this.innerHeight = this.height - 2 * offsetY;
        this.dataSrc = dataSrc;
        this.ttSrc = ttSrc;
    }

    @Override
    public void render(float partialTicks, int mX, int mY, boolean mouseOver) {
        this.bg.draw(this.x, this.y, this.width, this.height);
        this.fg.drawPartial(this.innerX, this.innerY, this.innerWidth, this.innerHeight, 0.0f, 1.0f - this.dataSrc.get(), 1.0f, 1.0f);
    }

    @Override
    public void renderTooltip(float partialTicks, int mX, int mY) {
        this.drawTooltip(this.ttSrc.get(), mX, mY);
    }
}

