/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.enchantingtable.capability;

import net.crazysnailboy.mods.enchantingtable.capability.ILapisHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapabilityHandler {
    @CapabilityInject(value=ILapisHandler.class)
    public static final Capability<ILapisHandler> LAPIS_HANDLER_CAPABILITY = null;
    public static final EnumFacing DEFAULT_FACING = null;

    @Mod.EventBusSubscriber
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityPlayer) {
                event.addCapability(new ResourceLocation("csb_ench_table", "PlayerLapis"), (ICapabilityProvider)new Provider());
            }
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            ILapisHandler oldHandler = (ILapisHandler)event.getOriginal().getCapability(LAPIS_HANDLER_CAPABILITY, null);
            ILapisHandler newHandler = (ILapisHandler)event.getEntityPlayer().getCapability(LAPIS_HANDLER_CAPABILITY, null);
            ItemStack lapisStack = oldHandler.extractItem(0, 64, false);
            if (!lapisStack.func_190926_b()) {
                newHandler.insertItem(0, lapisStack, false);
            }
        }
    }

    public static class Storage
    implements Capability.IStorage<ILapisHandler> {
        public NBTBase writeNBT(Capability<ILapisHandler> capability, ILapisHandler instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<ILapisHandler> capability, ILapisHandler instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        private ILapisHandler instance = (ILapisHandler)LAPIS_HANDLER_CAPABILITY.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == LAPIS_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == LAPIS_HANDLER_CAPABILITY ? LAPIS_HANDLER_CAPABILITY.cast((Object)this.instance) : null);
        }

        public NBTBase serializeNBT() {
            return LAPIS_HANDLER_CAPABILITY.getStorage().writeNBT(LAPIS_HANDLER_CAPABILITY, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            LAPIS_HANDLER_CAPABILITY.getStorage().readNBT(LAPIS_HANDLER_CAPABILITY, (Object)this.instance, null, nbt);
        }
    }
}

