/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.core.AELog;
import appeng.core.worlddata.IOnWorldStartable;
import appeng.core.worlddata.IOnWorldStoppable;
import appeng.core.worlddata.IWorldGridStorageData;
import appeng.me.GridStorage;
import appeng.me.GridStorageSearch;
import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

final class StorageData
implements IWorldGridStorageData,
IOnWorldStartable,
IOnWorldStoppable {
    private static final String LAST_GRID_STORAGE_CATEGORY = "Counters";
    private static final String LAST_GRID_STORAGE_KEY = "lastGridStorage";
    private static final int LAST_GRID_STORAGE_DEFAULT = 0;
    private static final String GRID_STORAGE_CATEGORY = "gridstorage";
    private final Map<GridStorageSearch, WeakReference<GridStorageSearch>> loadedStorage = new WeakHashMap<GridStorageSearch, WeakReference<GridStorageSearch>>(10);
    private final Configuration config;
    private long lastGridStorage;

    public StorageData(@Nonnull Configuration settingsFile) {
        Preconditions.checkNotNull((Object)settingsFile);
        this.config = settingsFile;
    }

    @Override
    @Nullable
    public GridStorage getGridStorage(long storageID) {
        GridStorageSearch gss = new GridStorageSearch(storageID);
        WeakReference<GridStorageSearch> result = this.loadedStorage.get(gss);
        if (result == null || result.get() == null) {
            String id = String.valueOf(storageID);
            String data = this.config.get(GRID_STORAGE_CATEGORY, id, "").getString();
            GridStorage thisStorage = new GridStorage(data, storageID, gss);
            gss.setGridStorage(new WeakReference<GridStorage>(thisStorage));
            this.loadedStorage.put(gss, new WeakReference<GridStorageSearch>(gss));
            return thisStorage;
        }
        return (GridStorage)((GridStorageSearch)result.get()).getGridStorage().get();
    }

    @Override
    @Nonnull
    public GridStorage getNewGridStorage() {
        long storageID = this.nextGridStorage();
        GridStorageSearch gss = new GridStorageSearch(storageID);
        GridStorage newStorage = new GridStorage(storageID, gss);
        gss.setGridStorage(new WeakReference<GridStorage>(newStorage));
        this.loadedStorage.put(gss, new WeakReference<GridStorageSearch>(gss));
        return newStorage;
    }

    @Override
    public long nextGridStorage() {
        long r = this.lastGridStorage++;
        this.config.get(LAST_GRID_STORAGE_CATEGORY, LAST_GRID_STORAGE_KEY, (double)this.lastGridStorage).set(Long.toString(this.lastGridStorage));
        return r;
    }

    @Override
    public void destroyGridStorage(long id) {
        String stringID = String.valueOf(id);
        this.config.getCategory(GRID_STORAGE_CATEGORY).remove((Object)stringID);
    }

    @Override
    public int getNextOrderedValue(String name) {
        Property p = this.config.get("orderedValues", name, 0);
        int myValue = p.getInt();
        p.set(myValue + 1);
        return myValue;
    }

    @Override
    public void onWorldStart() {
        String lastString = this.config.get(LAST_GRID_STORAGE_CATEGORY, LAST_GRID_STORAGE_KEY, 0).getString();
        try {
            this.lastGridStorage = Long.parseLong(lastString);
        }
        catch (NumberFormatException err) {
            AELog.warn("The config contained a value which was not represented as a Long: %s", lastString);
            this.lastGridStorage = 0L;
        }
    }

    @Override
    public void onWorldStop() {
        for (GridStorageSearch gs : this.loadedStorage.keySet()) {
            GridStorage thisStorage = (GridStorage)gs.getGridStorage().get();
            if (thisStorage == null || thisStorage.getGrid() == null || thisStorage.getGrid().isEmpty()) continue;
            String value = thisStorage.getValue();
            this.config.get(GRID_STORAGE_CATEGORY, String.valueOf(thisStorage.getID()), value).set(value);
        }
        this.config.save();
    }
}

