/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.util;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ConjoinedItemHandler
implements IItemHandler {
    private final List<IItemHandler> delegates;
    private final int[] thresholds;

    public ConjoinedItemHandler(List<IItemHandler> delegates) {
        this.delegates = delegates;
        this.thresholds = new int[delegates.size()];
        if (!delegates.isEmpty()) {
            this.thresholds[0] = delegates.get(0).getSlots();
            for (int i = 1; i < this.thresholds.length; ++i) {
                this.thresholds[i] = this.thresholds[i - 1] + delegates.get(i).getSlots();
            }
        }
    }

    public int getSlots() {
        return this.delegates.stream().mapToInt(IItemHandler::getSlots).sum();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int ihIndex = this.getItemHandler(slot);
        return this.delegates.get(ihIndex).getStackInSlot(slot - this.getBaseSlot(ihIndex));
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int ihIndex = this.getItemHandler(slot);
        return this.delegates.get(ihIndex).insertItem(slot - this.getBaseSlot(ihIndex), stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int ihIndex = this.getItemHandler(slot);
        return this.delegates.get(ihIndex).extractItem(slot - this.getBaseSlot(ihIndex), amount, simulate);
    }

    public int getSlotLimit(int slot) {
        int ihIndex = this.getItemHandler(slot);
        return this.delegates.get(ihIndex).getSlotLimit(slot - this.getBaseSlot(ihIndex));
    }

    private int getItemHandler(int index) {
        for (int i = 0; i < this.thresholds.length; ++i) {
            if (index >= this.thresholds[i]) continue;
            return i;
        }
        int slotCount = this.getSlots();
        if (slotCount == 0) {
            throw new IndexOutOfBoundsException(String.format("%d is not a slot in an empty inventory!", index));
        }
        throw new IndexOutOfBoundsException(String.format("%d is not in slot indices [0, %d)!", index, slotCount));
    }

    private int getBaseSlot(int ihIndex) {
        return ihIndex == 0 ? 0 : this.thresholds[ihIndex - 1];
    }
}

