/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.tile.base;

import io.github.phantamanta44.libnine.LibNine;
import io.github.phantamanta44.libnine.capability.impl.L9AspectSlot;
import io.github.phantamanta44.libnine.recipe.IRcp;
import io.github.phantamanta44.libnine.recipe.input.IRcpIn;
import io.github.phantamanta44.libnine.recipe.output.IRcpOut;
import io.github.phantamanta44.libnine.util.TriBool;
import io.github.phantamanta44.libnine.util.collection.Accrue;
import io.github.phantamanta44.libnine.util.data.serialization.AutoSerialize;
import io.github.phantamanta44.libnine.util.world.BlockSide;
import io.github.phantamanta44.libnine.util.world.IAllocableSides;
import io.github.phantamanta44.threng.tile.base.IDroppableInventory;
import io.github.phantamanta44.threng.tile.base.TileMachine;
import io.github.phantamanta44.threng.util.AppEngUtils;
import io.github.phantamanta44.threng.util.InvUtils;
import io.github.phantamanta44.threng.util.SlotType;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public abstract class TileSimpleProcessor<IT, OT, I extends IRcpIn<IT>, O extends IRcpOut<OT>, R extends IRcp<IT, I, O>>
extends TileMachine
implements IAllocableSides<SlotType.BasicIO>,
IDroppableInventory {
    private final Class<R> recipeType;
    @AutoSerialize(sync=false)
    private final L9AspectSlot slotUpgrade = new UpgradeSlot(this);
    private TriBool canWork = TriBool.NONE;
    @Nullable
    private R activeRecipe = null;
    @Nullable
    private O activeRecipeOutput = null;
    private int maxWork = -1;
    private int energyCost = -1;

    public TileSimpleProcessor(Class<R> recipeType, int energyBuffer) {
        super(energyBuffer);
        this.recipeType = recipeType;
    }

    protected abstract IAllocableSides<SlotType.BasicIO> getSidedIo();

    public void setFace(BlockSide face, SlotType.BasicIO state) {
        this.getSidedIo().setFace(face, (Enum)state);
        this.setDirty();
    }

    public SlotType.BasicIO getFace(BlockSide face) {
        return (SlotType.BasicIO)this.getSidedIo().getFace(face);
    }

    @Override
    protected boolean canWork() {
        if (this.canWork == TriBool.NONE) {
            IT input = this.getInput();
            IRcp newRecipe = LibNine.PROXY.getRecipeManager().getRecipeList(this.recipeType).findRecipe(input);
            if (newRecipe != null) {
                if (newRecipe != this.activeRecipe) {
                    this.activeRecipe = newRecipe;
                    this.resetWork();
                }
                this.activeRecipeOutput = this.activeRecipe.mapToOutput(input);
                this.canWork = TriBool.wrap((boolean)this.activeRecipeOutput.isAcceptable(this.getOutputEnvironment()));
            } else {
                this.activeRecipe = null;
                this.canWork = TriBool.FALSE;
            }
        }
        return this.canWork.value;
    }

    @Override
    protected int getDeltaWork() {
        return 1;
    }

    @Override
    protected int getMaxWork() {
        if (this.maxWork == -1) {
            this.maxWork = 150 - 18 * this.getUpgradeCount();
        }
        return this.maxWork;
    }

    @Override
    protected int getEnergyCost() {
        if (this.energyCost == -1) {
            this.energyCost = (this.getBaseEnergyPerOperation() + this.getUpgradeEnergyCost()) / this.getMaxWork();
        }
        return this.energyCost;
    }

    private int getUpgradeCount() {
        ItemStack stack = this.slotUpgrade.getStackInSlot();
        return stack.func_190926_b() ? 0 : stack.func_190916_E();
    }

    @Override
    protected void onWorkFinished() {
        this.acceptOutput(((IRcp)Objects.requireNonNull(this.activeRecipe)).input().consume(this.getInput()), (IRcpOut)Objects.requireNonNull(this.activeRecipeOutput));
    }

    protected void markWorkStateDirty() {
        this.canWork = TriBool.NONE;
    }

    protected int getBaseEnergyPerOperation() {
        return 8100;
    }

    protected int getUpgradeEnergyCost() {
        return 863 * this.getUpgradeCount();
    }

    protected abstract IT getInput();

    protected abstract OT getOutputEnvironment();

    protected abstract void acceptOutput(IT var1, O var2);

    public L9AspectSlot getUpgradeSlot() {
        return this.slotUpgrade;
    }

    @Override
    public void collectDrops(Accrue<ItemStack> drops) {
        InvUtils.accrue(drops, new IItemHandler[]{this.slotUpgrade});
    }

    private static class UpgradeSlot
    extends L9AspectSlot.Observable {
        UpgradeSlot(TileSimpleProcessor<?, ?, ?, ?, ?> tile) {
            super(AppEngUtils.IS_UPGRADE_ACCEL, (s, o, n) -> ((TileSimpleProcessor)tile).maxWork = (((TileSimpleProcessor)tile).energyCost = -1));
        }

        public int getSlotLimit() {
            return 8;
        }
    }
}

